/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.util;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.servicedesk.internal.util.CheckedSoyTemplateRendererAnalyticsHelper;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class CheckedSoyTemplateRendererImpl
implements com.atlassian.servicedesk.internal.api.util.SoyTemplateRenderer {
    private static final String COMPONENT_MODULE_KEY_PREFIX = "com.atlassian.servicedesk.";
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final CheckedSoyTemplateRendererAnalyticsHelper analyticsHelper;
    private static final Set<String> SD_PLUGIN_SOY_NAMESPACE_WHITELIST = ImmutableSet.of((Object)"ServiceDesk.Comment.Field", (Object)"ServiceDesk.Customer.Feature.ParticipantsPicker.templates", (Object)"ServiceDesk.Customer.Feature.RequestsList.Templates", (Object)"ServiceDesk.Customer.Feature.SearchFilter.Templates", (Object)"ServiceDesk.Customer.Feature.UserPicker.Templates", (Object)"ServiceDesk.Customer.Layout.Page.DefaultPage.Templates", (Object[])new String[]{"ServiceDesk.Customer.Layout.Page.RequestsPage.Templates", "ServiceDesk.Jira.Mail", "ServiceDesk.Templates.Admin", "ServiceDesk.Templates.Admin.CreateKB", "ServiceDesk.Templates.Admin.config", "ServiceDesk.Templates.Admin.email", "ServiceDesk.Templates.Agent.Customer.Issue", "ServiceDesk.Templates.Agent.RestfulTable", "ServiceDesk.Templates.Agent.SetPassword", "ServiceDesk.Templates.Agent.Settings.Automation.Blueprints.Help", "ServiceDesk.Templates.Agent.Settings.Automation.Modules.When", "ServiceDesk.Templates.Attachments", "ServiceDesk.Templates.ColumnPicker", "ServiceDesk.Templates.Components", "ServiceDesk.Templates.Components.AlertDialog", "ServiceDesk.Templates.Components.MailLog", "ServiceDesk.Templates.Components.Participants", "ServiceDesk.Templates.Components.RequestTypeIcons", "ServiceDesk.Templates.Components.RestfulTable.Fields.User", "ServiceDesk.Templates.Components.RestfulTable.Fields.UserGroup", "ServiceDesk.Templates.Conversational", "ServiceDesk.Templates.Conversational.Common", "ServiceDesk.Templates.Conversational.Customer", "ServiceDesk.Templates.CustomFields.CustomerRequestType", "ServiceDesk.Templates.Customer", "ServiceDesk.Templates.Customer.AddParticipants", "ServiceDesk.Templates.Customer.Common.Request", "ServiceDesk.Templates.Customer.Feature.Onboarding", "ServiceDesk.Templates.Customer.HelpCenterBranding", "ServiceDesk.Templates.Customer.KBDialogView", "ServiceDesk.Templates.Customer.Layouts.Page", "ServiceDesk.Templates.Customer.SmartPortal", "ServiceDesk.Templates.Customer.SmartPortal.SinglePortal", "ServiceDesk.Templates.Customer.Unsubscribe", "ServiceDesk.Templates.CustomerFields.RequestTypeSelector", "ServiceDesk.Templates.Errors", "ServiceDesk.Templates.Feature.WebPanel", "ServiceDesk.Templates.Feedback", "ServiceDesk.Templates.FirstLoginErrors", "ServiceDesk.Templates.HelpBubble", "ServiceDesk.Templates.InlineEdit", "ServiceDesk.Templates.KBFeedbackCollector", "ServiceDesk.Templates.KbSearcher", "ServiceDesk.Templates.Notifications.Approvals", "ServiceDesk.Templates.Notifications.Custom", "ServiceDesk.Templates.Password.Util", "ServiceDesk.Templates.RequestFeedback", "ServiceDesk.Templates.SearchInput", "ServiceDesk.Templates.Shared.AvatarPicker", "ServiceDesk.Templates.Shared.FeedbackCollector", "ServiceDesk.Templates.Shared.Precondition", "ServiceDesk.Templates.Shared.Spinners", "ServiceDesk.Templates.Shared.Utils", "ServiceDesk.Templates.Shared.ValidatingList", "ServiceDesk.Templates.SlaView", "ServiceDesk.Templates.TotalMessage", "ServiceDesk.Templates.TotalResultMessage", "ServiceDesk.Util.Files.DragDrop", "Viewport.Templates.AgentNotifications", "Viewport.Templates.CommonNotifications", "Viewport.Templates.IssueNotifications", "Viewport.Templates.UserNotifications"});

    @Autowired
    public CheckedSoyTemplateRendererImpl(SoyTemplateRenderer soyTemplateRenderer, CheckedSoyTemplateRendererAnalyticsHelper analyticsHelper) {
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.analyticsHelper = analyticsHelper;
    }

    public void clearAllCaches() {
        this.soyTemplateRenderer.clearAllCaches();
    }

    public void clearCache(String completeModuleKey) {
        this.soyTemplateRenderer.clearCache(completeModuleKey);
    }

    public String render(String completeModuleKey, String templateName, Map<String, Object> data) throws SoyException {
        this.checkedTemplateAccess(completeModuleKey, templateName);
        return this.soyTemplateRenderer.render(completeModuleKey, templateName, data);
    }

    public void render(Appendable appendable, String completeModuleKey, String templateName, Map<String, Object> data) throws SoyException {
        this.checkedTemplateAccess(completeModuleKey, templateName);
        this.soyTemplateRenderer.render(appendable, completeModuleKey, templateName, data);
    }

    public void render(Appendable appendable, String completeModuleKey, String templateName, Map<String, Object> data, Map<String, Object> injectedData) throws SoyException {
        this.checkedTemplateAccess(completeModuleKey, templateName);
        this.soyTemplateRenderer.render(appendable, completeModuleKey, templateName, data, injectedData);
    }

    private void checkedTemplateAccess(String completeModuleKey, String templateName) {
        if (this.isImproperTemplateAccess(completeModuleKey, templateName)) {
            this.analyticsHelper.fireAnalyticsEvent(completeModuleKey, templateName);
        }
    }

    private boolean isImproperTemplateAccess(String completeModuleKey, String templateName) {
        if (this.isPotentialMainPluginAccess(completeModuleKey)) {
            String templateNamespace = this.getNamespaceFromTemplateName(templateName);
            return !SD_PLUGIN_SOY_NAMESPACE_WHITELIST.contains(templateNamespace);
        }
        return false;
    }

    private String getNamespaceFromTemplateName(String templateName) {
        int namespaceEndPos = templateName.lastIndexOf(".");
        if (namespaceEndPos == -1) {
            return templateName;
        }
        return templateName.substring(0, namespaceEndPos);
    }

    private boolean isPotentialMainPluginAccess(String completeModuleKey) {
        return !completeModuleKey.contains(COMPONENT_MODULE_KEY_PREFIX);
    }
}

