/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.user.permission.roles;

import com.google.common.collect.ImmutableList;
import io.atlassian.fugue.Option;
import java.util.List;
import java.util.Objects;

public enum ServiceDeskProjectRole {
    CUSTOMER("Service Desk Customers"),
    TEAM("Service Desk Team"),
    ADMIN("Administrators"),
    COLLABORATOR("Service Desk Collaborators");

    private static final List<ServiceDeskProjectRole> VALUES;
    private final String rolename;

    private ServiceDeskProjectRole(String rolename) {
        this.rolename = rolename;
    }

    public String getRolename() {
        return this.rolename;
    }

    public static Option<ServiceDeskProjectRole> fromRolename(String rolename) {
        for (ServiceDeskProjectRole role : VALUES) {
            if (!Objects.equals(role.getRolename(), rolename)) continue;
            return Option.some((Object)((Object)role));
        }
        return Option.none();
    }

    static {
        VALUES = ImmutableList.copyOf((Object[])ServiceDeskProjectRole.values());
    }
}

