/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.user.external;

import com.atlassian.jira.security.auth.Authorisation;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.internal.api.license.ServiceDeskOperationalStatus;
import com.atlassian.servicedesk.internal.user.external.ExternalCustomerAccessService;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ServiceDeskAuthorisation
implements Authorisation {
    protected static final Logger log = LoggerFactory.getLogger(ServiceDeskAuthorisation.class);
    private final ExternalCustomerAccessService externalCustomerAccessService;
    private final ServiceDeskOperationalStatus serviceDeskOperationalStatus;

    @Autowired
    public ServiceDeskAuthorisation(ExternalCustomerAccessService externalCustomerAccessService, ServiceDeskOperationalStatus serviceDeskOperationalStatus) {
        this.externalCustomerAccessService = externalCustomerAccessService;
        this.serviceDeskOperationalStatus = serviceDeskOperationalStatus;
    }

    public Authorisation.Decision authoriseForLogin(@Nonnull ApplicationUser user, HttpServletRequest httpServletRequest) {
        log.debug("authoriseForLogin for {}", (Object)user.getName());
        if (this.isExternalCustomerAuthorised(user)) {
            log.debug("authoriseForLogin granted");
            return Authorisation.Decision.GRANTED;
        }
        log.debug("authoriseForLogin abstain");
        return Authorisation.Decision.ABSTAIN;
    }

    private boolean isExternalCustomerAuthorised(ApplicationUser user) {
        boolean operational = this.serviceDeskOperationalStatus.isOperational();
        if (!operational) {
            log.debug("abstaining as servicedesk isn't operational yet");
            return false;
        }
        return this.externalCustomerAccessService.isAuthorisedByServiceDesk(user);
    }

    public Set<String> getRequiredRoles(HttpServletRequest httpServletRequest) {
        return Collections.emptySet();
    }

    public Authorisation.Decision authoriseForRole(@Nullable ApplicationUser user, HttpServletRequest httpServletRequest, String role) {
        return Authorisation.Decision.ABSTAIN;
    }
}

