/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.user.external;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.api.customer.CustomerContextService;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.permission.security.CustomerInvolvedService;
import com.atlassian.servicedesk.internal.api.portal.PortalManager;
import com.atlassian.servicedesk.internal.customer.context.urimatching.UriMatch;
import com.atlassian.servicedesk.internal.customer.context.urimatching.UriMatcher;
import com.atlassian.servicedesk.internal.feature.jira.issue.ServiceDeskIssueManager;
import com.atlassian.servicedesk.internal.user.external.ExternalCustomerAccessService;
import com.atlassian.servicedesk.internal.user.permission.ServiceDeskPermissions;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class ExternalCustomerAccessServiceImpl
implements ExternalCustomerAccessService {
    protected static final Logger log = LoggerFactory.getLogger(ExternalCustomerAccessServiceImpl.class);
    private static final String DEFAULT_PORTAL_URL = "/servicedesk/customer/portals";
    private static final UriMatcher WHITELIST_URI_MATCHER = new UriMatcher((ImmutableList<UriMatch>)ImmutableList.of((Object)UriMatch.builder().startsWith("/download").addPattern("/.*").build(), (Object)UriMatch.builder().startsWith("/s").addPattern("/.*").build(), (Object)UriMatch.builder().startsWith("/images").addPattern(".*").build(), (Object)UriMatch.builder().startsWith("/secure/useravatar").addPattern(".*").build(), (Object)UriMatch.builder().startsWith("/static-assets").addPattern(".*").build(), (Object)UriMatch.builder().setBlackList().startsWith("/rest").addPattern("/api/.*").addPattern("/servicedesk/.*").addPattern("/workinghours/.*").addPattern("/jira-email-processor-plugin/.*").addPattern("/internal/.*").addPattern("/auth/.*").build(), (Object)UriMatch.builder().startsWith("/rest").addPattern("/.*").build()));
    private final UserFactory userFactory;
    private final ServiceDeskPermissions serviceDeskPermissions;
    private final CustomerContextService customerContextService;
    private final ServiceDeskIssueManager serviceDeskIssueManager;
    private final CustomerInvolvedService customerInvolvedService;
    private final PortalManager portalManager;

    @Autowired
    public ExternalCustomerAccessServiceImpl(CustomerContextService customerContextService, UserFactory UserFactory2, ServiceDeskPermissions serviceDeskPermissions, ServiceDeskIssueManager serviceDeskIssueManager, CustomerInvolvedService customerInvolvedService, PortalManager portalManager) {
        this.customerContextService = customerContextService;
        this.userFactory = UserFactory2;
        this.serviceDeskPermissions = serviceDeskPermissions;
        this.serviceDeskIssueManager = serviceDeskIssueManager;
        this.customerInvolvedService = customerInvolvedService;
        this.portalManager = portalManager;
    }

    @Override
    public boolean canExecuteRequest(ApplicationUser user, HttpServletRequest request) {
        String requestUrl = this.requestUrlWithoutContextPath(request);
        return this.executeAndLog(this.isAnonymous(user), "Anonymous", user, requestUrl) || this.executeAndLog(this.isInCustomerContext(), "In portal", user, requestUrl) || this.executeAndLog(this.isInWhiteList(requestUrl), "In whitelist", user, requestUrl) || this.executeAndLog(!this.hasExternalCustomerAccess(user), "Internal customer", user, requestUrl);
    }

    @Override
    public String generateRedirectUrl(HttpServletRequest request) {
        return (String)this.getIssue(request).filter(this::currentUserCanAccessRequest).flatMap(this::generatePortalUrlForIssue).getOrElse((Object)DEFAULT_PORTAL_URL);
    }

    @Override
    public boolean isAuthorisedByServiceDesk(ApplicationUser user) {
        boolean result = this.hasExternalCustomerAccess(user);
        log.debug("isAuthorisedByServiceDesk: {}", (Object)result);
        return result;
    }

    private String requestUrlWithoutContextPath(HttpServletRequest request) {
        String contextPath = request.getContextPath();
        return request.getRequestURI().replaceFirst(contextPath, "");
    }

    private boolean isAnonymous(ApplicationUser user) {
        return user == null;
    }

    private boolean hasExternalCustomerAccess(ApplicationUser user) {
        return this.userFactory.wrap(user).exists(this.serviceDeskPermissions::hasExternalCustomerAccess);
    }

    private Option<Issue> getIssue(HttpServletRequest request) {
        return Option.option((Object)request.getParameter("issueKey")).map(this.serviceDeskIssueManager::getIssueByKey).flatMap(Either::toOption);
    }

    private boolean currentUserCanAccessRequest(Issue issue) {
        return this.userFactory.getCheckedUser().toOption().filter(user -> this.customerInvolvedService.hasAccessToRequest(user, issue)).isDefined();
    }

    private Option<String> generatePortalUrlForIssue(Issue issue) {
        return Option.option((Object)issue.getProjectObject()).flatMap(project -> this.portalManager.getPortalByProject(project).toOption()).map(portal -> "/servicedesk/customer/portal/" + portal.getId() + "/" + issue.getKey());
    }

    private boolean isInWhiteList(String requestUrl) {
        return WHITELIST_URI_MATCHER.matches(requestUrl) == UriMatcher.Decision.GRANTED;
    }

    @VisibleForTesting
    boolean isInCustomerContext() {
        return this.customerContextService.isInCustomerContext();
    }

    private boolean executeAndLog(boolean accessCheck, String message, ApplicationUser user, String requestUrl) {
        String not = accessCheck ? "" : "not";
        String requestURI = requestUrl != null ? requestUrl : "NULL";
        String userName = user != null ? user.getUsername() : "ANON";
        log.debug("{} is {} true for request {} and user {}", new Object[]{message, not, requestURI, userName});
        return accessCheck;
    }
}

