/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.timedpromise;

import com.atlassian.jira.issue.Issue;
import com.atlassian.scheduler.timedpromise.api.TimedPromiseSchedulerException;
import com.atlassian.scheduler.timedpromise.api.TimedPromiseSchedulerService;
import com.atlassian.servicedesk.internal.timedpromise.TimedPromiseHelper;
import com.atlassian.servicedesk.internal.timedpromise.TimedPromiseSlaScheduleOrigin;
import com.atlassian.servicedesk.internal.timedpromise.taskrunner.SlaThresholdEventTaskRunner;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TimedPromiseHelperImpl
implements TimedPromiseHelper {
    private static final Logger LOG = LoggerFactory.getLogger(TimedPromiseHelperImpl.class);
    private final TimedPromiseSchedulerService timedPromiseSchedulerService;

    @Autowired
    public TimedPromiseHelperImpl(TimedPromiseSchedulerService timedPromiseSchedulerService) {
        this.timedPromiseSchedulerService = timedPromiseSchedulerService;
    }

    @Override
    public void scheduleSlaThresholdEventTimedPromise(Issue issue, long earliestNextSlaThresholdEventTime, TimedPromiseSlaScheduleOrigin timedPromiseSlaScheduleOrigin) throws RuntimeException {
        String schedulingMessage = "SLA Threshold Events - scheduled timed promise for issue: " + issue.getKey() + " (origin: " + timedPromiseSlaScheduleOrigin.text() + ")";
        if (LOG.isDebugEnabled()) {
            schedulingMessage = schedulingMessage + ", at '" + new DateTime(earliestNextSlaThresholdEventTime) + "'";
            LOG.debug(schedulingMessage);
        }
        try {
            this.timedPromiseSchedulerService.schedule(SlaThresholdEventTaskRunner.buildTimedPromiseKey(issue), SlaThresholdEventTaskRunner.buildTimedPromiseConfig(earliestNextSlaThresholdEventTime), schedulingMessage);
        }
        catch (TimedPromiseSchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void unscheduleSlaThresholdEventTimedPromise(Issue issue, String reason) {
        this.timedPromiseSchedulerService.unschedule(SlaThresholdEventTaskRunner.buildTimedPromiseKey(issue), reason);
    }
}

