/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.threshold;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.servicedesk.workinprogressapi.sla.threshold.SlaThresholdExceeded;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;

@ParametersAreNonnullByDefault
public class SlaThresholdUpdateContext {
    private final Issue issue;
    private final ImmutableList.Builder<DateTime> nextSlaThresholdsDateTimes;
    private final ImmutableList.Builder<SlaThresholdExceeded> slaThresholdsExceeded;

    public SlaThresholdUpdateContext(Issue issue) {
        this.issue = (Issue)Assertions.notNull((String)"issue", (Object)issue);
        this.nextSlaThresholdsDateTimes = ImmutableList.builder();
        this.slaThresholdsExceeded = ImmutableList.builder();
    }

    @Nonnull
    public Issue getIssue() {
        return this.issue;
    }

    void addNextSlaThresholdsDateTimes(DateTime time) {
        this.nextSlaThresholdsDateTimes.add((Object)time);
    }

    @Nonnull
    List<DateTime> getNextSlaThresholdsDateTimes() {
        return this.nextSlaThresholdsDateTimes.build();
    }

    void addSlaThresholdsExceeded(SlaThresholdExceeded thresholdExceeded) {
        this.slaThresholdsExceeded.add((Object)thresholdExceeded);
    }

    @Nonnull
    List<SlaThresholdExceeded> getSlaThresholdsExceeded() {
        return this.slaThresholdsExceeded.build();
    }
}

