/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.threshold;

import com.atlassian.fugue.Either;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.HttpStatusCode;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.api.commons.result.ServiceResult;
import com.atlassian.pocketknife.api.commons.result.Unit;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.internal.api.sla.PermissionService;
import com.atlassian.servicedesk.internal.sla.configuration.threshold.SlaThresholdManager;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.InternalTimeMetricService;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetric;
import com.atlassian.servicedesk.workinprogressapi.sla.threshold.SlaThreshold;
import com.atlassian.servicedesk.workinprogressapi.sla.threshold.SlaThresholdService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SlaThresholdServiceImpl
implements SlaThresholdService {
    @Autowired
    private SlaThresholdManager slaThresholdManager;
    @Autowired
    private InternalTimeMetricService internalTimeMetricService;
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private ErrorResultHelper errorResultHelper;

    @Override
    public io.atlassian.fugue.Either<AnError, List<SlaThreshold>> getThresholds(ApplicationUser user, com.atlassian.servicedesk.api.sla.metrics.TimeMetric timeMetric) {
        return this.slaThresholdManager.getThresholds(timeMetric);
    }

    @Override
    public io.atlassian.fugue.Either<AnError, List<SlaThreshold>> getThresholdsInRange(ApplicationUser user, com.atlassian.servicedesk.api.sla.metrics.TimeMetric timeMetric, long startRemainingTime, long endRemainingTime) {
        return this.slaThresholdManager.getThresholdsInRange(timeMetric, startRemainingTime, endRemainingTime);
    }

    @Override
    public io.atlassian.fugue.Either<AnError, List<SlaThreshold>> getThresholdsBeforeRemainingTime(ApplicationUser user, com.atlassian.servicedesk.api.sla.metrics.TimeMetric timeMetric, long remainingTime) {
        return this.slaThresholdManager.getThresholdsBeforeRemainingTimeIncluding(timeMetric, remainingTime);
    }

    @Override
    public io.atlassian.fugue.Either<AnError, List<SlaThreshold>> getThresholdsAfterRemainingTime(ApplicationUser user, com.atlassian.servicedesk.api.sla.metrics.TimeMetric timeMetric, long remainingTime) {
        return this.slaThresholdManager.getThresholdsAfterRemainingTimeExcluding(timeMetric, remainingTime);
    }

    @Override
    public io.atlassian.fugue.Either<AnError, List<SlaThreshold>> addThreshold(ApplicationUser user, com.atlassian.servicedesk.api.sla.metrics.TimeMetric timeMetric, long remainingTime) {
        TimeMetric internalTimeMetric = (TimeMetric)timeMetric;
        io.atlassian.fugue.Either<ErrorCollection, ServiceDesk> serviceDeskResult = this.internalTimeMetricService.getServiceDeskForTimeMetric(user, internalTimeMetric);
        if (serviceDeskResult.isLeft()) {
            return StepsConverters.newerEither((Either)this.errorResultHelper.error(user, HttpStatusCode.NOT_FOUND, "sd.sla.threshold.error.service.desk.not.found", new Object[0]));
        }
        ServiceDesk serviceDesk = (ServiceDesk)serviceDeskResult.right().get();
        if (!this.permissionService.canManageSlas(user, serviceDesk)) {
            return StepsConverters.newerEither((Either)this.errorResultHelper.error(user, HttpStatusCode.FORBIDDEN, "sd.sla.threshold.error.permission.add", new Object[0]));
        }
        return this.slaThresholdManager.addThreshold(internalTimeMetric, remainingTime);
    }

    @Override
    public io.atlassian.fugue.Either<AnError, List<SlaThreshold>> removeThreshold(ApplicationUser user, com.atlassian.servicedesk.api.sla.metrics.TimeMetric timeMetric, long remainingTime) {
        TimeMetric internalTimeMetric = (TimeMetric)timeMetric;
        io.atlassian.fugue.Either<ErrorCollection, ServiceDesk> serviceDeskResult = this.internalTimeMetricService.getServiceDeskForTimeMetric(user, internalTimeMetric);
        if (serviceDeskResult.isLeft()) {
            return StepsConverters.newerEither((Either)this.errorResultHelper.error(user, HttpStatusCode.NOT_FOUND, "sd.sla.threshold.error.service.desk.not.found", new Object[0]));
        }
        ServiceDesk serviceDesk = (ServiceDesk)serviceDeskResult.right().get();
        if (!this.permissionService.canManageSlas(user, serviceDesk)) {
            return StepsConverters.newerEither((Either)this.errorResultHelper.error(user, HttpStatusCode.FORBIDDEN, "sd.sla.threshold.error.permission.remove", new Object[0]));
        }
        return this.slaThresholdManager.removeThreshold(internalTimeMetric, remainingTime);
    }

    @Override
    public io.atlassian.fugue.Either<AnError, Unit> addThresholdForAllTimeMetrics(ApplicationUser user, ServiceDesk serviceDesk, Long remainingTime) {
        ServiceDesk internalServiceDesk = serviceDesk;
        if (!this.permissionService.canManageSlas(user, internalServiceDesk)) {
            return StepsConverters.newerEither((Either)this.errorResultHelper.error(user, HttpStatusCode.FORBIDDEN, "sd.sla.threshold.error.permission.add", new Object[0]));
        }
        List<TimeMetric> timeMetrics = this.internalTimeMetricService.getTimeMetrics(user, internalServiceDesk);
        for (TimeMetric timeMetric : timeMetrics) {
            this.slaThresholdManager.addThreshold(timeMetric, remainingTime);
        }
        return StepsConverters.newerEither((Either)ServiceResult.ok());
    }

    @Override
    public io.atlassian.fugue.Either<AnError, Unit> removeThresholdForAllTimeMetrics(ApplicationUser user, ServiceDesk serviceDesk, Long remainingTime) {
        ServiceDesk internalServiceDesk = serviceDesk;
        if (!this.permissionService.canManageSlas(user, internalServiceDesk)) {
            return StepsConverters.newerEither((Either)this.errorResultHelper.error(user, HttpStatusCode.FORBIDDEN, "sd.sla.threshold.error.permission.remove", new Object[0]));
        }
        List<TimeMetric> timeMetrics = this.internalTimeMetricService.getTimeMetrics(user, internalServiceDesk);
        for (TimeMetric timeMetric : timeMetrics) {
            io.atlassian.fugue.Either<AnError, List<SlaThreshold>> removeResult = this.slaThresholdManager.removeThreshold(timeMetric, remainingTime);
            if (!removeResult.isLeft()) continue;
            return io.atlassian.fugue.Either.left((Object)removeResult.left().get());
        }
        return StepsConverters.newerEither((Either)ServiceResult.ok());
    }
}

