/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.threshold;

import com.atlassian.servicedesk.api.sla.metrics.TimeMetric;
import com.atlassian.servicedesk.workinprogressapi.sla.threshold.SlaThreshold;
import com.atlassian.servicedesk.workinprogressapi.sla.threshold.SlaThresholdExceeded;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;

public class SlaThresholdExceededImpl
implements SlaThresholdExceeded {
    private TimeMetric timeMetric;
    private List<SlaThreshold> thresholds;

    private SlaThresholdExceededImpl(TimeMetric timeMetric, List<SlaThreshold> thresholds) {
        this.timeMetric = timeMetric;
        this.thresholds = Collections.unmodifiableList(thresholds);
    }

    @Override
    public TimeMetric getTimeMetric() {
        return this.timeMetric;
    }

    @Override
    public List<SlaThreshold> getThresholds() {
        return this.thresholds;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(SlaThresholdExceeded slaThresholdsExceeded) {
        return new Builder(slaThresholdsExceeded.getTimeMetric(), slaThresholdsExceeded.getThresholds());
    }

    public static class Builder {
        private TimeMetric timeMetric;
        private List<SlaThreshold> thresholds;

        private Builder() {
            this.thresholds = Lists.newArrayList();
        }

        private Builder(TimeMetric timeMetric, List<SlaThreshold> thresholds) {
            this.timeMetric = timeMetric;
            this.thresholds = Lists.newArrayList(thresholds);
        }

        public Builder timeMetric(TimeMetric timeMetric) {
            this.timeMetric = timeMetric;
            return this;
        }

        public Builder addThreshold(SlaThreshold threshold) {
            this.thresholds.add(threshold);
            return this;
        }

        public Builder thresholds(List<SlaThreshold> thresholds) {
            this.thresholds = Lists.newArrayList(thresholds);
            return this;
        }

        public SlaThresholdExceeded build() {
            return new SlaThresholdExceededImpl(this.timeMetric, this.thresholds);
        }
    }
}

