/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.threshold;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.plugins.workinghours.api.calculator.WorkingHoursCalculator;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.internal.api.sla.configuration.calendar.CalendarReferenceManager;
import com.atlassian.servicedesk.internal.api.sla.goal.Goal;
import com.atlassian.servicedesk.internal.sla.audit.SlaAuditLogDataHelper;
import com.atlassian.servicedesk.internal.sla.audit.SlaAuditLogInput;
import com.atlassian.servicedesk.internal.sla.audit.SlaAuditLogManager;
import com.atlassian.servicedesk.internal.sla.audit.SlaAuditLogReason;
import com.atlassian.servicedesk.internal.sla.configuration.goal.GoalManager;
import com.atlassian.servicedesk.internal.sla.configuration.threshold.SlaThresholdManager;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetric;
import com.atlassian.servicedesk.internal.sla.goal.GoalCalculationService;
import com.atlassian.servicedesk.internal.sla.model.OngoingSLAData;
import com.atlassian.servicedesk.internal.sla.model.SLAValue;
import com.atlassian.servicedesk.internal.sla.model.ThresholdData;
import com.atlassian.servicedesk.internal.sla.threshold.SlaThresholdEventManager;
import com.atlassian.servicedesk.internal.sla.threshold.SlaThresholdExceededImpl;
import com.atlassian.servicedesk.internal.sla.threshold.SlaThresholdUpdateContext;
import com.atlassian.servicedesk.internal.sla.threshold.SlaThresholdsExceededEventImpl;
import com.atlassian.servicedesk.internal.timedpromise.TimedPromiseHelper;
import com.atlassian.servicedesk.internal.timedpromise.TimedPromiseSlaScheduleOrigin;
import com.atlassian.servicedesk.internal.util.SafeRunner;
import com.atlassian.servicedesk.workinprogressapi.sla.threshold.SlaThreshold;
import com.atlassian.servicedesk.workinprogressapi.sla.threshold.SlaThresholdExceeded;
import com.atlassian.servicedesk.workinprogressapi.sla.threshold.SlaThresholdsExceededEvent;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Unit;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SlaThresholdEventManagerImpl
implements SlaThresholdEventManager {
    private static final Logger LOG = LoggerFactory.getLogger(SlaThresholdEventManagerImpl.class);
    private final EventPublisher eventPublisher;
    private final SlaThresholdManager slaThresholdManager;
    private final SafeRunner safeRunner;
    private final GoalCalculationService goalCalculationService;
    private final GoalManager goalManager;
    private final CalendarReferenceManager calendarReferenceManager;
    private final TimedPromiseHelper timedPromiseHelper;
    private final SlaAuditLogManager slaAuditLogManager;
    private final SlaAuditLogDataHelper slaAuditLogDataHelper;

    @Autowired
    public SlaThresholdEventManagerImpl(EventPublisher eventPublisher, SlaThresholdManager slaThresholdManager, SafeRunner safeRunner, GoalCalculationService goalCalculationService, GoalManager goalManager, CalendarReferenceManager calendarReferenceManager, TimedPromiseHelper timedPromiseHelper, SlaAuditLogManager slaAuditLogManager, SlaAuditLogDataHelper slaAuditLogDataHelper) {
        this.eventPublisher = eventPublisher;
        this.slaThresholdManager = slaThresholdManager;
        this.safeRunner = safeRunner;
        this.goalCalculationService = goalCalculationService;
        this.goalManager = goalManager;
        this.calendarReferenceManager = calendarReferenceManager;
        this.timedPromiseHelper = timedPromiseHelper;
        this.slaAuditLogManager = slaAuditLogManager;
        this.slaAuditLogDataHelper = slaAuditLogDataHelper;
    }

    @Override
    public void calculateExceededSlaThresholds(TimeMetric timeMetric, SLAValue currentValue, SLAValue newValue, SlaThresholdUpdateContext slaThresholdUpdateContext) {
        OngoingSLAData oldOngoingSLAData = currentValue.getOngoingSLAData();
        OngoingSLAData newOngoingSLAData = newValue.getOngoingSLAData();
        if (oldOngoingSLAData != null && oldOngoingSLAData.getThresholdData().isEmpty()) {
            return;
        }
        if (newOngoingSLAData == null || newOngoingSLAData.getThresholdData() == null || newOngoingSLAData.getThresholdData().isEmpty() || ((ThresholdData)newOngoingSLAData.getThresholdData().get()).getRemainingTime().isEmpty()) {
            return;
        }
        Long newRemainingTime = (Long)((ThresholdData)newOngoingSLAData.getThresholdData().get()).getRemainingTime().get();
        Option<Long> oldRemainingTime = Option.none();
        if (oldOngoingSLAData != null && oldOngoingSLAData.getThresholdData().isDefined()) {
            oldRemainingTime = ((ThresholdData)oldOngoingSLAData.getThresholdData().get()).getRemainingTime();
        }
        ImmutableList.Builder thresholdsBuilder = ImmutableList.builder();
        if (oldRemainingTime.isDefined()) {
            if ((Long)oldRemainingTime.get() < newRemainingTime) {
                return;
            }
            if (((Long)oldRemainingTime.get()).equals(newRemainingTime)) {
                return;
            }
            Either<AnError, List<SlaThreshold>> thresholdsInRangeResult = this.slaThresholdManager.getThresholdsInRange(timeMetric, (Long)oldRemainingTime.get(), newRemainingTime);
            if (thresholdsInRangeResult.isLeft()) {
                return;
            }
            thresholdsBuilder.addAll((Iterable)thresholdsInRangeResult.right().get());
        } else {
            Integer goalId = newOngoingSLAData.getGoalId();
            Either<ErrorCollection, com.atlassian.servicedesk.internal.sla.configuration.goal.Goal> goal = this.goalManager.getGoal(goalId);
            if (goal.isRight()) {
                Long initialRemainingTime = ((com.atlassian.servicedesk.internal.sla.configuration.goal.Goal)((Object)goal.right().get())).getDuration();
                if (initialRemainingTime == null) {
                    return;
                }
                Either<AnError, List<SlaThreshold>> thresholdsBeforeRemainingTimeResult = this.slaThresholdManager.getThresholdsInRange(timeMetric, initialRemainingTime + 1L, newRemainingTime);
                if (thresholdsBeforeRemainingTimeResult.isLeft()) {
                    return;
                }
                thresholdsBuilder.addAll((Iterable)thresholdsBeforeRemainingTimeResult.right().get());
            }
        }
        ImmutableList thresholds = thresholdsBuilder.build();
        if (thresholds.isEmpty()) {
            return;
        }
        SlaThresholdExceeded exceededSlaThreshold = SlaThresholdExceededImpl.builder().timeMetric(timeMetric).thresholds((List<SlaThreshold>)thresholds).build();
        slaThresholdUpdateContext.addSlaThresholdsExceeded(exceededSlaThreshold);
    }

    @Override
    public void fireExceededSlaThresholdsEvent(SlaThresholdUpdateContext slaThresholdUpdateContext, DateTime eventTime) {
        if (!this.hasRemainingTimePassedThresholds(slaThresholdUpdateContext)) {
            return;
        }
        this.safeRunner.run(() -> this.auditLogThresholdEvent(slaThresholdUpdateContext, eventTime));
        SlaThresholdsExceededEventImpl event = new SlaThresholdsExceededEventImpl(slaThresholdUpdateContext, eventTime.toDate());
        this.fireSlaThresholdEvent(event);
    }

    @Override
    public void calculateNextExceedingSlaThresholdTime(TimeMetric timeMetric, SLAValue newValue, DateTime now, SlaThresholdUpdateContext slaThresholdUpdateContext) {
        OngoingSLAData newOngoingSLAData = newValue.getOngoingSLAData();
        if (!this.nextExceededSlaThresholdCouldExist(newOngoingSLAData)) {
            return;
        }
        Long newRemainingTime = (Long)((ThresholdData)newOngoingSLAData.getThresholdData().get()).getRemainingTime().get();
        Either<AnError, List<SlaThreshold>> thresholdsAfterRemainingTimeResult = this.slaThresholdManager.getThresholdsAfterRemainingTimeExcluding(timeMetric, newRemainingTime);
        if (thresholdsAfterRemainingTimeResult.isLeft()) {
            return;
        }
        List thresholds = (List)thresholdsAfterRemainingTimeResult.right().get();
        if (thresholds.isEmpty()) {
            return;
        }
        long nextSlaThresholdDuration = ((SlaThreshold)thresholds.get(0)).getRemainingTime();
        Integer goalId = newOngoingSLAData.getGoalId();
        Either<ErrorCollection, com.atlassian.servicedesk.internal.sla.configuration.goal.Goal> goal = this.goalManager.getGoal(goalId);
        if (goal.isLeft()) {
            return;
        }
        WorkingHoursCalculator calculator = this.calendarReferenceManager.getCalculatorForGoal((Goal)goal.right().get());
        Option<DateTime> nextExceedingThresholdTime = this.goalCalculationService.getThresholdExceededDate(newValue.getTimeline(), calculator, newRemainingTime, nextSlaThresholdDuration, newValue.getOngoingSLAData(), now, false);
        if (nextExceedingThresholdTime.isEmpty()) {
            return;
        }
        slaThresholdUpdateContext.addNextSlaThresholdsDateTimes((DateTime)nextExceedingThresholdTime.get());
    }

    @Override
    public void scheduleNextExceedingSlaThresholdTimedPromise(SlaThresholdUpdateContext slaThresholdUpdateContext, TimedPromiseSlaScheduleOrigin timedPromiseSlaScheduleOrigin) {
        Issue issue = slaThresholdUpdateContext.getIssue();
        this.extractEarliestNextExceedingSlaThresholdTime(slaThresholdUpdateContext).fold(() -> {
            this.safeRunner.run(() -> {
                Option data = Option.some(this.slaAuditLogDataHelper.determineUnschedulingData(issue));
                this.auditLogScheduling(slaThresholdUpdateContext, SlaAuditLogReason.UNSCHEDULING_TIMED_PROMISE, (Option<Map<String, String>>)data);
            });
            this.timedPromiseHelper.unscheduleSlaThresholdEventTimedPromise(issue, "SLA Threshold Events - unscheduled timed promise for issue " + issue.getKey() + ", as no next exceeding SLA threshold has been calculated for any its SLAs");
            return Unit.Unit();
        }, nextExceedingThresholdTime -> {
            this.safeRunner.run(() -> {
                Option data = Option.some(this.slaAuditLogDataHelper.determineNextTimedPromiseData((DateTime)nextExceedingThresholdTime, issue));
                this.auditLogScheduling(slaThresholdUpdateContext, SlaAuditLogReason.SCHEDULING_TIMED_PROMISE, (Option<Map<String, String>>)data);
            });
            try {
                this.timedPromiseHelper.scheduleSlaThresholdEventTimedPromise(issue, nextExceedingThresholdTime.getMillis(), timedPromiseSlaScheduleOrigin);
            }
            catch (RuntimeException e) {
                LOG.warn("SLA Threshold Events timed promise could not be scheduled for issue '" + issue.getKey(), (Throwable)e);
            }
            return Unit.Unit();
        });
    }

    @Override
    public boolean hasRemainingTimePassedThresholds(SlaThresholdUpdateContext slaThresholdUpdateContext) {
        return !slaThresholdUpdateContext.getSlaThresholdsExceeded().isEmpty();
    }

    @Override
    public Option<DateTime> extractEarliestNextExceedingSlaThresholdTime(SlaThresholdUpdateContext slaThresholdUpdateContext) {
        List<DateTime> nextSlaThresholdsDateTimes = slaThresholdUpdateContext.getNextSlaThresholdsDateTimes();
        if (nextSlaThresholdsDateTimes.isEmpty()) {
            return Option.none();
        }
        DateTime earliestNextSlaThresholdTime = Collections.min(nextSlaThresholdsDateTimes);
        return Option.some((Object)earliestNextSlaThresholdTime);
    }

    private void fireSlaThresholdEvent(SlaThresholdsExceededEvent slaThresholdsExceededEvent) {
        this.safeRunner.run(() -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Firing SLA Threshold Event: {}", (Object)slaThresholdsExceededEvent);
            }
            this.eventPublisher.publish((Object)slaThresholdsExceededEvent);
        });
    }

    private boolean nextExceededSlaThresholdCouldExist(OngoingSLAData newOngoingSLAData) {
        if (newOngoingSLAData == null) {
            return false;
        }
        Option<ThresholdData> thresholdData = newOngoingSLAData.getThresholdData();
        return thresholdData.isDefined() && ((ThresholdData)thresholdData.get()).getRemainingTime().isDefined();
    }

    private void auditLogScheduling(SlaThresholdUpdateContext slaThresholdUpdateContext, SlaAuditLogReason reason, Option<Map<String, String>> data) {
        this.slaAuditLogManager.createAuditLogRecords(Lists.newArrayList((Object[])new SlaAuditLogInput[]{this.createAuditLogInput(slaThresholdUpdateContext, DateTime.now(), (Option<Long>)Option.none(), reason, data)}));
    }

    private void auditLogThresholdEvent(SlaThresholdUpdateContext slaThresholdUpdateContext, DateTime eventTime) {
        List<SlaAuditLogInput> auditInputs = slaThresholdUpdateContext.getSlaThresholdsExceeded().stream().map(exceeded -> {
            Option slaId = Option.some((Object)exceeded.getTimeMetric().getId().longValue());
            Option data = Option.some(this.slaAuditLogDataHelper.determineExceededEventData((SlaThresholdExceeded)exceeded, slaThresholdUpdateContext.getIssue()));
            return this.createAuditLogInput(slaThresholdUpdateContext, eventTime, (Option<Long>)slaId, SlaAuditLogReason.EXCEEDED_EVENT, (Option<Map<String, String>>)data);
        }).collect(Collectors.toList());
        this.slaAuditLogManager.createAuditLogRecords(auditInputs);
    }

    private SlaAuditLogInput createAuditLogInput(SlaThresholdUpdateContext slaThresholdUpdateContext, DateTime eventTime, Option<Long> slaId, SlaAuditLogReason reason, Option<Map<String, String>> data) {
        return new SlaAuditLogInput((Option<Long>)Option.some((Object)slaThresholdUpdateContext.getIssue().getId()), slaId, (Option<SlaAuditLogReason>)Option.option((Object)((Object)reason)), eventTime.getMillis(), data);
    }
}

