/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.task;

import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.pocketknife.annotations.lucene.LuceneUsage;
import com.atlassian.pocketknife.api.search.issue.callback.DataCallback;
import com.atlassian.pocketknife.api.search.issue.callback.IssueIdCallback;
import com.atlassian.pocketknife.api.search.issue.callback.IssueKeyCallback;
import com.atlassian.pocketknife.api.search.issue.service.ExtendedSearchService;
import com.atlassian.pocketknife.api.search.issue.service.IssueDataService;
import com.atlassian.query.Query;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.internal.api.sla.searcher.builder.SlaQueryBuilder;
import com.atlassian.servicedesk.internal.api.sla.searcher.builder.SlaQueryBuilderFactory;
import com.atlassian.servicedesk.internal.sla.configuration.goal.Goal;
import com.atlassian.servicedesk.internal.sla.configuration.goal.GoalManager;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.InternalTimeMetricService;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetric;
import com.atlassian.servicedesk.internal.sla.customfield.SLAFieldService;
import com.atlassian.servicedesk.internal.sla.searcher.SLACustomFieldIndexer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Either;
import java.util.List;
import java.util.Set;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.TermQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OutdatedIssueFinder {
    @Autowired
    private IssueDataService issueDataService;
    @Autowired
    private InternalTimeMetricService internalTimeMetricService;
    @Autowired
    private SLAFieldService slaFieldService;
    @Autowired
    private GoalManager goalManager;
    @Autowired
    private ExtendedSearchService extendedSearchService;
    @Autowired
    private SearchProvider searchProvider;
    @Autowired
    @VisibleForTesting
    SlaQueryBuilderFactory slaQueryBuilderFactory;

    @LuceneUsage(type=LuceneUsage.LuceneUsageType.IssueCollection)
    public Set<Long> findOutdatedIssuesIds(ApplicationUser user, ServiceDesk sd, int max) {
        IssueIdCallback callback = new IssueIdCallback(max);
        this.collectOutdatedIssues(user, sd, (DataCallback)callback);
        return Sets.newHashSet((Iterable)callback.getIssueIds());
    }

    @LuceneUsage(type=LuceneUsage.LuceneUsageType.IssueCollection)
    public List<String> findOutdatedIssuesKeys(ApplicationUser user, ServiceDesk sd, int max) {
        IssueKeyCallback callback = new IssueKeyCallback(max);
        this.collectOutdatedIssues(user, sd, (DataCallback)callback);
        return callback.getIssueKeys();
    }

    public long getOutdatedServiceDeskIssueCount(ApplicationUser user, ServiceDesk sd) {
        Query serviceDeskQuery = this.getServiceDeskQuery(sd);
        org.apache.lucene.search.Query outdatedMetricsQuery = this.getOutdatedMetricsQuery(user, sd);
        try {
            return this.extendedSearchService.searchCountOverrideSecurity(serviceDeskQuery, user, outdatedMetricsQuery);
        }
        catch (SearchException e) {
            return 0L;
        }
    }

    public long getServiceDeskIssueCount(ServiceDesk sd) {
        try {
            return this.searchProvider.searchCountOverrideSecurity(this.getServiceDeskQuery(sd), (ApplicationUser)null);
        }
        catch (SearchException e) {
            return 0L;
        }
    }

    @LuceneUsage(type=LuceneUsage.LuceneUsageType.IssueCollection)
    private void collectOutdatedIssues(ApplicationUser user, ServiceDesk serviceDesk, DataCallback callback) {
        Query serviceDeskQuery = this.getServiceDeskQuery(serviceDesk);
        org.apache.lucene.search.Query outdatedMetricsQuery = this.getOutdatedMetricsQuery(user, serviceDesk);
        this.issueDataService.findOverrideSecurity(user, serviceDeskQuery, callback, outdatedMetricsQuery);
    }

    private Query getServiceDeskQuery(ServiceDesk sd) {
        return JqlQueryBuilder.newBuilder().where().project(new Long[]{sd.getProjectId()}).buildQuery();
    }

    @LuceneUsage(type=LuceneUsage.LuceneUsageType.IssueCollection)
    org.apache.lucene.search.Query getOutdatedMetricsQuery(ApplicationUser user, ServiceDesk sd) {
        List<TimeMetric> timeMetrics = this.internalTimeMetricService.getTimeMetrics(user, sd);
        SlaQueryBuilder slaQueryBuilder = this.slaQueryBuilderFactory.newBuilder();
        for (TimeMetric timeMetric : timeMetrics) {
            Either<ErrorCollection, CustomField> byId = this.slaFieldService.getById(user, timeMetric.getCustomFieldId());
            if (byId.isLeft()) continue;
            slaQueryBuilder.or().sub();
            this.addQueryForField(slaQueryBuilder, timeMetric, (CustomField)byId.right().get());
            slaQueryBuilder.endSub();
        }
        return slaQueryBuilder.build();
    }

    private void addQueryForField(SlaQueryBuilder slaQueryBuilder, TimeMetric timeMetric, CustomField customField) {
        slaQueryBuilder.field(customField);
        slaQueryBuilder.or().sub().and().add((org.apache.lucene.search.Query)new MatchAllDocsQuery()).not().add((org.apache.lucene.search.Query)new TermQuery(new Term("nonemptyfieldids", SLACustomFieldIndexer.getMetricIdFieldId(customField)))).endSub();
        slaQueryBuilder.or().sub().and().add((org.apache.lucene.search.Query)new MatchAllDocsQuery()).not().metricId().eq().string(timeMetric.getId().toString()).endSub();
        slaQueryBuilder.or().sub().and().add((org.apache.lucene.search.Query)new MatchAllDocsQuery()).not();
        Long definitionChangeDate = timeMetric.getDefinitionChangeMsEpoch();
        slaQueryBuilder.definitionChangeDate().eq().string(Long.toString(definitionChangeDate));
        slaQueryBuilder.endSub();
        slaQueryBuilder.or().sub().and().add((org.apache.lucene.search.Query)new MatchAllDocsQuery()).not().goalCheckId().eq().string(Integer.toString(-1)).not();
        Long thresholdsConfigChangeDate = timeMetric.getThresholdsChangedMsEpoch();
        slaQueryBuilder.thresholdsConfigChangeDate().eq().string(Long.toString(thresholdsConfigChangeDate));
        slaQueryBuilder.endSub();
        slaQueryBuilder.or().sub().and().add((org.apache.lucene.search.Query)new MatchAllDocsQuery()).not().goalCheckId().eq().string(Integer.toString(-1)).not().sub();
        Long goalsChangeDate = timeMetric.getGoalsChangeMsEpoch();
        slaQueryBuilder.and().goalsChangeDate().eq().string(Long.toString(goalsChangeDate));
        slaQueryBuilder.and().sub();
        List<Goal> allGoals = this.goalManager.getAllByTimeMetric(timeMetric);
        for (Goal goal : allGoals) {
            slaQueryBuilder.or().sub();
            slaQueryBuilder.and().goalCheckId().eq().string(goal.getId().toString());
            Long goalTimeUpdatedDate = goal.getTimeUpdatedMsEpoch();
            slaQueryBuilder.and().goalTimeUpdatedDate().eq().string(Long.toString(goalTimeUpdatedDate));
            slaQueryBuilder.endSub();
        }
        slaQueryBuilder.endSub();
        slaQueryBuilder.endSub();
        slaQueryBuilder.endSub();
    }
}

