/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.task;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.task.ProvidesTaskProgress;
import com.atlassian.jira.task.RequiresTaskInformation;
import com.atlassian.jira.task.ScalingTaskProgessSink;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.task.TimeBasedLogSink;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.internal.sla.audit.SlaAuditLogReason;
import com.atlassian.servicedesk.internal.sla.metric.MetricStateHistoryExtractor;
import com.atlassian.servicedesk.internal.sla.metric.MetricStateHistoryExtractorConfig;
import com.atlassian.servicedesk.internal.sla.task.ConsistencyTaskCompletionCallback;
import com.atlassian.servicedesk.internal.sla.task.OutdatedIssueFinder;
import com.atlassian.util.profiling.UtilTimerStack;
import io.atlassian.fugue.Option;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

class ConsistencyTask
implements Callable<HashMap<String, Serializable>>,
ProvidesTaskProgress,
RequiresTaskInformation<HashMap<String, Serializable>> {
    public static final String TASK_RESULT_MIGRATION_SUCCEEDED_KEY = "migrationSucceeded";
    public static final String TASK_RESULT_NUMBER_OF_MIGRATED_ISSUES_KEY = "numberOfMigratedIssues";
    public static final String TASK_IDENTIFICATION_KEY = "com.atlassian.servicedesk.internal.sla.task";
    private final Log log = Log.with(ConsistencyTask.class);
    private static final int MAX_TIME_BETWEEN_EVENTS = 120000;
    private volatile TaskProgressSink taskProgressSink;
    private TaskDescriptor<HashMap<String, Serializable>> taskDescriptor;
    private ApplicationUser user;
    private I18nHelper i18n;
    private final MetricStateHistoryExtractor metricStateHistoryExtractor;
    private final IssueManager issueManager;
    private final OutdatedIssueFinder outdatedIssueFinder;
    private final ConsistencyTaskCompletionCallback consistencyTaskCompletionCallback;
    private final ServiceDesk serviceDesk;
    private final Project project;
    private final IssueIndexManager issueIndexManager;
    private final Option<SlaAuditLogReason> reason;

    public ConsistencyTask(ApplicationUser user, I18nHelper i18n, MetricStateHistoryExtractor metricStateHistoryExtractor, IssueManager issueManager, OutdatedIssueFinder outdatedIssueFinder, ConsistencyTaskCompletionCallback consistencyTaskCompletionCallback, Project project, ServiceDesk serviceDesk, IssueIndexManager issueIndexManager, Option<SlaAuditLogReason> reason) {
        this.user = user;
        this.i18n = i18n;
        this.metricStateHistoryExtractor = metricStateHistoryExtractor;
        this.issueManager = issueManager;
        this.outdatedIssueFinder = outdatedIssueFinder;
        this.consistencyTaskCompletionCallback = consistencyTaskCompletionCallback;
        this.serviceDesk = serviceDesk;
        this.project = project;
        this.issueIndexManager = issueIndexManager;
        this.reason = reason;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap<String, Serializable> call() throws Exception {
        Logger logger = Logger.getLogger(ConsistencyTask.class);
        TimeBasedLogSink sink = new TimeBasedLogSink(logger, this.taskDescriptor.getDescription(), 120000L, this.taskProgressSink);
        HashMap<String, Serializable> result = null;
        try {
            result = this.doMigrate((TaskProgressSink)sink);
        }
        finally {
            this.consistencyTaskCompletionCallback.taskComplete(this.serviceDesk, this.taskDescriptor.getTaskId(), this.reason);
        }
        return result;
    }

    public void setTaskProgressSink(TaskProgressSink taskProgressSink) {
        this.taskProgressSink = taskProgressSink;
    }

    public void setTaskDescriptor(TaskDescriptor<HashMap<String, Serializable>> taskDescriptor) {
        this.taskDescriptor = taskDescriptor;
    }

    private HashMap<String, Serializable> doMigrate(TaskProgressSink sink) {
        sink.makeProgress(0L, this.i18n.getText("sd.time.metric.service.update.starting"), this.i18n.getText("sd.time.metric.service.update.starting"));
        UtilTimerStack.push((String)"TimeMetricUpdateTask.migrate");
        this.log.info("Started consistency task for service desk %s", new Object[]{this.project.getKey()});
        String progressMessage = this.i18n.getText("sd.time.metric.service.update.complete");
        long outdatedIssueCount = this.outdatedIssueFinder.getOutdatedServiceDeskIssueCount(this.user, this.serviceDesk);
        int updatedIssueCount = this.processIssues(sink, outdatedIssueCount);
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        if (this.taskDescriptor.isCancelled()) {
            result.put(TASK_RESULT_MIGRATION_SUCCEEDED_KEY, Boolean.valueOf(false));
        } else {
            sink.makeProgress(100L, "TimeMetricUpdateTask.migrate", progressMessage);
            UtilTimerStack.pop((String)"TimeMetricUpdateTask.migrate");
            result.put(TASK_RESULT_MIGRATION_SUCCEEDED_KEY, Boolean.valueOf(true));
        }
        result.put(TASK_RESULT_NUMBER_OF_MIGRATED_ISSUES_KEY, Integer.valueOf(updatedIssueCount));
        return result;
    }

    private int processIssues(TaskProgressSink sink, long totalOutdatedIssueCount) {
        Set<Long> outdatedIssueIds;
        MetricStateHistoryExtractorConfig config = this.metricStateHistoryExtractor.loadConfiguration(this.serviceDesk);
        ScalingTaskProgessSink migrationSink = new ScalingTaskProgessSink(0L, 100L, 0L, totalOutdatedIssueCount, sink);
        int updatedIssuesCount = 0;
        int processedIssueCount = 0;
        int max = 1000;
        do {
            if ((outdatedIssueIds = this.outdatedIssueFinder.findOutdatedIssuesIds(this.user, this.serviceDesk, max)).isEmpty()) {
                return updatedIssuesCount;
            }
            updatedIssuesCount = this.processIssuesById((TaskProgressSink)migrationSink, outdatedIssueIds, updatedIssuesCount, config);
        } while ((long)(processedIssueCount += outdatedIssueIds.size()) < totalOutdatedIssueCount && !this.taskDescriptor.isCancelled());
        return updatedIssuesCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int processIssuesById(TaskProgressSink migrationSink, Set<Long> issueIds, int updatedIssueCount, MetricStateHistoryExtractorConfig config) {
        block18: {
            progressMessage = this.i18n.getText("sd.time.metric.service.update.complete");
            try {
                this.issueIndexManager.hold();
                maxHeld = 100;
                processed = 0;
lbl6:
                // 2 sources

                for (long issueId : issueIds) {
                    if (this.taskDescriptor.isCancelled()) {
                        var11_13 = updatedIssueCount;
                        break block18;
                    }
                    ** GOTO lbl-1000
                }
                ** GOTO lbl49
            }
            catch (Throwable var13_18) {
                try {
                    this.issueIndexManager.release();
                    throw var13_18;
                }
                catch (IndexException e) {
                    this.log.warn(e.getMessage(), new Object[]{e});
                }
                throw var13_18;
            }
        }
        try {
            this.issueIndexManager.release();
            return var11_13;
        }
        catch (IndexException e) {
            this.log.warn(e.getMessage(), new Object[]{e});
        }
        return var11_13;
lbl-1000:
        // 1 sources

        {
            issue = this.issueManager.getIssueObject(Long.valueOf(issueId));
            if (issue != null) {
                try {
                    this.metricStateHistoryExtractor.extractTimeMetricHistory((Issue)issue, config, this.reason);
                }
                catch (Exception e) {
                    this.log.warn("Unable to extract SLA state for issue %s", new Object[]{issue.getKey()});
                    this.log.exception((Throwable)e);
                }
            } else {
                this.log.warn("Issue with id %d present in index but not in the database. A full reindex will fix this problem.", new Object[]{issueId});
            }
            if (++processed >= maxHeld) {
                try {
                    this.issueIndexManager.release();
                    this.issueIndexManager.hold();
                    processed = 0;
                }
                catch (IndexException e) {
                    this.log.warn(e.getMessage(), new Object[]{e});
                }
            }
            migrationSink.makeProgress((long)(++updatedIssueCount), "TimeMetricUpdateTask.migrate", progressMessage);
            ** GOTO lbl6
lbl49:
            // 1 sources

            var8_9 = updatedIssueCount;
        }
        try {
            this.issueIndexManager.release();
            return var8_9;
        }
        catch (IndexException e) {
            this.log.warn(e.getMessage(), new Object[]{e});
        }
        return var8_9;
    }
}

