/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.searcher.sorter;

import com.atlassian.servicedesk.internal.api.sla.searcher.SlaCycleState;
import com.atlassian.servicedesk.internal.sla.searcher.sorter.RemainingTimeSortingData;
import java.util.Comparator;

public class RemainingTimeComparator
implements Comparator<RemainingTimeSortingData> {
    private static final int EQUALS = 0;
    private static final int LOWER = -1;
    private static final int GREATER = 1;

    @Override
    public int compare(RemainingTimeSortingData r1, RemainingTimeSortingData r2) {
        if (r1 == r2) {
            return 0;
        }
        if (r1 == null) {
            return 1;
        }
        if (r2 == null) {
            return -1;
        }
        int cycleStateComparison = this.compare(r1.slaCycleState, r2.slaCycleState);
        if (cycleStateComparison != 0) {
            return cycleStateComparison;
        }
        if (r1.slaCycleState == SlaCycleState.COMPLETED && r2.slaCycleState == SlaCycleState.COMPLETED) {
            return 0;
        }
        long comp = r1.remainingTime.compareTo(r2.remainingTime);
        if (comp != 0L) {
            return comp > 0L ? 1 : -1;
        }
        if (r1.slaCycleState == r2.slaCycleState) {
            return 0;
        }
        if (r1.slaCycleState == SlaCycleState.RUNNING) {
            return -1;
        }
        return 1;
    }

    @Override
    private int compare(SlaCycleState slaCycleState1, SlaCycleState slaCycleState2) {
        if (slaCycleState1 == slaCycleState2) {
            return 0;
        }
        if (slaCycleState1 == SlaCycleState.COMPLETED) {
            return 1;
        }
        if (slaCycleState2 == SlaCycleState.COMPLETED) {
            return -1;
        }
        return 0;
    }
}

