/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.searcher.function;

import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operand.Operand;
import com.atlassian.servicedesk.internal.sla.searcher.function.SlaJqlFunction;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public class ElapsedTimeSlaFunction
extends SlaJqlFunction {
    public MessageSet validate(ApplicationUser searcher, @Nonnull FunctionOperand operand, @Nonnull TerminalClause terminalClause) {
        Option<Long> duration;
        MessageSet messageSet = this.validateNumberOfArgs(operand, 1);
        if (operand.getArgs().size() == 1 && (duration = this.getDuration(operand)).isEmpty()) {
            messageSet.addErrorMessage(this.getI18n().getText("sd.sla.jql.function.invalid.duration", (String)operand.getArgs().get(0)));
        }
        return messageSet;
    }

    public List<QueryLiteral> getValues(@Nonnull QueryCreationContext queryCreationContext, @Nonnull FunctionOperand operand, @Nonnull TerminalClause terminalClause) {
        Option<Long> duration = this.getDuration(operand);
        if (duration.isDefined()) {
            return Lists.newArrayList((Object[])new QueryLiteral[]{new QueryLiteral((Operand)operand, (Long)duration.get())});
        }
        return Collections.emptyList();
    }

    public int getMinimumNumberOfExpectedArguments() {
        return 1;
    }

    public String getFunctionName() {
        return "elapsed";
    }
}

