/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.searcher.builder;

import com.atlassian.servicedesk.internal.api.sla.searcher.builder.SlaConditionBuilder;
import com.atlassian.servicedesk.internal.api.sla.searcher.builder.SlaQueryBuilder;
import com.atlassian.servicedesk.internal.api.sla.searcher.builder.SlaValueBuilder;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.joda.time.DateTime;

public class SlaValueBuilderImpl
implements SlaValueBuilder {
    private final String fieldName;
    private final SlaConditionBuilder.Operator operator;
    private final SlaQueryBuilder slaQueryBuilder;

    public SlaValueBuilderImpl(String fieldName, SlaConditionBuilder.Operator operator, SlaQueryBuilder slaQueryBuilder) {
        this.fieldName = fieldName;
        this.operator = operator;
        this.slaQueryBuilder = slaQueryBuilder;
    }

    public SlaQueryBuilder string(String value) {
        TermQuery query = null;
        switch (this.operator) {
            case EQ: {
                query = new TermQuery(new Term(this.fieldName, value));
                break;
            }
            case NOT_EQ: {
                BooleanQuery bq = new BooleanQuery();
                bq.add((Query)new TermQuery(new Term(this.fieldName, value)), BooleanClause.Occur.MUST_NOT);
                query = bq;
                break;
            }
            case LT: {
                query = new TermRangeQuery(this.fieldName, null, value, false, false);
                break;
            }
            case LT_EQ: {
                query = new TermRangeQuery(this.fieldName, null, value, false, true);
                break;
            }
            case GT: {
                query = new TermRangeQuery(this.fieldName, value, null, false, false);
                break;
            }
            case GT_EQ: {
                query = new TermRangeQuery(this.fieldName, value, null, true, false);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown operator " + this.operator);
            }
        }
        return this.slaQueryBuilder.add((Query)query);
    }

    public SlaQueryBuilder number(long value) {
        NumericRangeQuery query = null;
        switch (this.operator) {
            case EQ: {
                query = NumericRangeQuery.newLongRange((String)this.fieldName, (Long)value, (Long)value, (boolean)true, (boolean)true);
                break;
            }
            case NOT_EQ: {
                BooleanQuery bq = new BooleanQuery();
                bq.add((Query)NumericRangeQuery.newLongRange((String)this.fieldName, null, (Long)value, (boolean)false, (boolean)false), BooleanClause.Occur.SHOULD);
                bq.add((Query)NumericRangeQuery.newLongRange((String)this.fieldName, (Long)value, null, (boolean)false, (boolean)false), BooleanClause.Occur.SHOULD);
                query = bq;
                break;
            }
            case LT: {
                query = NumericRangeQuery.newLongRange((String)this.fieldName, null, (Long)value, (boolean)false, (boolean)false);
                break;
            }
            case LT_EQ: {
                query = NumericRangeQuery.newLongRange((String)this.fieldName, null, (Long)value, (boolean)false, (boolean)true);
                break;
            }
            case GT: {
                query = NumericRangeQuery.newLongRange((String)this.fieldName, (Long)value, null, (boolean)false, (boolean)false);
                break;
            }
            case GT_EQ: {
                query = NumericRangeQuery.newLongRange((String)this.fieldName, (Long)value, null, (boolean)true, (boolean)false);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown operator " + this.operator);
            }
        }
        return this.slaQueryBuilder.add((Query)query);
    }

    public SlaQueryBuilder number(int value) {
        NumericRangeQuery query = null;
        switch (this.operator) {
            case EQ: {
                query = NumericRangeQuery.newIntRange((String)this.fieldName, (Integer)value, (Integer)value, (boolean)true, (boolean)true);
                break;
            }
            case NOT_EQ: {
                BooleanQuery bq = new BooleanQuery();
                bq.add((Query)NumericRangeQuery.newIntRange((String)this.fieldName, null, (Integer)value, (boolean)false, (boolean)false), BooleanClause.Occur.SHOULD);
                bq.add((Query)NumericRangeQuery.newIntRange((String)this.fieldName, (Integer)value, null, (boolean)false, (boolean)false), BooleanClause.Occur.SHOULD);
                query = bq;
                break;
            }
            case LT: {
                query = NumericRangeQuery.newIntRange((String)this.fieldName, null, (Integer)value, (boolean)false, (boolean)false);
                break;
            }
            case LT_EQ: {
                query = NumericRangeQuery.newIntRange((String)this.fieldName, null, (Integer)value, (boolean)false, (boolean)true);
                break;
            }
            case GT: {
                query = NumericRangeQuery.newIntRange((String)this.fieldName, (Integer)value, null, (boolean)false, (boolean)false);
                break;
            }
            case GT_EQ: {
                query = NumericRangeQuery.newIntRange((String)this.fieldName, (Integer)value, null, (boolean)true, (boolean)false);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown operator " + this.operator);
            }
        }
        return this.slaQueryBuilder.add((Query)query);
    }

    public SlaQueryBuilder date(DateTime value) {
        return this.number(value.getMillis());
    }
}

