/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.searcher.builder;

import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.servicedesk.internal.api.sla.searcher.SlaCycleState;
import com.atlassian.servicedesk.internal.api.sla.searcher.TimelineCycleState;
import com.atlassian.servicedesk.internal.api.sla.searcher.builder.SlaConditionBuilder;
import com.atlassian.servicedesk.internal.api.sla.searcher.builder.SlaQueryBuilder;
import com.atlassian.servicedesk.internal.sla.searcher.SLACustomFieldIndexer;
import com.atlassian.servicedesk.internal.sla.searcher.builder.SlaConditionBuilderImpl;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Set;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class SlaQueryBuilderImpl
implements SlaQueryBuilder {
    private CustomField customField;
    private Deque<QueryContext> queriesQueue = new ArrayDeque<QueryContext>();

    public SlaQueryBuilderImpl() {
        this.pushNew();
    }

    public SlaQueryBuilderImpl(CustomField customField) {
        this();
        this.customField = customField;
    }

    private void pushNew() {
        QueryContext queryContext = new QueryContext();
        queryContext.query = new BooleanQuery();
        queryContext.currentOperator = BooleanClause.Occur.MUST;
        this.queriesQueue.push(queryContext);
    }

    public SlaQueryBuilder field(CustomField customField) {
        this.customField = customField;
        return this;
    }

    public SlaQueryBuilder and() {
        this.queriesQueue.peek().currentOperator = BooleanClause.Occur.MUST;
        return this;
    }

    public SlaQueryBuilder or() {
        this.queriesQueue.peek().currentOperator = BooleanClause.Occur.SHOULD;
        return this;
    }

    public SlaQueryBuilder not() {
        this.queriesQueue.peek().currentOperator = BooleanClause.Occur.MUST_NOT;
        return this;
    }

    public SlaQueryBuilder add(Query luceneQuery) {
        QueryContext queryContext = this.queriesQueue.peek();
        queryContext.query.add(luceneQuery, queryContext.currentOperator);
        return this;
    }

    public SlaQueryBuilder sub() {
        this.pushNew();
        return this;
    }

    public SlaQueryBuilder endSub() {
        if (this.queriesQueue.size() < 2) {
            throw new IllegalStateException("Cannot endSub() top level query member");
        }
        QueryContext child = this.queriesQueue.pop();
        this.add((Query)child.query);
        return this;
    }

    public SlaQueryBuilder slaCycleState(Set<SlaCycleState> states) {
        if (states.isEmpty()) {
            return this;
        }
        if (states.size() == 1) {
            return this.slaCycleState(states.iterator().next());
        }
        this.sub().or();
        for (SlaCycleState state : states) {
            this.slaCycleState(state);
        }
        this.endSub();
        return this;
    }

    public SlaQueryBuilder slaCycleState(SlaCycleState state) {
        this.add((Query)new TermQuery(new Term(SLACustomFieldIndexer.getLastCycleStateFieldId(this.getCustomField()), state.getLuceneIndexValue())));
        return this;
    }

    public SlaQueryBuilder timelineCycleState(TimelineCycleState state) {
        this.add((Query)new TermQuery(new Term(SLACustomFieldIndexer.getLastTimelineCycleStateFieldId(this.getCustomField()), state.getLuceneIndexValue())));
        return this;
    }

    public SlaConditionBuilder elapsedTime() {
        return new SlaConditionBuilderImpl(this, SLACustomFieldIndexer.getPausedCycleElapsedTimeFieldId(this.getCustomField()));
    }

    public SlaConditionBuilder remainingTime() {
        return new SlaConditionBuilderImpl(this, SLACustomFieldIndexer.getPausedCycleRemainingTimeFieldId(this.getCustomField()));
    }

    public SlaConditionBuilder goalId() {
        return new SlaConditionBuilderImpl(this, SLACustomFieldIndexer.getGoalIdFieldId(this.getCustomField()));
    }

    public SlaConditionBuilder goalCheckId() {
        return new SlaConditionBuilderImpl(this, SLACustomFieldIndexer.getGoalCheckFieldId(this.getCustomField()));
    }

    public SlaQueryBuilder goalId(Set<Integer> ids) {
        if (ids.size() == 0) {
            return this;
        }
        if (ids.size() == 1) {
            return this.goalId().eq().number(ids.iterator().next().intValue());
        }
        this.sub().or();
        for (Integer id : ids) {
            this.goalId().eq().number(id.intValue());
        }
        this.endSub();
        return this;
    }

    public SlaQueryBuilder everBreached(boolean hasEverBreached) {
        this.add((Query)new TermQuery(new Term(SLACustomFieldIndexer.getAnyCyclesBreachedFieldId(this.getCustomField()), Boolean.toString(hasEverBreached))));
        return this;
    }

    public SlaQueryBuilder breached(boolean isBreached) {
        this.add((Query)new TermQuery(new Term(SLACustomFieldIndexer.getLastCompletedCycleBreachedFieldId(this.getCustomField()), Boolean.toString(isBreached))));
        return this;
    }

    public SlaConditionBuilder shiftedStartDate() {
        return new SlaConditionBuilderImpl(this, SLACustomFieldIndexer.getShiftedStartDateFieldId(this.getCustomField()));
    }

    public SlaConditionBuilder metricId() {
        return new SlaConditionBuilderImpl(this, SLACustomFieldIndexer.getMetricIdFieldId(this.getCustomField()));
    }

    public SlaConditionBuilder definitionChangeDate() {
        return new SlaConditionBuilderImpl(this, SLACustomFieldIndexer.getDefinitionChangeDateFieldId(this.getCustomField()));
    }

    public SlaConditionBuilder thresholdsConfigChangeDate() {
        return new SlaConditionBuilderImpl(this, SLACustomFieldIndexer.getThresholdsConfigChangeDateFieldId(this.getCustomField()));
    }

    public SlaConditionBuilder goalsChangeDate() {
        return new SlaConditionBuilderImpl(this, SLACustomFieldIndexer.getGoalsChangeDateFieldId(this.getCustomField()));
    }

    public SlaConditionBuilder goalTimeUpdatedDate() {
        return new SlaConditionBuilderImpl(this, SLACustomFieldIndexer.getGoalTimeUpdatedFieldId(this.getCustomField()));
    }

    public SlaConditionBuilder lastCompleteCycleEndDate() {
        return new SlaConditionBuilderImpl(this, SLACustomFieldIndexer.getLastCompletedCycleEndDateFieldId(this.getCustomField()));
    }

    public SlaConditionBuilder lastTimelineCycleEndDate() {
        return new SlaConditionBuilderImpl(this, SLACustomFieldIndexer.getLastTimelineCycleEndDateFieldId(this.getCustomField()));
    }

    public Query build() {
        if (this.queriesQueue.size() != 1) {
            throw new IllegalStateException("Query not closed properly by endSub()");
        }
        return this.queriesQueue.peek().query;
    }

    private CustomField getCustomField() {
        if (this.customField == null) {
            throw new IllegalStateException("CustomField must be set before invoking this operation");
        }
        return this.customField;
    }

    private static class QueryContext {
        public BooleanQuery query;
        public BooleanClause.Occur currentOperator;

        private QueryContext() {
        }
    }
}

