/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.searcher;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.plugins.workinghours.api.calculator.WorkingHoursCalculator;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.internal.api.ServiceDeskManager;
import com.atlassian.servicedesk.internal.api.sla.configuration.calendar.CalendarReferenceManager;
import com.atlassian.servicedesk.internal.api.sla.goal.Goal;
import com.atlassian.servicedesk.internal.sla.configuration.goal.GoalManager;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetric;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetricManager;
import com.atlassian.servicedesk.internal.sla.goal.GoalCalculationService;
import com.atlassian.servicedesk.internal.sla.goal.OngoingGoalStatus;
import com.atlassian.servicedesk.internal.sla.metric.DateTimeRange;
import com.atlassian.servicedesk.internal.sla.metric.DateTimeRangeList;
import com.atlassian.servicedesk.internal.sla.model.CompleteSLAData;
import com.atlassian.servicedesk.internal.sla.model.SLAValue;
import com.atlassian.servicedesk.internal.sla.searcher.LastCompleteCycleData;
import com.atlassian.servicedesk.internal.sla.searcher.OngoingCycleIndexingData;
import com.atlassian.servicedesk.internal.sla.searcher.SlaIndexingData;
import com.atlassian.servicedesk.internal.sla.searcher.SlaIndexingDataManager;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SlaIndexingDataManagerImpl
implements SlaIndexingDataManager {
    private final Log log = Log.with(this.getClass());
    @Autowired
    private TimeMetricManager timeMetricManager;
    @Autowired
    private GoalManager goalManager;
    @Autowired
    private ServiceDeskManager serviceDeskManager;
    @Autowired
    private CalendarReferenceManager calendarReferenceManager;
    @Autowired
    private GoalCalculationService goalCalculationService;

    @Override
    public Option<SlaIndexingData> getIndexingData(SLAValue slaValue, CustomField customField, Issue issue) {
        if (slaValue == null) {
            return Option.none();
        }
        Option<OngoingCycleIndexingData> ongoingSlaIndexingData = this.getOngoingSlaIndexingData(slaValue, customField, issue);
        if (ongoingSlaIndexingData.isEmpty() && (slaValue.getCompleteSLAData() == null || slaValue.getCompleteSLAData().size() == 0)) {
            return Option.none();
        }
        SlaIndexingData slaIndexingData = new SlaIndexingData();
        slaIndexingData.setOngoingCycleIndexingData(ongoingSlaIndexingData);
        slaIndexingData.setLastCompleteCycleData(this.computeLastCompleteCycleData(slaValue));
        slaIndexingData.setAnyCompleteCycleFailed(this.computeAnyCompleteCycleFailed(slaValue));
        return Option.some((Object)slaIndexingData);
    }

    private Option<LastCompleteCycleData> computeLastCompleteCycleData(SLAValue slaValue) {
        Option<CompleteSLAData> lastCompletedCycle = slaValue.getLastCompletedCycle();
        if (lastCompletedCycle.isEmpty()) {
            return Option.none();
        }
        LastCompleteCycleData lastCompleteCycleData = new LastCompleteCycleData();
        CompleteSLAData completeSLAData = (CompleteSLAData)lastCompletedCycle.get();
        boolean lastCompleteCycleFailed = !completeSLAData.isSucceeded();
        lastCompleteCycleData.setLastCompleteCycleFailed(lastCompleteCycleFailed);
        DateTime lastCompleteCycleEndDate = completeSLAData.getStopTime();
        lastCompleteCycleData.setLastCompleteCycleEndDate(lastCompleteCycleEndDate);
        return Option.some((Object)lastCompleteCycleData);
    }

    private boolean computeAnyCompleteCycleFailed(SLAValue slaValue) {
        if (slaValue.getCompleteSLAData() == null) {
            return false;
        }
        for (CompleteSLAData completeData : slaValue.getCompleteSLAData()) {
            if (completeData.isSucceeded()) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Option<OngoingCycleIndexingData> getOngoingSlaIndexingData(SLAValue slaValue, CustomField customField, Issue issue) {
        if (slaValue.getOngoingSLAData() == null) {
            return Option.none();
        }
        Option serviceDeskOpt = this.serviceDeskManager.getServiceDeskForProject(issue.getProjectObject()).right().toOption();
        if (serviceDeskOpt.isEmpty()) {
            return Option.none();
        }
        ServiceDesk serviceDesk = (ServiceDesk)serviceDeskOpt.get();
        Either<ErrorCollection, TimeMetric> timeMetricEither = this.timeMetricManager.getTimeMetric(serviceDesk, customField);
        if (timeMetricEither.isLeft()) {
            return Option.none();
        }
        TimeMetric timeMetric = (TimeMetric)((Object)timeMetricEither.right().get());
        Either<ErrorCollection, com.atlassian.servicedesk.internal.sla.configuration.goal.Goal> goalEither = this.goalManager.getGoal(timeMetric, slaValue.getOngoingSLAData().getGoalId());
        if (goalEither.isLeft()) {
            this.log.warn("An error occurred during SLA indexing calculations : %s", new Object[]{goalEither.left().get()});
            return Option.none();
        }
        com.atlassian.servicedesk.internal.sla.configuration.goal.Goal goal = (com.atlassian.servicedesk.internal.sla.configuration.goal.Goal)((Object)goalEither.right().get());
        if (!goal.hasDuration()) {
            return Option.none();
        }
        OngoingCycleIndexingData ongoingCycleIndexingData = new OngoingCycleIndexingData();
        ongoingCycleIndexingData.setGoalId(goal.getId());
        if (slaValue.getOngoingSLAData().isPaused()) {
            ongoingCycleIndexingData.setPaused(true);
            Option<OngoingGoalStatus> ongoingGoalStatus = this.goalCalculationService.getOngoingGoalStatus(goal, slaValue, DateTime.now());
            if (!ongoingGoalStatus.isDefined()) return Option.none();
            ongoingCycleIndexingData.setElapsedTime(((OngoingGoalStatus)ongoingGoalStatus.get()).getElapsedTime());
            ongoingCycleIndexingData.setRemainingTime(((OngoingGoalStatus)ongoingGoalStatus.get()).getRemainingTime());
            return Option.some((Object)ongoingCycleIndexingData);
        } else {
            ongoingCycleIndexingData.setShiftedStartDate(this.calculateShiftedOngoingStartDate(slaValue, goal));
        }
        return Option.some((Object)ongoingCycleIndexingData);
    }

    private DateTime calculateShiftedOngoingStartDate(SLAValue slaValue, com.atlassian.servicedesk.internal.sla.configuration.goal.Goal goal) {
        DateTimeRangeList activeHours;
        WorkingHoursCalculator calculator = this.calendarReferenceManager.getCalculatorForGoal((Goal)goal);
        DateTimeRange dateTimeRange = new DateTimeRange(slaValue.getOngoingSLAData().getStartTime(), DateTime.now());
        DateTime startDate = dateTimeRange.getStart();
        DateTime stopDate = dateTimeRange.getStop();
        DateTimeRangeList pauseRanges = DateTimeRangeList.fromRanges(slaValue.getTimeline().getPausedRanges(stopDate));
        long totalPauseDuringWorkTime = pauseRanges.intersect(activeHours = DateTimeRangeList.fromIntervals(calculator.getActiveRanges(dateTimeRange.toInterval()))).getDuration();
        DateTimeRangeList activeRanges = DateTimeRangeList.fromIntervals(calculator.getActiveRanges(startDate, totalPauseDuringWorkTime));
        Option<DateTimeRange> last = activeRanges.last();
        if (last.isDefined()) {
            return ((DateTimeRange)last.get()).getStop();
        }
        return startDate;
    }
}

