/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.searcher;

import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.validator.ClauseValidator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operator.Operator;
import com.atlassian.servicedesk.internal.api.license.ServiceDeskOperationalStatus;
import com.atlassian.servicedesk.internal.sla.searcher.SlaDurationParser;
import com.atlassian.servicedesk.internal.sla.searcher.function.SlaJqlFunctionHelper;
import com.atlassian.servicedesk.internal.user.license.ServiceDeskUserLicenseService;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Option;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;

public class SlaClauseValidator
implements ClauseValidator {
    private static final Set<Operator> IS_OPERATORS = Sets.immutableEnumSet((Enum)Operator.IS, (Enum[])new Operator[]{Operator.IS_NOT});
    private final I18nHelper.BeanFactory i18nHelperFactory;
    private final JqlOperandResolver jqlOperandResolver;
    private final ServiceDeskUserLicenseService serviceDeskUserLicenseService;
    private final ServiceDeskOperationalStatus serviceDeskOperationalStatus;

    public SlaClauseValidator(JqlOperandResolver jqlOperandResolver, I18nHelper.BeanFactory i18nHelperFactory, ServiceDeskUserLicenseService serviceDeskUserLicenseService, ServiceDeskOperationalStatus serviceDeskOperationalStatus) {
        this.jqlOperandResolver = jqlOperandResolver;
        this.i18nHelperFactory = i18nHelperFactory;
        this.serviceDeskUserLicenseService = serviceDeskUserLicenseService;
        this.serviceDeskOperationalStatus = serviceDeskOperationalStatus;
    }

    @Nonnull
    public MessageSet validate(ApplicationUser searcher, @Nonnull TerminalClause terminalClause) {
        MessageSetImpl message = new MessageSetImpl();
        Operand operand = terminalClause.getOperand();
        Operator operator = terminalClause.getOperator();
        if (!this.serviceDeskOperationalStatus.isOperational()) {
            message.addErrorMessage(this.i18nHelperFactory.getInstance(searcher).getText("sd.sla.jql.function.no.license"));
        } else if (!this.serviceDeskUserLicenseService.hasValidAgentLicense(searcher)) {
            message.addErrorMessage(this.i18nHelperFactory.getInstance(searcher).getText("sd.sla.jql.function.no.permission"));
        } else if (IS_OPERATORS.contains(operator)) {
            message.addErrorMessage(this.i18nHelperFactory.getInstance(searcher).getText("sd.sla.jql.function.is.operator.not.supported", operator.getDisplayString()));
        } else if (SlaJqlFunctionHelper.isStateFunctionOperand(operand) || SlaJqlFunctionHelper.isEverBreachedFunctionOperand(operand) || SlaJqlFunctionHelper.isBreachedFunctionOperand(operand) || SlaJqlFunctionHelper.isWithinCalendarHoursOperand(operand)) {
            if (!OperatorClasses.EQUALITY_OPERATORS.contains(operator)) {
                if (SlaJqlFunctionHelper.isWithinCalendarHoursOperand(operand)) {
                    message.addErrorMessage(this.i18nHelperFactory.getInstance(searcher).getText("sd.sla.jql.function.within.calendar.hours.wrong.operator", operator.getDisplayString()));
                } else {
                    message.addErrorMessage(this.i18nHelperFactory.getInstance(searcher).getText("sd.sla.jql.function.wrong.operator", operator.getDisplayString()));
                }
            }
        } else if (!SlaJqlFunctionHelper.isRemainingTimeFunctionOperand(operand) && !SlaJqlFunctionHelper.isElapsedTimeFunctionOperand(operand)) {
            List values2 = this.jqlOperandResolver.getValues(searcher, operand, terminalClause);
            if (values2 == null || values2.isEmpty()) {
                message.addErrorMessage(this.i18nHelperFactory.getInstance(searcher).getText("sd.sla.jql.function.missing.duration.param"));
            } else {
                for (QueryLiteral singleValue : values2) {
                    if (singleValue.getStringValue() == null) {
                        if (singleValue.getLongValue() == null) {
                            message.addErrorMessage(this.i18nHelperFactory.getInstance(searcher).getText("sd.sla.jql.function.missing.duration.param"));
                            continue;
                        }
                        if (singleValue.getLongValue() == 0L) continue;
                        message.addErrorMessage(this.i18nHelperFactory.getInstance(searcher).getText("sd.sla.jql.function.wrong.duration.param", singleValue.asString()));
                        continue;
                    }
                    Option<Long> duration = SlaDurationParser.parseDuration(singleValue.getStringValue());
                    if (!duration.isEmpty()) continue;
                    message.addErrorMessage(this.i18nHelperFactory.getInstance(searcher).getText("sd.sla.jql.function.wrong.duration.param", singleValue.getStringValue()));
                }
            }
        }
        return message;
    }
}

