/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.model;

import com.google.common.base.MoreObjects;
import io.atlassian.fugue.Option;
import org.codehaus.jackson.annotate.JsonProperty;
import org.joda.time.DateTime;

public class ThresholdData {
    @JsonProperty(value="calculatedAt")
    private DateTime calculatedAt;
    @JsonProperty(value="remainingTime")
    private Option<Long> remainingTime;
    @JsonProperty(value="thresholdsConfigChangeDate")
    private DateTime thresholdsConfigChangeDate;
    @JsonProperty(value="thresholdsConfigChangeMsEpoch")
    private Long thresholdsConfigChangeMsEpoch;

    public ThresholdData(DateTime calculatedAt, Option<Long> remainingTime, DateTime thresholdsConfigChangeDate, Long thresholdsConfigChangeMsEpoch) {
        this.calculatedAt = calculatedAt;
        this.remainingTime = remainingTime;
        this.thresholdsConfigChangeDate = thresholdsConfigChangeDate;
        this.thresholdsConfigChangeMsEpoch = thresholdsConfigChangeMsEpoch;
    }

    public ThresholdData() {
        this.remainingTime = Option.none();
    }

    public DateTime getCalculatedAt() {
        return this.calculatedAt;
    }

    public Option<Long> getRemainingTime() {
        return this.remainingTime;
    }

    public DateTime getThresholdsConfigChangeDate() {
        return this.thresholdsConfigChangeDate;
    }

    public Long getThresholdsConfigChangeMsEpoch() {
        return this.thresholdsConfigChangeMsEpoch;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("calculatedAt", (Object)this.calculatedAt).add("remainingTime", this.remainingTime).add("thresholdsConfigChangeDate", (Object)this.thresholdsConfigChangeDate).add("thresholdsConfigChangeMsEpoch", (Object)this.thresholdsConfigChangeMsEpoch).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ThresholdData thresholdData) {
        return new Builder(thresholdData);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThresholdData that = (ThresholdData)o;
        if (this.calculatedAt != null ? !this.calculatedAt.equals((Object)that.calculatedAt) : that.calculatedAt != null) {
            return false;
        }
        if (this.remainingTime != null ? !this.remainingTime.equals(that.remainingTime) : that.remainingTime != null) {
            return false;
        }
        if (this.thresholdsConfigChangeDate != null ? !this.thresholdsConfigChangeDate.equals((Object)that.thresholdsConfigChangeDate) : that.thresholdsConfigChangeDate != null) {
            return false;
        }
        return !(this.thresholdsConfigChangeMsEpoch != null ? !this.thresholdsConfigChangeMsEpoch.equals(that.thresholdsConfigChangeMsEpoch) : that.thresholdsConfigChangeMsEpoch != null);
    }

    public int hashCode() {
        int result = this.calculatedAt != null ? this.calculatedAt.hashCode() : 0;
        result = 31 * result + (this.remainingTime != null ? this.remainingTime.hashCode() : 0);
        result = 31 * result + (this.thresholdsConfigChangeDate != null ? this.thresholdsConfigChangeDate.hashCode() : 0);
        result = 31 * result + (this.thresholdsConfigChangeMsEpoch != null ? this.thresholdsConfigChangeMsEpoch.hashCode() : 0);
        return result;
    }

    public static class Builder {
        private DateTime calculatedAt;
        private Option<Long> remainingTime = Option.none();
        private DateTime thresholdsConfigChangeDate;
        private Long thresholdsConfigChangeMsEpoch;

        public Builder(ThresholdData thresholdData) {
            if (thresholdData != null) {
                this.remainingTime((Long)thresholdData.getRemainingTime().getOrNull()).calculatedAt(thresholdData.getCalculatedAt()).remainingTime(thresholdData.getRemainingTime()).calculatedAt(thresholdData.getCalculatedAt());
            }
        }

        public Builder() {
            this.remainingTime = Option.none();
        }

        public Builder remainingTime(Long remainingTime) {
            return this.remainingTime((Option<Long>)Option.option((Object)remainingTime));
        }

        public Builder remainingTime(Option<Long> remainingTime) {
            this.remainingTime = remainingTime;
            return this;
        }

        public Builder calculatedAt(DateTime calculatedAt) {
            this.calculatedAt = calculatedAt;
            return this;
        }

        public Builder thresholdsConfigChangeDate(DateTime thresholdsConfigChangeDate) {
            this.thresholdsConfigChangeDate = thresholdsConfigChangeDate;
            return this;
        }

        public Builder thresholdsConfigChangeMsEpoch(Long thresholdsConfigChangeMsEpoch) {
            this.thresholdsConfigChangeMsEpoch = thresholdsConfigChangeMsEpoch;
            return this;
        }

        public ThresholdData build() {
            return new ThresholdData(this.calculatedAt, this.remainingTime, this.thresholdsConfigChangeDate, this.thresholdsConfigChangeMsEpoch);
        }
    }
}

