/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.model;

import com.atlassian.servicedesk.internal.sla.model.CompleteSLAData;
import com.atlassian.servicedesk.internal.sla.model.OngoingSLAData;
import com.atlassian.servicedesk.internal.sla.model.Timeline;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;
import org.joda.time.DateTime;

public class SLAValue {
    @JsonProperty(value="timeline")
    private Timeline timeline;
    @JsonProperty(value="ongoingSLAData")
    private OngoingSLAData ongoingSLAData;
    @JsonProperty(value="completeSLAData")
    private List<CompleteSLAData> completeSLAData;
    private Integer metricId;
    private DateTime definitionChangeDate;
    private Long definitionChangeMsEpoch;
    private DateTime goalsChangeDate;
    private Long goalsChangeMsEpoch;
    private DateTime goalTimeUpdatedDate;
    private Long goalTimeUpdatedMsEpoch;
    private Long metricCreatedDate;

    public SLAValue() {
        this(new Timeline(), null, new ArrayList<CompleteSLAData>(), null, null, null, null, null, null, null, null);
    }

    public SLAValue(Timeline timeline, OngoingSLAData ongoingSLAData, List<CompleteSLAData> completeSLAData, Integer metricId, DateTime definitionChangeDate, Long definitionChangeMsEpoch, DateTime goalsChangeDate, Long goalsChangeMsEpoch, DateTime goalTimeUpdatedDate, Long goalTimeUpdatedMsEpoch, Long metricCreatedDate) {
        this.metricId = metricId;
        this.definitionChangeDate = definitionChangeDate;
        this.definitionChangeMsEpoch = definitionChangeMsEpoch;
        this.goalsChangeDate = goalsChangeDate;
        this.goalsChangeMsEpoch = goalsChangeMsEpoch;
        this.goalTimeUpdatedDate = goalTimeUpdatedDate;
        this.goalTimeUpdatedMsEpoch = goalTimeUpdatedMsEpoch;
        this.timeline = timeline != null ? timeline : new Timeline();
        this.ongoingSLAData = ongoingSLAData;
        this.completeSLAData = completeSLAData;
        this.metricCreatedDate = metricCreatedDate;
    }

    public Timeline getTimeline() {
        return this.timeline;
    }

    public OngoingSLAData getOngoingSLAData() {
        return this.ongoingSLAData;
    }

    public List<CompleteSLAData> getCompleteSLAData() {
        return this.completeSLAData != null ? this.completeSLAData : Lists.newArrayList();
    }

    @JsonIgnore
    public Option<CompleteSLAData> getLastCompletedCycle() {
        if (this.completeSLAData == null || this.completeSLAData.size() == 0) {
            return Option.none();
        }
        return Option.some((Object)this.completeSLAData.get(this.completeSLAData.size() - 1));
    }

    public DateTime getDefinitionChangeDate() {
        return this.definitionChangeDate;
    }

    public Long getDefinitionChangeMsEpoch() {
        return this.definitionChangeMsEpoch;
    }

    public DateTime getGoalsChangeDate() {
        return this.goalsChangeDate;
    }

    public Long getGoalsChangeMsEpoch() {
        return this.goalsChangeMsEpoch;
    }

    public DateTime getGoalTimeUpdatedDate() {
        return this.goalTimeUpdatedDate;
    }

    public Long getGoalTimeUpdatedMsEpoch() {
        return this.goalTimeUpdatedMsEpoch;
    }

    public Integer getMetricId() {
        return this.metricId;
    }

    public Long getMetricCreatedDate() {
        return this.metricCreatedDate;
    }

    @JsonIgnore
    public boolean isEmpty() {
        return !(this.timeline != null && !this.timeline.isEmpty() || this.ongoingSLAData != null || this.completeSLAData != null && !this.completeSLAData.isEmpty());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("completeSLAData", this.completeSLAData).add("timeline", (Object)this.timeline).add("ongoingSLAData", (Object)this.ongoingSLAData).add("metricId", (Object)this.metricId).add("definitionChangeDate", (Object)this.definitionChangeDate).add("definitionChangeMsEpoch", (Object)this.definitionChangeMsEpoch).add("goalsChangeDate", (Object)this.goalsChangeDate).add("goalsChangeMsEpoch", (Object)this.goalsChangeMsEpoch).add("goalTimeUpdatedDate", (Object)this.goalTimeUpdatedDate).add("goalTimeUpdatedMsEpoch", (Object)this.goalTimeUpdatedMsEpoch).add("metricCreatedDate", (Object)this.metricCreatedDate).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(SLAValue value) {
        return new Builder(value);
    }

    public static class Builder {
        private Timeline timeline = new Timeline();
        private OngoingSLAData ongoingSLAData;
        private List<CompleteSLAData> completeSLAData = new ArrayList<CompleteSLAData>();
        private Integer metricId;
        private DateTime definitionChangeDate;
        private Long definitionChangeMsEpoch;
        private DateTime goalsChangeDate;
        private Long goalsChangeMsEpoch;
        private DateTime goalTimeUpdatedDate;
        private Long goalTimeUpdatedMsEpoch;
        private Long metricCreatedDate;

        public Builder() {
        }

        public Builder(SLAValue slaValue) {
            this();
            if (slaValue != null) {
                this.timeline = slaValue.getTimeline();
                this.ongoingSLAData = slaValue.getOngoingSLAData();
                if (slaValue.completeSLAData != null) {
                    this.completeSLAData.addAll(slaValue.completeSLAData);
                }
                this.metricId = slaValue.metricId;
                this.definitionChangeDate = slaValue.definitionChangeDate;
                this.definitionChangeMsEpoch = slaValue.definitionChangeMsEpoch;
                this.goalsChangeDate = slaValue.goalsChangeDate;
                this.goalsChangeMsEpoch = slaValue.goalsChangeMsEpoch;
                this.goalTimeUpdatedDate = slaValue.goalTimeUpdatedDate;
                this.goalTimeUpdatedMsEpoch = slaValue.goalTimeUpdatedMsEpoch;
                this.metricCreatedDate = slaValue.metricCreatedDate;
            }
        }

        public Timeline getTimeline() {
            return this.timeline;
        }

        public Timeline.Builder getTimelineBuilder() {
            return Timeline.builder(this.timeline);
        }

        public Builder timeline(Timeline timeline) {
            this.timeline = timeline;
            return this;
        }

        public OngoingSLAData.Builder getOngoingSLADataBuilder() {
            return OngoingSLAData.builder(this.ongoingSLAData);
        }

        public OngoingSLAData getOngoingSLAData() {
            return this.ongoingSLAData;
        }

        public Builder ongoingSLAData(OngoingSLAData ongoingSLAData) {
            this.ongoingSLAData = ongoingSLAData;
            return this;
        }

        public Builder clearOngoingSLAData() {
            this.ongoingSLAData = null;
            this.setGoalsChangeDate(null);
            this.setGoalsChangeMsEpoch(null);
            this.setGoalTimeUpdatedDate(null);
            this.setGoalTimeUpdatedMsEpoch(null);
            return this;
        }

        public List<CompleteSLAData> getCompleteSLAData() {
            return this.completeSLAData;
        }

        public Builder addCompleteSLAData(CompleteSLAData data) {
            this.completeSLAData.add(data);
            return this;
        }

        public Builder completeSLAData(List<CompleteSLAData> data) {
            this.completeSLAData = data;
            return this;
        }

        public DateTime getDefinitionChangeDate() {
            return this.definitionChangeDate;
        }

        public Builder setDefinitionChangeDate(DateTime definitionChangeDate) {
            this.definitionChangeDate = definitionChangeDate;
            return this;
        }

        public Long getDefinitionChangeMsEpoch() {
            return this.definitionChangeMsEpoch;
        }

        public Builder setDefinitionChangeMsEpoch(Long definitionChangeMsEpoch) {
            this.definitionChangeMsEpoch = definitionChangeMsEpoch;
            return this;
        }

        public DateTime getGoalsChangeDate() {
            return this.goalsChangeDate;
        }

        public Builder setGoalsChangeDate(DateTime goalsChangeDate) {
            this.goalsChangeDate = goalsChangeDate;
            return this;
        }

        public Long getGoalsChangeMsEpoch() {
            return this.goalsChangeMsEpoch;
        }

        public Builder setGoalsChangeMsEpoch(Long goalsChangeMsEpoch) {
            this.goalsChangeMsEpoch = goalsChangeMsEpoch;
            return this;
        }

        public DateTime getGoalTimeUpdatedDate() {
            return this.goalTimeUpdatedDate;
        }

        public Builder setGoalTimeUpdatedDate(DateTime goalTimeUpdatedDate) {
            this.goalTimeUpdatedDate = goalTimeUpdatedDate;
            return this;
        }

        public Long getGoalTimeUpdatedMsEpoch() {
            return this.goalTimeUpdatedMsEpoch;
        }

        public Builder setGoalTimeUpdatedMsEpoch(Long goalTimeUpdatedMsEpoch) {
            this.goalTimeUpdatedMsEpoch = goalTimeUpdatedMsEpoch;
            return this;
        }

        public Integer getMetricId() {
            return this.metricId;
        }

        public Builder setMetricId(Integer metricId) {
            this.metricId = metricId;
            return this;
        }

        public Long getMetricCreatedDate() {
            return this.metricCreatedDate;
        }

        public Builder setMetricCreatedDate(Long metricCreatedDate) {
            this.metricCreatedDate = metricCreatedDate;
            return this;
        }

        public SLAValue build() {
            return new SLAValue(this.timeline, this.ongoingSLAData, this.completeSLAData, this.metricId, this.definitionChangeDate, this.definitionChangeMsEpoch, this.goalsChangeDate, this.goalsChangeMsEpoch, this.goalTimeUpdatedDate, this.goalTimeUpdatedMsEpoch, this.metricCreatedDate);
        }
    }
}

