/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.model;

import com.atlassian.servicedesk.internal.sla.model.ThresholdData;
import com.google.common.base.MoreObjects;
import io.atlassian.fugue.Option;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.joda.time.DateTime;

@JsonIgnoreProperties(value={"isPaused"})
public class OngoingSLAData {
    @JsonProperty(value="goalId")
    private Integer goalId;
    @JsonProperty(value="startTime")
    private DateTime startTime;
    @JsonProperty(value="paused")
    private boolean paused;
    @JsonProperty(value="thresholdData")
    private Option<ThresholdData> thresholdData;

    public OngoingSLAData() {
        this.thresholdData = Option.none();
    }

    public OngoingSLAData(Integer goalId, DateTime startTime, boolean paused, Option<ThresholdData> thresholdData) {
        this.goalId = goalId;
        this.startTime = startTime;
        this.paused = paused;
        this.thresholdData = thresholdData;
    }

    public Integer getGoalId() {
        return this.goalId;
    }

    public void setGoalId(Integer goalId) {
        this.goalId = goalId;
    }

    public DateTime getStartTime() {
        return this.startTime;
    }

    public void setStartTime(DateTime startTime) {
        this.startTime = startTime;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public Option<ThresholdData> getThresholdData() {
        return this.thresholdData;
    }

    public void setThresholdData(Option<ThresholdData> thresholdData) {
        this.thresholdData = thresholdData;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("goalId", (Object)this.goalId).add("startTime", (Object)this.startTime).add("paused", this.paused).add("thresholdData", this.thresholdData).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(OngoingSLAData value) {
        return new Builder(value);
    }

    public static class Builder {
        private Integer goalId;
        private DateTime startTime;
        private boolean paused;
        private Option<ThresholdData> thresholdData = Option.none();

        public Builder(OngoingSLAData data) {
            if (data != null) {
                this.goalId(data.goalId).startTime(data.startTime).paused(data.paused).thresholdData((Option<ThresholdData>)data.thresholdData);
            }
        }

        public Builder() {
        }

        public Builder goalId(Integer goalId) {
            this.goalId = goalId;
            return this;
        }

        public Builder startTime(DateTime time) {
            this.startTime = time;
            return this;
        }

        public Builder paused(boolean paused) {
            this.paused = paused;
            return this;
        }

        public Builder thresholdData(ThresholdData thresholdData) {
            return this.thresholdData((Option<ThresholdData>)Option.option((Object)thresholdData));
        }

        public Builder thresholdData(Option<ThresholdData> thresholdData) {
            this.thresholdData = thresholdData;
            return this;
        }

        public Integer getGoalId() {
            return this.goalId;
        }

        public DateTime getStartTime() {
            return this.startTime;
        }

        public boolean isPaused() {
            return this.paused;
        }

        public Option<ThresholdData> getThresholdData() {
            return this.thresholdData;
        }

        public OngoingSLAData build() {
            return new OngoingSLAData(this.goalId, this.startTime, this.paused, this.thresholdData);
        }
    }
}

