/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.metric;

import com.atlassian.servicedesk.api.sla.condition.HitConditionHistory;
import com.atlassian.servicedesk.api.sla.condition.MatchConditionHistory;
import com.atlassian.servicedesk.internal.sla.model.Timeline;
import com.atlassian.servicedesk.internal.sla.model.TimelineEvent;
import com.atlassian.servicedesk.internal.sla.model.TimelineEventType;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.util.List;
import java.util.Set;
import org.joda.time.DateTime;

public interface TimelineManager {
    public Option<TimelineEvent> getTimelineEvent(Timeline var1, DateTime var2, Set<TimelineEventType> var3);

    public Timeline appendToTimeline(Timeline var1, TimelineEvent var2);

    public RelevantEventTypes getRelevantEventTypes(Timeline var1);

    public Timeline buildFromHistoryData(ConditionHistoryData var1);

    public static class ConditionHistoryData {
        private List<HitConditionHistory> startData;
        private List<HitConditionHistory> stopData;
        private List<MatchConditionHistory> pauseData;

        public ConditionHistoryData(List<HitConditionHistory> startData, List<MatchConditionHistory> pauseData, List<HitConditionHistory> stopData) {
            this.startData = startData != null ? startData : Lists.newArrayList();
            this.pauseData = pauseData != null ? pauseData : Lists.newArrayList();
            this.stopData = stopData != null ? stopData : Lists.newArrayList();
        }

        public List<HitConditionHistory> getStartData() {
            return this.startData;
        }

        public List<HitConditionHistory> getStopData() {
            return this.stopData;
        }

        public List<MatchConditionHistory> getPauseData() {
            return this.pauseData;
        }
    }

    public static class RelevantEventTypes {
        private final boolean start;
        private final boolean pause;
        private final boolean stop;

        public RelevantEventTypes(boolean start, boolean pause, boolean stop) {
            this.start = start;
            this.pause = pause;
            this.stop = stop;
        }

        public boolean isStart() {
            return this.start;
        }

        public boolean isPause() {
            return this.pause;
        }

        public boolean isStop() {
            return this.stop;
        }
    }
}

