/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.metric;

import com.atlassian.annotations.tenancy.TenancyScope;
import com.atlassian.annotations.tenancy.TenantAware;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.sla.condition.HitConditionHistory;
import com.atlassian.servicedesk.api.sla.condition.HitConditionHistoryBuilder;
import com.atlassian.servicedesk.api.sla.condition.MatchConditionHistory;
import com.atlassian.servicedesk.api.sla.condition.MatchConditionHistoryBuilder;
import com.atlassian.servicedesk.internal.sla.audit.SlaAuditLogDataHelper;
import com.atlassian.servicedesk.internal.sla.audit.SlaAuditLogInput;
import com.atlassian.servicedesk.internal.sla.audit.SlaAuditLogManager;
import com.atlassian.servicedesk.internal.sla.audit.SlaAuditLogReason;
import com.atlassian.servicedesk.internal.sla.configuration.TimeMetricDefinition;
import com.atlassian.servicedesk.internal.sla.configuration.TimeMetricDefinitionManager;
import com.atlassian.servicedesk.internal.sla.configuration.condition.MetricConditionRef;
import com.atlassian.servicedesk.internal.sla.configuration.condition.MetricConditionRefManager;
import com.atlassian.servicedesk.internal.sla.configuration.goal.Goal;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetric;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetricManager;
import com.atlassian.servicedesk.internal.sla.customfield.SLAFieldManager;
import com.atlassian.servicedesk.internal.sla.customfield.SlaFieldUpdateLockManager;
import com.atlassian.servicedesk.internal.sla.goal.SlaThresholdDataManager;
import com.atlassian.servicedesk.internal.sla.goal.SlaUpdateManager;
import com.atlassian.servicedesk.internal.sla.listener.SlaValueUpdateContext;
import com.atlassian.servicedesk.internal.sla.metric.MetricStateHistoryExtractor;
import com.atlassian.servicedesk.internal.sla.metric.MetricStateHistoryExtractorConfig;
import com.atlassian.servicedesk.internal.sla.metric.TimelineManager;
import com.atlassian.servicedesk.internal.sla.model.OngoingSLAData;
import com.atlassian.servicedesk.internal.sla.model.SLAValue;
import com.atlassian.servicedesk.internal.sla.model.Timeline;
import com.atlassian.servicedesk.internal.sla.threshold.SlaThresholdEventManager;
import com.atlassian.servicedesk.internal.sla.threshold.SlaThresholdUpdateContext;
import com.atlassian.servicedesk.internal.timedpromise.TimedPromiseSlaScheduleOrigin;
import com.atlassian.servicedesk.internal.util.SafeRunner;
import com.atlassian.servicedesk.spi.sla.condition.TimeMetricHitCondition;
import com.atlassian.servicedesk.spi.sla.condition.TimeMetricMatchCondition;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MetricStateHistoryExtractorImpl
implements MetricStateHistoryExtractor {
    private static final Log log = Log.with(MetricStateHistoryExtractorImpl.class);
    private final TimeMetricManager timeMetricManager;
    private final MetricConditionRefManager metricConditionRefManager;
    private final SLAFieldManager slaFieldManager;
    private final TimeMetricDefinitionManager timeMetricDefinitionManager;
    private final TimelineManager timelineManager;
    private final IssueIndexManager issueIndexManager;
    private final SlaUpdateManager slaUpdateManager;
    private final SlaThresholdDataManager slaThresholdDataManager;
    private final SlaThresholdEventManager slaThresholdEventManager;
    private final SlaFieldUpdateLockManager slaFieldUpdateLockManager;
    private final SlaAuditLogManager slaAuditLogManager;
    private final SlaAuditLogDataHelper slaAuditLogDataHelper;
    private final SafeRunner safeRunner;

    @Autowired
    public MetricStateHistoryExtractorImpl(TimeMetricManager timeMetricManager, MetricConditionRefManager metricConditionRefManager, SLAFieldManager slaFieldManager, TimeMetricDefinitionManager timeMetricDefinitionManager, TimelineManager timelineManager, IssueIndexManager issueIndexManager, SlaUpdateManager slaUpdateManager, SlaThresholdDataManager slaThresholdDataManager, SlaThresholdEventManager slaThresholdEventManager, SlaFieldUpdateLockManager slaFieldUpdateLockManager, SlaAuditLogManager slaAuditLogManager, SlaAuditLogDataHelper slaAuditLogDataHelper, SafeRunner safeRunner) {
        this.timeMetricManager = timeMetricManager;
        this.metricConditionRefManager = metricConditionRefManager;
        this.slaFieldManager = slaFieldManager;
        this.timeMetricDefinitionManager = timeMetricDefinitionManager;
        this.timelineManager = timelineManager;
        this.issueIndexManager = issueIndexManager;
        this.slaUpdateManager = slaUpdateManager;
        this.slaThresholdDataManager = slaThresholdDataManager;
        this.slaThresholdEventManager = slaThresholdEventManager;
        this.slaFieldUpdateLockManager = slaFieldUpdateLockManager;
        this.slaAuditLogManager = slaAuditLogManager;
        this.slaAuditLogDataHelper = slaAuditLogDataHelper;
        this.safeRunner = safeRunner;
    }

    @Override
    public MetricStateHistoryExtractorConfig loadConfiguration(ServiceDesk serviceDesk) {
        MetricStateHistoryExtractorConfig config = new MetricStateHistoryExtractorConfig();
        config.setServiceDesk(serviceDesk);
        List<TimeMetric> timeMetrics = this.timeMetricManager.getTimeMetrics(serviceDesk);
        for (TimeMetric timeMetric : timeMetrics) {
            List<MetricConditionRef> metricConditions = this.metricConditionRefManager.getMetricConditions(timeMetric);
            config.add(timeMetric, metricConditions);
        }
        return config;
    }

    @Override
    public void extractTimeMetricHistory(Issue issue, MetricStateHistoryExtractorConfig config, Option<SlaAuditLogReason> reason) {
        this.extractHistoryForMetrics(issue, config, reason);
        try {
            this.issueIndexManager.reIndex(issue, false, false);
        }
        catch (IndexException e) {
            log.warn("Unable to reindex issue", new Object[]{e});
        }
    }

    @Override
    public SLAValue calculateSLAValueForSpecialDebugAndAdminPurposes(Issue issue, TimeMetric timeMetric, List<MetricConditionRef> conditions, Goal goal, DateTime now) {
        Option<OngoingSLAData> ongoingSLAData;
        ConditionHistoryCache historyCache = new ConditionHistoryCache();
        SLAValue.Builder builder = SLAValue.builder();
        this.extractTimeline(issue, timeMetric, conditions, historyCache, builder);
        this.slaUpdateManager.calculateSlaForSpecialDebugAndAdminPurposes(timeMetric, issue, goal, builder);
        if (builder.getOngoingSLAData() != null && (ongoingSLAData = this.slaThresholdDataManager.updateThresholdData(timeMetric, builder.getTimeline(), builder.getOngoingSLAData(), now)).isDefined()) {
            builder.ongoingSLAData((OngoingSLAData)ongoingSLAData.get());
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractHistoryForMetrics(Issue issue, MetricStateHistoryExtractorConfig config, Option<SlaAuditLogReason> reason) {
        ConditionHistoryCache historyCache = new ConditionHistoryCache();
        SlaThresholdUpdateContext slaThresholdUpdateContext = new SlaThresholdUpdateContext(issue);
        DateTime now = DateTime.now();
        for (MetricStateHistoryExtractorConfig.TimeMetricConfig metricConfig : config.getMetrics()) {
            TimeMetric timeMetric = metricConfig.getTimeMetric();
            this.slaFieldUpdateLockManager.lockSlaUpdate(issue, timeMetric);
            try {
                SlaValueUpdateContext slaValueUpdateContext = new SlaValueUpdateContext();
                this.extractHistoryForMetric(issue, metricConfig, historyCache, slaValueUpdateContext, now).forEach(newValue -> {
                    if (slaValueUpdateContext.isRequiresFieldUpdate()) {
                        this.safeRunner.run(() -> this.createAuditLogEntry(issue, reason, now, metricConfig, (SLAValue)newValue));
                        this.slaFieldManager.setFieldValue(timeMetric, issue, (SLAValue)newValue);
                    }
                    this.slaThresholdEventManager.calculateNextExceedingSlaThresholdTime(timeMetric, (SLAValue)newValue, now, slaThresholdUpdateContext);
                });
            }
            finally {
                this.slaFieldUpdateLockManager.unlockSlaUpdate(issue, timeMetric);
            }
        }
        this.slaThresholdEventManager.scheduleNextExceedingSlaThresholdTimedPromise(slaThresholdUpdateContext, TimedPromiseSlaScheduleOrigin.CONSISTENCY_TASK);
    }

    private void createAuditLogEntry(Issue issue, Option<SlaAuditLogReason> reason, DateTime now, MetricStateHistoryExtractorConfig.TimeMetricConfig metricConfig, SLAValue newValue) {
        this.slaAuditLogManager.createAuditLogRecords(Lists.newArrayList((Object[])new SlaAuditLogInput[]{new SlaAuditLogInput((Option<Long>)Option.some((Object)issue.getId()), (Option<Long>)Option.some((Object)metricConfig.getTimeMetric().getId().longValue()), reason, now.getMillis(), (Option<Map<String, String>>)Option.some(this.slaAuditLogDataHelper.determineSlaValueData(newValue, issue)))}));
    }

    private Option<SLAValue> extractHistoryForMetric(Issue issue, MetricStateHistoryExtractorConfig.TimeMetricConfig metricConfig, ConditionHistoryCache historyCache, SlaValueUpdateContext slaValueUpdateContext, DateTime now) {
        boolean thresholdDataChanged;
        TimeMetric timeMetric = metricConfig.getTimeMetric();
        Either<ErrorCollection, CustomField> byId = this.slaFieldManager.getById(timeMetric.getCustomFieldId());
        if (byId.isLeft()) {
            return Option.none();
        }
        SLAValue slaValue = this.slaFieldManager.getFieldValue(issue, timeMetric);
        SLAValue.Builder builder = SLAValue.builder(slaValue);
        boolean timelineChanged = this.extractTimelineIfOutdated(issue, timeMetric, metricConfig.getConditions(), historyCache, builder);
        boolean slaChanged = this.slaUpdateManager.restoreSla(timeMetric, issue, builder, timelineChanged);
        if (builder.getOngoingSLAData() != null) {
            thresholdDataChanged = this.thresholdsConfigChangeDateMismatch(timeMetric, builder.getOngoingSLAData());
            this.slaThresholdDataManager.updateThresholdData(timeMetric, builder.getTimeline(), builder.getOngoingSLAData(), now).forEach(builder::ongoingSLAData);
        } else {
            thresholdDataChanged = false;
        }
        if (timelineChanged || slaChanged || thresholdDataChanged) {
            slaValueUpdateContext.setFieldUpdatedRequired();
        }
        return Option.some((Object)builder.build());
    }

    private boolean thresholdsConfigChangeDateMismatch(TimeMetric timeMetric, OngoingSLAData ongoingSLAData) {
        return ongoingSLAData.getThresholdData().forall(data -> {
            Long ms = data.getThresholdsConfigChangeMsEpoch();
            Long msMetric = timeMetric.getThresholdsChangedMsEpoch();
            return ms == null || !ms.equals(msMetric);
        });
    }

    private boolean extractTimelineIfOutdated(Issue issue, TimeMetric timeMetric, List<MetricConditionRef> conditions, ConditionHistoryCache historyCache, SLAValue.Builder builder) {
        if (this.isMetricUpToDate(timeMetric, builder)) {
            return false;
        }
        return this.extractTimeline(issue, timeMetric, conditions, historyCache, builder);
    }

    private boolean extractTimeline(Issue issue, TimeMetric timeMetric, List<MetricConditionRef> conditions, ConditionHistoryCache historyCache, SLAValue.Builder builder) {
        TimeMetricDefinition<TimeMetricHitCondition, TimeMetricMatchCondition> definition = this.timeMetricDefinitionManager.loadDefinition(conditions);
        this.evaluateConditions(issue, definition, historyCache);
        Timeline timeline = this.timelineManager.buildFromHistoryData(historyCache.getConditionHistoryData(definition));
        builder.timeline(timeline);
        builder.setDefinitionChangeDate(timeMetric.getDefinitionChangeDate());
        builder.setDefinitionChangeMsEpoch(timeMetric.getDefinitionChangeMsEpoch());
        builder.setMetricId(timeMetric.getId());
        builder.setMetricCreatedDate(timeMetric.getCreatedDate());
        return true;
    }

    private boolean isMetricUpToDate(TimeMetric timeMetric, SLAValue.Builder builder) {
        Integer storedMetricId = builder.getMetricId();
        Integer metricId = timeMetric.getId();
        if (metricId.equals(storedMetricId)) {
            Long ms = builder.getDefinitionChangeMsEpoch();
            Long msMetric = timeMetric.getDefinitionChangeMsEpoch();
            return ms != null && ms.equals(msMetric);
        }
        return false;
    }

    private void evaluateConditions(Issue issue, TimeMetricDefinition<TimeMetricHitCondition, TimeMetricMatchCondition> definition, ConditionHistoryCache historyCache) {
        this.evaluateHitConditions(issue, definition.getStartConditions(), historyCache);
        this.evaluateMatchConditions(issue, definition.getPauseConditions(), historyCache);
        this.evaluateHitConditions(issue, definition.getStopConditions(), historyCache);
    }

    private void evaluateHitConditions(Issue issue, Set<TimeMetricHitCondition> conditions, ConditionHistoryCache historyCache) {
        for (TimeMetricHitCondition condition : conditions) {
            if (historyCache.hasData(condition)) continue;
            HitConditionHistory history = this.safeHistory(condition, issue);
            historyCache.addHistory(condition, history);
        }
    }

    private HitConditionHistory safeHistory(TimeMetricHitCondition condition, Issue issue) {
        try {
            return condition.getHistory(issue);
        }
        catch (Exception e) {
            log.warnDebug(e, "An %s exception was thrown getting history from type %s", new Object[]{e.getMessage(), this.safeClass(condition)});
            return HitConditionHistoryBuilder.newBuilder().build();
        }
    }

    private MatchConditionHistory safeHistory(TimeMetricMatchCondition condition, Issue issue) {
        try {
            return condition.getHistory(issue);
        }
        catch (Exception e) {
            log.warnDebug(e, "An %s exception was thrown getting history from type %s", new Object[]{e.getMessage(), this.safeClass(condition)});
            return MatchConditionHistoryBuilder.newBuilder().build();
        }
    }

    private Object safeClass(Object o) {
        return o == null ? "null" : o.getClass().getName();
    }

    private void evaluateMatchConditions(Issue issue, Set<TimeMetricMatchCondition> conditions, ConditionHistoryCache historyCache) {
        for (TimeMetricMatchCondition condition : conditions) {
            if (historyCache.hasData(condition)) continue;
            MatchConditionHistory history = this.safeHistory(condition, issue);
            historyCache.addHistory(condition, history);
        }
    }

    private static class ConditionHistoryCache {
        @TenantAware(value=TenancyScope.TENANTED)
        Map<TimeMetricHitCondition, HitConditionHistory> hitData = Maps.newHashMap();
        @TenantAware(value=TenancyScope.TENANTED)
        Map<TimeMetricMatchCondition, MatchConditionHistory> matchData = Maps.newHashMap();

        private ConditionHistoryCache() {
        }

        public boolean hasData(TimeMetricHitCondition condition) {
            return this.hitData.containsKey(condition);
        }

        public boolean hasData(TimeMetricMatchCondition condition) {
            return this.matchData.containsKey(condition);
        }

        public void addHistory(TimeMetricHitCondition condition, HitConditionHistory history) {
            this.hitData.put(condition, history);
        }

        public void addHistory(TimeMetricMatchCondition condition, MatchConditionHistory history) {
            this.matchData.put(condition, history);
        }

        public HitConditionHistory getHistory(TimeMetricHitCondition condition) {
            return this.hitData.get(condition);
        }

        public MatchConditionHistory getHistory(TimeMetricMatchCondition condition) {
            return this.matchData.get(condition);
        }

        public TimelineManager.ConditionHistoryData getConditionHistoryData(TimeMetricDefinition<TimeMetricHitCondition, TimeMetricMatchCondition> definition) {
            ArrayList startData = Lists.newArrayList();
            for (TimeMetricHitCondition timeMetricHitCondition : definition.getStartConditions()) {
                HitConditionHistory history = this.getHistory(timeMetricHitCondition);
                if (history == null) continue;
                startData.add(history);
            }
            ArrayList pauseData = Lists.newArrayList();
            for (TimeMetricMatchCondition condition : definition.getPauseConditions()) {
                MatchConditionHistory history = this.getHistory(condition);
                if (history == null) continue;
                pauseData.add(history);
            }
            ArrayList arrayList = Lists.newArrayList();
            for (TimeMetricHitCondition condition : definition.getStopConditions()) {
                HitConditionHistory history = this.getHistory(condition);
                if (history == null) continue;
                arrayList.add(history);
            }
            return new TimelineManager.ConditionHistoryData(startData, pauseData, arrayList);
        }
    }
}

