/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.metric;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.servicedesk.internal.sla.metric.DateTimeRange;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class DateTimeRangeList {
    private static final Log log = Log.with(DateTimeRangeList.class);
    private List<DateTimeRange> ranges;

    public static DateTimeRangeList emptyList() {
        return new DateTimeRangeList(Lists.newArrayList());
    }

    public static DateTimeRangeList from(DateTimeRange range) {
        return new DateTimeRangeList(Lists.newArrayList((Object[])new DateTimeRange[]{range}));
    }

    public static DateTimeRangeList fromIntervals(List<Interval> intervals) {
        ArrayList ranges = Lists.newArrayList();
        for (Interval interval : intervals) {
            int comparison = interval.getStart().compareTo((ReadableInstant)interval.getEnd());
            if (comparison < 0) {
                ranges.add(new DateTimeRange(interval.getStart(), interval.getEnd()));
                continue;
            }
            if (comparison <= 0) continue;
            log.warn("Interval of length " + String.valueOf(interval.getEnd().getMillis() - interval.getStart().getMillis()) + " encountered: %s", new Object[]{interval});
        }
        return DateTimeRangeList.fromRanges(ranges);
    }

    public static DateTimeRangeList fromRanges(List<DateTimeRange> ranges) {
        ranges = ranges.stream().filter(range -> range.getDuration() > 0L).collect(Collectors.toList());
        Collections.sort(ranges);
        Iterator<DateTimeRange> iterator = ranges.iterator();
        ArrayList cleanRanges = Lists.newArrayListWithCapacity((int)ranges.size());
        if (iterator.hasNext()) {
            DateTimeRange prev = iterator.next();
            while (iterator.hasNext()) {
                DateTimeRange next = iterator.next();
                if (prev.overlaps(next)) {
                    prev = prev.getEnclosingRange(next);
                    continue;
                }
                cleanRanges.add(prev);
                prev = next;
            }
            cleanRanges.add(prev);
        }
        return new DateTimeRangeList(cleanRanges);
    }

    private DateTimeRangeList(List<DateTimeRange> ranges) {
        this.ranges = ranges;
    }

    public List<DateTimeRange> getRanges() {
        return Lists.newArrayList(this.ranges);
    }

    public int size() {
        return this.ranges.size();
    }

    public Option<DateTimeRange> first() {
        if (this.ranges.isEmpty()) {
            return Option.none();
        }
        return Option.some((Object)this.ranges.get(0));
    }

    public Option<DateTimeRange> last() {
        int size = this.ranges.size();
        if (size > 0) {
            return Option.some((Object)this.ranges.get(size - 1));
        }
        return Option.none();
    }

    public DateTimeRangeList intersect(DateTimeRange limit) {
        DateTimeRangeList list = DateTimeRangeList.from(limit);
        return this.intersect(list);
    }

    public DateTimeRangeList intersect(DateTimeRangeList rangeList) {
        ArrayList resultRanges = Lists.newArrayList();
        Iterator<DateTimeRange> first = this.ranges.iterator();
        Iterator<DateTimeRange> second = rangeList.ranges.iterator();
        if (!first.hasNext() || !second.hasNext()) {
            return DateTimeRangeList.emptyList();
        }
        DateTimeRange firstRange = first.next();
        DateTimeRange secondRange = second.next();
        while (firstRange != null && secondRange != null) {
            int res;
            DateTimeRange intersection = firstRange.intersect(secondRange);
            if (intersection != null) {
                resultRanges.add(intersection);
            }
            if ((res = firstRange.getStop().compareTo((ReadableInstant)secondRange.getStop())) <= 0) {
                firstRange = first.hasNext() ? first.next() : null;
            }
            if (res < 0) continue;
            if (second.hasNext()) {
                secondRange = second.next();
                continue;
            }
            secondRange = null;
        }
        return new DateTimeRangeList(resultRanges);
    }

    public DateTimeRangeList inverse(DateTimeRange bounds) {
        ArrayList resultRanges = Lists.newArrayList();
        DateTime currentStart = bounds.getStart();
        for (DateTimeRange range : this.ranges) {
            DateTime rangeStart = range.getStart();
            if (rangeStart.compareTo((ReadableInstant)currentStart) > 0) {
                resultRanges.add(new DateTimeRange(currentStart, rangeStart));
            }
            currentStart = range.getStop();
        }
        if (currentStart.compareTo((ReadableInstant)bounds.getStop()) < 0) {
            resultRanges.add(new DateTimeRange(currentStart, bounds.getStop()));
        }
        return new DateTimeRangeList(resultRanges);
    }

    public long getDuration() {
        long totalDuration = 0L;
        for (DateTimeRange range : this.ranges) {
            totalDuration += range.getDuration();
        }
        return totalDuration;
    }
}

