/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.metric;

import com.atlassian.jira.util.dbc.Assertions;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class DateTimeRange
implements Comparable<DateTimeRange> {
    private static final long allowableClockDriftMs = 5000L;
    private DateTime start;
    private DateTime stop;

    public DateTimeRange(DateTime start, DateTime stop) {
        this.start = (DateTime)Assertions.notNull((String)"start date", (Object)start);
        this.stop = DateTimeRange.sanitiseStopTime(start, (DateTime)Assertions.notNull((String)"stop date", (Object)stop));
        if (this.start.compareTo((ReadableInstant)this.stop) > 0) {
            throw new IllegalArgumentException("com.atlassian.servicedesk.internal.sla.metric.DateTimeRange - the START time of the DateTimeRange (" + start.withZone(DateTimeZone.UTC).toString() + ") must be less than or equal to the STOP time (" + stop.withZone(DateTimeZone.UTC).toString() + ")");
        }
    }

    public DateTime getStart() {
        return this.start;
    }

    public DateTime getStop() {
        return this.stop;
    }

    public long getDuration() {
        return this.stop.getMillis() - this.start.getMillis();
    }

    public boolean contains(DateTime dateTime) {
        return this.start.compareTo((ReadableInstant)dateTime) <= 0 && this.stop.compareTo((ReadableInstant)dateTime) >= 0;
    }

    public boolean overlaps(DateTimeRange range) {
        return this.contains(range.start) || range.contains(this.start);
    }

    public DateTimeRange getEnclosingRange(DateTimeRange range) {
        DateTime resultStop;
        if (range == null) {
            return this;
        }
        DateTime resultStart = this.start;
        if (resultStart.compareTo((ReadableInstant)range.start) > 0) {
            resultStart = range.start;
        }
        if ((resultStop = this.stop).compareTo((ReadableInstant)range.stop) < 0) {
            resultStop = range.stop;
        }
        return new DateTimeRange(resultStart, resultStop);
    }

    public DateTimeRange intersect(DateTimeRange range) {
        DateTime resultStop;
        if (range == null) {
            return null;
        }
        if (!this.overlaps(range)) {
            return null;
        }
        DateTime resultStart = this.start;
        if (resultStart.compareTo((ReadableInstant)range.start) < 0) {
            resultStart = range.start;
        }
        if ((resultStop = this.stop).compareTo((ReadableInstant)range.stop) > 0) {
            resultStop = range.stop;
        }
        if (resultStart.compareTo((ReadableInstant)resultStop) == 0) {
            return null;
        }
        return new DateTimeRange(resultStart, resultStop);
    }

    public Interval toInterval() {
        return new Interval((ReadableInstant)this.start, (ReadableInstant)this.stop);
    }

    @Override
    public int compareTo(DateTimeRange o) {
        int comp = this.start.compareTo((ReadableInstant)o.start);
        if (comp != 0) {
            return comp;
        }
        return this.stop.compareTo((ReadableInstant)o.stop);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DateTimeRange)) {
            return false;
        }
        DateTimeRange that = (DateTimeRange)o;
        if (!this.start.equals((Object)that.start)) {
            return false;
        }
        return this.stop.equals((Object)that.stop);
    }

    public int hashCode() {
        int result = this.start.hashCode();
        result = 31 * result + this.stop.hashCode();
        return result;
    }

    public String toString() {
        return "DateTimeRange{start=" + this.start + ", stop=" + this.stop + '}';
    }

    public static DateTime sanitiseStopTime(DateTime start, DateTime stop) {
        if (stop.getMillis() >= start.getMillis()) {
            return stop;
        }
        if (start.getMillis() - stop.getMillis() < 5000L) {
            return start;
        }
        return stop;
    }
}

