/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.info;

import com.atlassian.servicedesk.api.sla.info.SlaInformation;
import com.atlassian.servicedesk.api.sla.info.SlaInformationCompletedCycle;
import com.atlassian.servicedesk.api.sla.info.SlaInformationOngoingCycle;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;

class SlaInformationImpl
implements SlaInformation {
    private final Long id;
    private final String name;
    private final List<SlaInformationCompletedCycle> completedCycles;
    private final Optional<SlaInformationOngoingCycle> ongoingCycle;

    private SlaInformationImpl(Long id, String name, Iterable<SlaInformationCompletedCycle> completedCycles, Optional<SlaInformationOngoingCycle> ongoingCycle) {
        this.id = (Long)Preconditions.checkNotNull((Object)id);
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.completedCycles = ImmutableList.copyOf(completedCycles);
        this.ongoingCycle = (Optional)Preconditions.checkNotNull(ongoingCycle);
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List<SlaInformationCompletedCycle> getCompletedCycles() {
        return this.completedCycles;
    }

    public Optional<SlaInformationOngoingCycle> getOngoingCycle() {
        return this.ongoingCycle;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(SlaInformationImpl data) {
        return new Builder(data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SlaInformationImpl that = (SlaInformationImpl)o;
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal(this.completedCycles, that.completedCycles) && Objects.equal(this.ongoingCycle, that.ongoingCycle);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.name, this.completedCycles, this.ongoingCycle});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("name", (Object)this.name).add("completedCycles", this.completedCycles).add("ongoingCycle", this.ongoingCycle).toString();
    }

    public static final class Builder {
        private Long id;
        private String name;
        private List<SlaInformationCompletedCycle> completedCycles = Lists.newArrayList();
        private Optional<SlaInformationOngoingCycle> ongoingCycle = Optional.empty();

        private Builder() {
        }

        private Builder(SlaInformationImpl initialData) {
            this.id = initialData.id;
            this.name = initialData.name;
            this.completedCycles = initialData.completedCycles;
            this.ongoingCycle = initialData.ongoingCycle;
        }

        public Builder setId(Long id) {
            this.id = id;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setCompletedCycles(List<SlaInformationCompletedCycle> completedCycles) {
            this.completedCycles = completedCycles;
            return this;
        }

        public Builder addCompletedCycle(SlaInformationCompletedCycle completedCycle) {
            this.completedCycles.add(completedCycle);
            return this;
        }

        public Builder addCompletedCycles(Iterable<SlaInformationCompletedCycle> completedCycles) {
            for (SlaInformationCompletedCycle completedCycle : completedCycles) {
                this.addCompletedCycle(completedCycle);
            }
            return this;
        }

        public Builder setOngoingCycle(Optional<SlaInformationOngoingCycle> ongoingCycle) {
            this.ongoingCycle = ongoingCycle;
            return this;
        }

        public SlaInformationImpl build() {
            return new SlaInformationImpl(this.id, this.name, this.completedCycles, this.ongoingCycle);
        }
    }
}

