/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.goal.view;

import com.atlassian.fugue.Either;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.ServiceDeskService;
import com.atlassian.servicedesk.internal.api.featureflag.ServiceDeskFeatureFlags;
import com.atlassian.servicedesk.internal.api.sla.configuration.calendar.CalendarReference;
import com.atlassian.servicedesk.internal.api.sla.configuration.calendar.CalendarReferenceManager;
import com.atlassian.servicedesk.internal.api.sla.goal.Goal;
import com.atlassian.servicedesk.internal.api.sla.metric.TimeMetricMeasureType;
import com.atlassian.servicedesk.internal.api.sla.util.SlaDurationFormatter;
import com.atlassian.servicedesk.internal.sla.condition.TimeMetricHitConditionInfo;
import com.atlassian.servicedesk.internal.sla.configuration.TimeMetricDefinitionInfo;
import com.atlassian.servicedesk.internal.sla.configuration.TimeMetricDefinitionService;
import com.atlassian.servicedesk.internal.sla.configuration.goal.GoalService;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.InternalTimeMetricService;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetric;
import com.atlassian.servicedesk.internal.sla.customfield.SLAFieldService;
import com.atlassian.servicedesk.internal.sla.goal.GoalCalculationService;
import com.atlassian.servicedesk.internal.sla.goal.OngoingGoalStatus;
import com.atlassian.servicedesk.internal.sla.goal.view.CompleteGoalViewData;
import com.atlassian.servicedesk.internal.sla.goal.view.GoalBaseViewData;
import com.atlassian.servicedesk.internal.sla.goal.view.GoalColor;
import com.atlassian.servicedesk.internal.sla.goal.view.GoalColorService;
import com.atlassian.servicedesk.internal.sla.goal.view.GoalDetailedViewData;
import com.atlassian.servicedesk.internal.sla.goal.view.GoalSummaryViewData;
import com.atlassian.servicedesk.internal.sla.goal.view.GoalViewService;
import com.atlassian.servicedesk.internal.sla.model.CompleteSLAData;
import com.atlassian.servicedesk.internal.sla.model.OngoingSLAData;
import com.atlassian.servicedesk.internal.sla.model.SLAValue;
import com.atlassian.servicedesk.internal.sla.model.Timeline;
import com.atlassian.servicedesk.spi.sla.condition.TimeMetricHitCondition;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.primitives.Longs;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GoalViewServiceImpl
implements GoalViewService {
    @Autowired
    private ServiceDeskService serviceDeskService;
    @Autowired
    private InternalTimeMetricService timeMetricService;
    @Autowired
    private GoalCalculationService goalCalculationService;
    @Autowired
    private GoalService goalService;
    @Autowired
    private CalendarReferenceManager calendarReferenceManager;
    @Autowired
    private SLAFieldService slaFieldService;
    @Autowired
    private SlaDurationFormatter formatter;
    @Autowired
    private TimeMetricDefinitionService timeMetricDefinitionService;
    @Autowired
    private I18nHelper.BeanFactory i18nFactory;
    @Autowired
    private DateTimeFormatter dateTimeFormatter;
    @Autowired
    private GoalColorService goalColorService;
    @Autowired
    private FeatureManager featureManager;

    @Override
    public List<GoalDetailedViewData> getGoalDataForDetailView(ApplicationUser viewingUser, Issue issue) {
        io.atlassian.fugue.Either serviceDeskResponse = StepsConverters.newerEither((Either)this.serviceDeskService.getServiceDeskForProject(viewingUser, issue.getProjectObject()));
        if (serviceDeskResponse.isLeft()) {
            return Lists.newArrayList();
        }
        List<TimeMetric> timeMetrics = this.timeMetricService.getTimeMetrics(viewingUser, (ServiceDesk)serviceDeskResponse.right().get());
        ArrayList<GoalDetailedViewData> viewContents = new ArrayList<GoalDetailedViewData>();
        for (TimeMetric timeMetric : timeMetrics) {
            Option<GoalDetailedViewData> detailedViewContent = this.getDetailedViewData(viewingUser, issue, timeMetric);
            if (!detailedViewContent.isDefined()) continue;
            viewContents.add((GoalDetailedViewData)detailedViewContent.get());
        }
        Collections.sort(viewContents, new GoalRemainingTimeComparator());
        return viewContents;
    }

    private Option<GoalDetailedViewData> getDetailedViewData(ApplicationUser user, Issue issue, TimeMetric timeMetric) {
        io.atlassian.fugue.Either<ErrorCollection, SLAValue> fieldValueResult = this.slaFieldService.getFieldValue(user, issue, timeMetric);
        if (fieldValueResult.isLeft()) {
            return Option.none();
        }
        SLAValue value = (SLAValue)fieldValueResult.right().get();
        Option<GoalDetailedViewData> content = this.getOngoingCycleViewInformation(user, timeMetric, value, issue);
        if (content.isEmpty()) {
            content = this.getLatestCompleteCycleViewInformation(user, timeMetric, value, issue);
        }
        return content;
    }

    private Option<GoalDetailedViewData> getOngoingCycleViewInformation(ApplicationUser user, TimeMetric timeMetric, SLAValue value, Issue issue) {
        Option<GoalCycleViewInformation> mainInfo = this.getOngoingInformation(user, timeMetric, value);
        if (mainInfo.isEmpty()) {
            return Option.none();
        }
        GoalDetailedViewData content = this.createDetailView(user, timeMetric, (GoalCycleViewInformation)mainInfo.get());
        content.completeGoals = this.generatePreviousCyclesList(user, timeMetric, value.getCompleteSLAData(), value.getTimeline(), issue);
        return Option.some((Object)content);
    }

    private Option<GoalDetailedViewData> getLatestCompleteCycleViewInformation(ApplicationUser user, TimeMetric timeMetric, SLAValue value, Issue issue) {
        Option<CompleteSLAData> lastCompletedCycle = value.getLastCompletedCycle();
        if (lastCompletedCycle.isEmpty()) {
            return Option.none();
        }
        GoalCycleViewInformation mainInfo = this.getCompleteInformation(user, timeMetric, (CompleteSLAData)lastCompletedCycle.get(), value.getTimeline(), issue);
        GoalDetailedViewData content = this.createDetailView(user, timeMetric, mainInfo);
        if (value.getCompleteSLAData().size() > 1) {
            content.completeGoals = this.generatePreviousCyclesList(user, timeMetric, value.getCompleteSLAData().subList(0, value.getCompleteSLAData().size() - 1), value.getTimeline(), issue);
        }
        return Option.some((Object)content);
    }

    private GoalDetailedViewData createDetailView(ApplicationUser user, TimeMetric timeMetric, GoalCycleViewInformation info) {
        TimeMetricDefinitionInfo metricInfo = this.timeMetricDefinitionService.loadDefinitionConfiguration(user, timeMetric);
        GoalDetailedViewData content = new GoalDetailedViewData();
        this.setBaseViewData(content, info);
        content.goalTime = this.formatter.getShortFormattedGoalDuration(info.goalTime, user);
        content.goalTimeLong = this.formatter.getLongFormattedGoalDuration(info.goalTime, user);
        content.metricName = info.metricName;
        content.remainingTime = this.formatter.getShortFormattedRemainingDuration(info.remainingTime, user);
        content.remainingTimeLong = this.formatter.getLongFormattedRemainingDuration(info.remainingTime, user);
        content.setRemainingTimeInMilliseconds(info.remainingTime);
        content.calendarName = info.calendarName;
        content.currentJqlMatch = info.goalJql;
        content.remainingTimeHumanReadable = this.formatter.getRemainingTimeInDaysAndMillisFormatted(info.remainingTimeInDaysAndMillis, user);
        DateTimeFormatter dateTimeFormatter = this.dateTimeFormatter.forUser(user).withStyle(DateTimeStyle.RELATIVE);
        if (info.startTime != null) {
            content.startTime = dateTimeFormatter.format(info.startTime.toDate());
        }
        if (info.stopTime != null) {
            content.stopTime = dateTimeFormatter.format(info.stopTime.toDate());
        }
        if (Strings.isNullOrEmpty((String)content.currentJqlMatch)) {
            content.currentJqlMatch = this.i18nFactory.getInstance(user).getText("sd.sla.configuration.metric.goal.default");
        }
        content.nextConditionMatch = info.closed ? this.formatCondition(user, metricInfo.getStartConditions()) : this.formatCondition(user, metricInfo.getStopConditions());
        return content;
    }

    private List<CompleteGoalViewData> generatePreviousCyclesList(ApplicationUser user, TimeMetric timeMetric, List<CompleteSLAData> completeCycles, Timeline timeline, Issue issue) {
        if (completeCycles == null) {
            return Lists.newArrayList();
        }
        ArrayList result = Lists.newArrayList();
        for (int index = completeCycles.size() - 1; index >= 0; --index) {
            GoalCycleViewInformation currentInfo = this.getCompleteInformation(user, timeMetric, completeCycles.get(index), timeline, issue);
            result.add(this.getPastCompleteCycleSummary(user, currentInfo));
        }
        return result;
    }

    private CompleteGoalViewData getPastCompleteCycleSummary(ApplicationUser user, GoalCycleViewInformation currentInfo) {
        CompleteGoalViewData content = new CompleteGoalViewData();
        content.failed = currentInfo.failed;
        content.remainingTimeLong = this.formatter.getLongFormattedRemainingDuration(currentInfo.remainingTime, user);
        content.goalTimeLong = this.formatter.getLongFormattedGoalDuration(currentInfo.goalTime, user);
        DateTimeFormatter dateTimeFormatter = this.dateTimeFormatter.forUser(user).withStyle(DateTimeStyle.RELATIVE);
        content.startTime = dateTimeFormatter.format(currentInfo.startTime.toDate());
        content.stopTime = dateTimeFormatter.format(currentInfo.stopTime.toDate());
        return content;
    }

    @Override
    public Option<GoalSummaryViewData> getGoalSummaryView(ApplicationUser user, Issue issue, CustomField slaCustomField) {
        Option<TimeMetric> timeMetricOpt = this.getTimeMetric(user, issue, slaCustomField);
        if (timeMetricOpt.isEmpty()) {
            return Option.none();
        }
        TimeMetric timeMetric = (TimeMetric)((Object)timeMetricOpt.get());
        return this.getGoalSummaryView(user, issue, timeMetric);
    }

    @Override
    public Option<GoalSummaryViewData> getGoalSummaryView(ApplicationUser user, Issue issue, TimeMetric timeMetric) {
        io.atlassian.fugue.Either<ErrorCollection, SLAValue> fieldValue = this.slaFieldService.getFieldValue(user, issue, timeMetric);
        if (fieldValue.isLeft()) {
            return Option.none();
        }
        Option<GoalCycleViewInformation> infoResult = this.getLastCycleInfo(user, timeMetric, (SLAValue)fieldValue.right().get(), issue);
        if (infoResult.isEmpty()) {
            return Option.none();
        }
        GoalCycleViewInformation info = (GoalCycleViewInformation)infoResult.get();
        GoalSummaryViewData content = new GoalSummaryViewData();
        this.setBaseViewData(content, info);
        content.remainingTime = this.formatter.getShortFormattedRemainingDuration(info.remainingTime, user);
        return Option.some((Object)content);
    }

    private void setBaseViewData(GoalBaseViewData content, GoalCycleViewInformation info) {
        content.closed = info.closed;
        content.emergencyLevel = info.colorLevel;
        content.failed = info.failed;
        content.paused = info.paused;
        content.active = info.active;
    }

    private Option<GoalCycleViewInformation> getLastCycleInfo(ApplicationUser viewingUser, TimeMetric timeMetric, SLAValue value, Issue issue) {
        Option<GoalCycleViewInformation> ongoingInformation = this.getOngoingInformation(viewingUser, timeMetric, value);
        if (ongoingInformation.isDefined()) {
            return ongoingInformation;
        }
        Option<CompleteSLAData> lastCompletedCycle = value.getLastCompletedCycle();
        if (lastCompletedCycle.isDefined()) {
            return Option.some((Object)this.getCompleteInformation(viewingUser, timeMetric, (CompleteSLAData)lastCompletedCycle.get(), value.getTimeline(), issue));
        }
        return Option.none();
    }

    private GoalCycleViewInformation getCompleteInformation(ApplicationUser user, TimeMetric timeMetric, CompleteSLAData completeSLAData, Timeline timeline, Issue issue) {
        GoalCycleViewInformation info = new GoalCycleViewInformation();
        info.calendarName = completeSLAData.getCalendarName();
        info.metricName = timeMetric.getName();
        info.goalTime = completeSLAData.getGoalTime();
        info.startTime = completeSLAData.getStartTime();
        info.stopTime = completeSLAData.getStopTime();
        info.failed = !completeSLAData.isSucceeded();
        info.closed = true;
        if (this.featureManager.isEnabled(ServiceDeskFeatureFlags.SLA_IMPROVED_RENDERING)) {
            info.remainingTime = completeSLAData.getRemainingTime() != null ? completeSLAData.getRemainingTime() : completeSLAData.getGoalTime() - completeSLAData.getElapsedTime();
            info.remainingTimeInDaysAndMillis = completeSLAData.getRemainingTimeInDaysAndMillis() != null ? completeSLAData.getRemainingTimeInDaysAndMillis() : (Map)this.goalCalculationService.getRemainingTimeInDaysAndMillisForCompletedGoal(timeline, timeMetric, issue, info.startTime, info.stopTime, info.remainingTime).get();
        } else {
            info.remainingTime = completeSLAData.getGoalTime() - completeSLAData.getElapsedTime();
        }
        Option<GoalColor> color = this.goalColorService.computeGoalColor(completeSLAData);
        if (color.isDefined()) {
            info.colorLevel = ((GoalColor)((Object)color.get())).getLevel();
        }
        return info;
    }

    private String formatCondition(ApplicationUser user, Set<TimeMetricHitConditionInfo> infos) {
        StringBuilder sb = new StringBuilder();
        for (TimeMetricHitConditionInfo info : infos) {
            if (!info.isComplete()) continue;
            if (sb.length() != 0) {
                sb.append(" / ");
            }
            sb.append(((TimeMetricHitCondition)info.getCondition()).getName(this.i18nFactory.getInstance(user)));
        }
        return sb.toString();
    }

    private Option<GoalCycleViewInformation> getOngoingInformation(ApplicationUser user, TimeMetric timeMetric, SLAValue value) {
        OngoingSLAData ongoingSLAData = value.getOngoingSLAData();
        if (ongoingSLAData == null) {
            return Option.none();
        }
        io.atlassian.fugue.Either<ErrorCollection, com.atlassian.servicedesk.internal.sla.configuration.goal.Goal> goal = this.goalService.getGoal(user, timeMetric, ongoingSLAData.getGoalId());
        if (goal.isLeft()) {
            return Option.none();
        }
        CalendarReference calendarReference = this.calendarReferenceManager.getReferenceForGoal((Goal)goal.right().get());
        DateTime now = new DateTime();
        Option<OngoingGoalStatus> ongoingGoalStatus = this.goalCalculationService.getOngoingGoalStatus((com.atlassian.servicedesk.internal.sla.configuration.goal.Goal)((Object)goal.right().get()), value, now);
        if (ongoingGoalStatus.isEmpty()) {
            return Option.none();
        }
        OngoingGoalStatus status = (OngoingGoalStatus)ongoingGoalStatus.get();
        Option<GoalColor> color = this.goalColorService.computeGoalColor(status);
        I18nHelper i18n = this.i18nFactory.getInstance(user);
        GoalCycleViewInformation info = new GoalCycleViewInformation();
        if (color.isDefined()) {
            info.colorLevel = ((GoalColor)((Object)color.get())).getLevel();
        }
        info.goalTime = status.getTargetTime();
        info.goalJql = status.getGoalJql();
        info.remainingTime = status.getRemainingTime();
        info.failed = status.hasFailed();
        info.closed = false;
        info.metricName = timeMetric.getName();
        info.paused = status.isPaused();
        info.active = status.isActive();
        info.calendarName = calendarReference.getName(i18n);
        info.startTime = status.getStartDate();
        info.stopTime = now;
        info.remainingTimeInDaysAndMillis = status.getRemainingTimeInDaysAndMillis();
        return Option.some((Object)info);
    }

    private Option<TimeMetric> getTimeMetric(ApplicationUser viewingUser, Issue issue, CustomField slaCustomField) {
        io.atlassian.fugue.Either serviceDeskResponse = StepsConverters.newerEither((Either)this.serviceDeskService.getServiceDeskForProject(viewingUser, issue.getProjectObject()));
        if (serviceDeskResponse.isLeft()) {
            return Option.none();
        }
        ServiceDesk sd = (ServiceDesk)serviceDeskResponse.right().get();
        return this.timeMetricService.getTimeMetric(viewingUser, sd, slaCustomField).right().toOption();
    }

    private class GoalRemainingTimeComparator
    implements Comparator<GoalDetailedViewData> {
        private GoalRemainingTimeComparator() {
        }

        @Override
        public int compare(GoalDetailedViewData o1, GoalDetailedViewData o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            if (!o1.isClosed() && o2.isClosed()) {
                return -1;
            }
            if (o1.isClosed() && !o2.isClosed()) {
                return 1;
            }
            return Longs.compare((long)o1.getRemainingTimeInMilliseconds(), (long)o2.getRemainingTimeInMilliseconds());
        }
    }

    static class GoalCycleViewInformation {
        public String calendarName;
        public long goalTime;
        public String goalJql;
        public long remainingTime;
        public Map<TimeMetricMeasureType, Long> remainingTimeInDaysAndMillis;
        public String colorLevel;
        public boolean closed;
        public String metricName;
        public boolean failed;
        public boolean paused;
        public boolean active;
        public DateTime startTime;
        public DateTime stopTime;

        GoalCycleViewInformation() {
        }
    }
}

