/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.goal;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.jql.parser.JqlParseException;
import com.atlassian.jira.jql.parser.JqlQueryParser;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.query.Query;
import com.atlassian.query.clause.Clause;
import com.atlassian.servicedesk.internal.sla.configuration.goal.Goal;
import com.atlassian.servicedesk.internal.sla.configuration.goal.GoalManager;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetric;
import com.atlassian.servicedesk.internal.sla.goal.GoalMatcher;
import com.atlassian.servicedesk.internal.sla.goal.IssueIndexingContext;
import com.atlassian.servicedesk.internal.util.IssueIndexingHelper;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GoalMatcherImpl
implements GoalMatcher {
    protected final Log log = Log.with(this.getClass());
    @Autowired
    private GoalManager goalManager;
    @Autowired
    private SearchProvider searchProvider;
    @Autowired
    private JqlQueryParser jqlQueryParser;
    @Autowired
    private IssueIndexManager issueIndexManager;

    @Override
    public Goal getMatchingGoal(Issue issue, TimeMetric timeMetric, IssueIndexingContext issueIndexingContext) {
        List<Goal> goals = this.goalManager.getAllByTimeMetric(timeMetric);
        for (Goal goal : goals) {
            if (!this.isMatching(issue, goal, issueIndexingContext)) continue;
            return goal;
        }
        return goals.get(goals.size() - 1);
    }

    private boolean isMatching(Issue issue, Goal goal, IssueIndexingContext issueIndexingContext) {
        if (goal.isDefaultGoal()) {
            return true;
        }
        String jqlQuery = StringUtils.defaultString((String)goal.getJqlQuery()).trim();
        if (jqlQuery.isEmpty()) {
            return true;
        }
        Query matchingQuery = this.getMatchingQuery(issue, jqlQuery);
        if (matchingQuery == null) {
            return false;
        }
        if (issueIndexingContext.isIndexingRequired()) {
            IssueIndexingHelper.reindexIssue(issue, this.issueIndexManager);
            issueIndexingContext.issueIndexed();
        }
        try {
            long count = this.searchProvider.searchCountOverrideSecurity(matchingQuery, (ApplicationUser)null);
            return count == 1L;
        }
        catch (SearchException e) {
            this.log.error("Error while trying to match goal - '%s' : %s", new Object[]{goal.getJqlQuery(), e.getMessage()});
            this.log.exception((Throwable)e);
            return false;
        }
    }

    private Query getMatchingQuery(Issue issue, String query) {
        JqlQueryBuilder builder = JqlQueryBuilder.newBuilder();
        try {
            Clause goalClause = this.jqlQueryParser.parseQuery(query).getWhereClause();
            JqlClauseBuilder jqlClauseBuilder = builder.where().issue().eq(issue.getId());
            if (goalClause != null) {
                jqlClauseBuilder.and().addClause(goalClause);
            }
            return builder.buildQuery();
        }
        catch (JqlParseException e) {
            this.log.warn("Invalid JQL query definition in goal - '%s'", new Object[]{query});
            return null;
        }
    }
}

