/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.goal;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.plugins.workinghours.api.calculator.WorkingHoursCalculator;
import com.atlassian.servicedesk.internal.api.featureflag.ServiceDeskFeatureFlags;
import com.atlassian.servicedesk.internal.api.sla.configuration.calendar.CalendarReferenceManager;
import com.atlassian.servicedesk.internal.api.sla.goal.Goal;
import com.atlassian.servicedesk.internal.api.sla.metric.TimeMetricMeasureType;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetric;
import com.atlassian.servicedesk.internal.sla.goal.GoalCalculationService;
import com.atlassian.servicedesk.internal.sla.goal.GoalMatcher;
import com.atlassian.servicedesk.internal.sla.goal.IssueIndexingContext;
import com.atlassian.servicedesk.internal.sla.goal.OngoingGoalStatus;
import com.atlassian.servicedesk.internal.sla.metric.DateTimeRange;
import com.atlassian.servicedesk.internal.sla.metric.TimeMetricCalculationService;
import com.atlassian.servicedesk.internal.sla.model.OngoingSLAData;
import com.atlassian.servicedesk.internal.sla.model.SLAValue;
import com.atlassian.servicedesk.internal.sla.model.Timeline;
import io.atlassian.fugue.Option;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GoalCalculationServiceImpl
implements GoalCalculationService {
    @Autowired
    private CalendarReferenceManager calendarReferenceManager;
    @Autowired
    private TimeMetricCalculationService timeMetricCalculationService;
    @Autowired
    private FeatureManager featureManager;
    @Autowired
    private GoalMatcher goalMatcher;

    @Override
    public Option<OngoingGoalStatus> getOngoingGoalStatus(com.atlassian.servicedesk.internal.sla.configuration.goal.Goal goal, SLAValue value, DateTime now) {
        if (value.getOngoingSLAData() == null) {
            return Option.none();
        }
        OngoingSLAData ongoingSLAData = value.getOngoingSLAData();
        if (!goal.hasDuration()) {
            return Option.none();
        }
        WorkingHoursCalculator calculator = this.calendarReferenceManager.getCalculatorForGoal((Goal)goal);
        DateTimeRange dateTimeRange = new DateTimeRange(ongoingSLAData.getStartTime(), now);
        long elapsedTime = this.timeMetricCalculationService.getElapsedTime(value.getTimeline(), calculator, dateTimeRange);
        boolean active = calculator.isActive(dateTimeRange.getStop());
        long remainingTime = goal.getDuration() - elapsedTime;
        Option<DateTime> breachedDate = this.getOngoingBreachedDate(value.getTimeline(), calculator, remainingTime, ongoingSLAData, dateTimeRange.getStop(), true);
        Option<Map<TimeMetricMeasureType, Long>> remainingTimeInDaysAndMillis = Option.none();
        if (this.featureManager.isEnabled(ServiceDeskFeatureFlags.SLA_IMPROVED_RENDERING)) {
            remainingTimeInDaysAndMillis = this.getRemainingTimeInDaysAndMillis(value.getTimeline(), calculator, breachedDate, now);
        }
        OngoingGoalStatus status = new OngoingGoalStatus();
        status.setGoalId(goal.getId());
        status.setGoalJql(StringUtils.defaultString((String)goal.getJqlQuery()).trim());
        status.setStartDate(ongoingSLAData.getStartTime());
        status.setTargetTime(goal.getDuration());
        status.setPaused(ongoingSLAData.isPaused());
        status.setActive(active);
        status.setElapsedTime(elapsedTime);
        status.setRemainingTime(remainingTime);
        status.setRemainingTimeInDaysAndMillis((Map)remainingTimeInDaysAndMillis.getOrNull());
        status.setBreached(elapsedTime > goal.getDuration());
        status.setBreachedDate((DateTime)breachedDate.getOrNull());
        return Option.some((Object)status);
    }

    @Override
    public Option<Long> getRemainingTime(Timeline timeline, com.atlassian.servicedesk.internal.sla.configuration.goal.Goal goal, DateTime startTime, DateTime now) {
        if (!goal.hasDuration()) {
            return Option.none();
        }
        long remainingTime = this.calculateRemainingTime(timeline, goal, startTime, now);
        return Option.some((Object)remainingTime);
    }

    @Override
    public Option<Map<TimeMetricMeasureType, Long>> getRemainingTimeInDaysAndMillisForCompletedGoal(Timeline timeline, TimeMetric timeMetric, Issue issue, DateTime startDate, DateTime endDate, long remaining) {
        com.atlassian.servicedesk.internal.sla.configuration.goal.Goal goal = this.goalMatcher.getMatchingGoal(issue, timeMetric, IssueIndexingContext.noIndexing());
        WorkingHoursCalculator calculator = this.calendarReferenceManager.getCalculatorForGoal((Goal)goal);
        Option<DateTime> expectedEndDate = this.timeMetricCalculationService.getGoalThresholdExceededDate(timeline, calculator, remaining, 0L, startDate, endDate);
        return this.getRemainingTimeInDaysAndMillis(timeline, calculator, expectedEndDate, endDate);
    }

    @Override
    public Option<DateTime> getThresholdExceededDate(Timeline timeline, WorkingHoursCalculator calculator, long remainingTime, long thresholdDuration, OngoingSLAData ongoingSLAData, DateTime now, boolean calculateDuringPause) {
        if (!calculateDuringPause && ongoingSLAData.isPaused()) {
            return Option.none();
        }
        return this.timeMetricCalculationService.getGoalThresholdExceededDate(timeline, calculator, remainingTime, thresholdDuration, ongoingSLAData.getStartTime(), now);
    }

    @Override
    public Option<DateTime> getOngoingBreachedDate(Timeline timeline, WorkingHoursCalculator calculator, long remainingTime, OngoingSLAData ongoingSlaData, DateTime now, boolean calculateDuringPause) {
        return this.getThresholdExceededDate(timeline, calculator, remainingTime, Duration.ZERO.getMillis(), ongoingSlaData, now, calculateDuringPause);
    }

    private long calculateRemainingTime(Timeline timeline, com.atlassian.servicedesk.internal.sla.configuration.goal.Goal goal, DateTime startTime, DateTime now) {
        long remainingTime = goal.getDuration();
        DateTimeRange dateTimeRange = new DateTimeRange(startTime, now);
        if (!startTime.isEqual((ReadableInstant)now)) {
            remainingTime -= this.timeMetricCalculationService.getElapsedTime(timeline, this.calendarReferenceManager.getCalculatorForGoal((Goal)goal), dateTimeRange);
        }
        return remainingTime;
    }

    private Option<Map<TimeMetricMeasureType, Long>> getRemainingTimeInDaysAndMillis(Timeline timeline, WorkingHoursCalculator calculator, Option<DateTime> breachedDate, DateTime now) {
        if (breachedDate.isEmpty()) {
            return Option.none();
        }
        Map<TimeMetricMeasureType, Long> elapsedTimeInDays = this.timeMetricCalculationService.getRemainingTimeInDaysAndMillis(timeline, calculator, now, (DateTime)breachedDate.get());
        return Option.some(elapsedTimeInDays);
    }
}

