/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.data;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.util.Longs;
import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.sla.event.SLAChangeEvent;
import com.atlassian.servicedesk.internal.api.ServiceDeskManager;
import com.atlassian.servicedesk.internal.api.events.ChangeItemBeanUtils;
import com.atlassian.servicedesk.internal.api.project.InternalServiceDeskProjectManager;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetric;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetricManager;
import com.atlassian.servicedesk.internal.sla.customfield.SLAFieldManager;
import com.atlassian.servicedesk.internal.sla.customfield.SLAValueSerializer;
import com.atlassian.servicedesk.internal.sla.customfield.SlaFieldUpdateLockManager;
import com.atlassian.servicedesk.internal.sla.data.SlaDataManager;
import com.atlassian.servicedesk.internal.sla.goal.IssueIndexingContext;
import com.atlassian.servicedesk.internal.sla.goal.SlaThresholdDataManager;
import com.atlassian.servicedesk.internal.sla.goal.SlaUpdateManager;
import com.atlassian.servicedesk.internal.sla.listener.SlaUpdateResults;
import com.atlassian.servicedesk.internal.sla.listener.SlaValueUpdateContext;
import com.atlassian.servicedesk.internal.sla.metric.MetricStateEventExtractor;
import com.atlassian.servicedesk.internal.sla.model.OngoingSLAData;
import com.atlassian.servicedesk.internal.sla.model.SLAValue;
import com.atlassian.servicedesk.internal.sla.model.Timeline;
import com.atlassian.servicedesk.internal.sla.model.TimelineEvent;
import com.atlassian.servicedesk.internal.sla.threshold.SlaThresholdEventManager;
import com.atlassian.servicedesk.internal.sla.threshold.SlaThresholdUpdateContext;
import com.atlassian.servicedesk.internal.timedpromise.TimedPromiseHelper;
import com.atlassian.servicedesk.internal.timedpromise.TimedPromiseSlaScheduleOrigin;
import com.atlassian.servicedesk.internal.util.IssueIndexingHelper;
import com.atlassian.servicedesk.internal.utils.context.SLAThresholdContext;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Unit;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SlaDataManagerImpl
implements SlaDataManager {
    private static final Log logger = Log.with(SlaDataManagerImpl.class);
    private static final DateTime CLEARED_DATETIME = new DateTime(-1L);
    private static final SLAValueSerializer slaValueSerializer = new SLAValueSerializer();
    private final TimeMetricManager timeMetricManager;
    private final SlaThresholdEventManager slaThresholdEventManager;
    private final IssueIndexManager issueIndexManager;
    private final SLAFieldManager slaFieldManager;
    private final MetricStateEventExtractor metricStateEventExtractor;
    private final SlaUpdateManager slaUpdateManager;
    private final SlaThresholdDataManager slaThresholdDataManager;
    private final SLAThresholdContext slaThresholdContext;
    private final TimedPromiseHelper timedPromiseHelper;
    private final ChangeItemBeanUtils changeItemBeanUtils;
    private final ServiceDeskManager serviceDeskManager;
    private final InternalServiceDeskProjectManager internalServiceDeskProjectManager;
    private final SlaFieldUpdateLockManager slaFieldUpdateLockManager;

    @Autowired
    public SlaDataManagerImpl(TimeMetricManager timeMetricManager, SlaThresholdEventManager slaThresholdEventManager, IssueIndexManager issueIndexManager, SLAFieldManager slaFieldManager, MetricStateEventExtractor metricStateEventExtractor, SlaUpdateManager slaUpdateManager, SlaThresholdDataManager slaThresholdDataManager, SLAThresholdContext slaThresholdContext, TimedPromiseHelper timedPromiseHelper, ChangeItemBeanUtils changeItemBeanUtils, ServiceDeskManager serviceDeskManager, InternalServiceDeskProjectManager internalServiceDeskProjectManager, SlaFieldUpdateLockManager slaFieldUpdateLockManager) {
        this.timeMetricManager = timeMetricManager;
        this.slaThresholdEventManager = slaThresholdEventManager;
        this.issueIndexManager = issueIndexManager;
        this.slaFieldManager = slaFieldManager;
        this.metricStateEventExtractor = metricStateEventExtractor;
        this.slaUpdateManager = slaUpdateManager;
        this.slaThresholdDataManager = slaThresholdDataManager;
        this.slaThresholdContext = slaThresholdContext;
        this.timedPromiseHelper = timedPromiseHelper;
        this.changeItemBeanUtils = changeItemBeanUtils;
        this.serviceDeskManager = serviceDeskManager;
        this.internalServiceDeskProjectManager = internalServiceDeskProjectManager;
        this.slaFieldUpdateLockManager = slaFieldUpdateLockManager;
    }

    @Override
    public void processSlasFromIssueEvent(SLAChangeEvent event, ServiceDesk serviceDesk) {
        boolean inSLAThresholdContext = this.slaThresholdContext.isInSLAThresholdContext();
        DateTime nowDate = this.getNowDate((Option<SLAChangeEvent>)Option.some((Object)event));
        SlaThresholdUpdateContext data = this.processSlaDataUpdate(event.getIssue(), serviceDesk, event, new ProcessSlaData(inSLAThresholdContext, nowDate));
        if (!inSLAThresholdContext) {
            this.slaThresholdEventManager.fireExceededSlaThresholdsEvent(data, nowDate);
            this.slaThresholdEventManager.scheduleNextExceedingSlaThresholdTimedPromise(data, TimedPromiseSlaScheduleOrigin.ISSUE_EVENT);
        }
    }

    @Override
    public boolean processFromSlaChangeEventIfProjectMoved(SLAChangeEvent event) {
        Optional<ChangeItemBean> changeItemBean = event.getChangeItemForField("project").filter(changeItemBean1 -> this.changeItemBeanUtils.isChangeToAnotherValue(changeItemBean1, event.getIssue()));
        if (!changeItemBean.isPresent()) {
            return false;
        }
        Steps.begin(changeItemBean.map(ChangeItemBean::getFrom)).then(idString -> Optional.ofNullable(Longs.toLong((String)idString).orNull())).then((idString, id) -> this.internalServiceDeskProjectManager.getProject(id).toOptional()).then((idString, id, project) -> this.serviceDeskManager.getServiceDeskForProject(project).toOptional()).yield((idString, id, project, serviceDesk) -> {
            Issue issue = event.getIssue();
            this.processSlaIssueFromMoveEvent(issue, (ServiceDesk)serviceDesk, event);
            this.timedPromiseHelper.unscheduleSlaThresholdEventTimedPromise(issue, "SLA Threshold Events - unscheduled timed promise for issue " + issue.getKey() + ", as issue has been moved from project " + project.getKey() + " to " + event.getProject().getKey());
            return Unit.Unit();
        });
        return true;
    }

    @Override
    public Option<DateTime> processSlasFromTimedPromiseAndGetRescheduleTime(Issue issue, ServiceDesk serviceDesk) {
        return (Option)this.slaThresholdContext.inSLAThresholdContext(input -> {
            DateTime nowDate = this.getNowDate((Option<SLAChangeEvent>)Option.none());
            SlaThresholdUpdateContext data = this.processSlaThresholdUpdates(issue, serviceDesk, nowDate);
            this.slaThresholdEventManager.fireExceededSlaThresholdsEvent(data, nowDate);
            return this.slaThresholdEventManager.extractEarliestNextExceedingSlaThresholdTime(data);
        }, Collections.emptyMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SlaThresholdUpdateContext processSlaDataUpdate(Issue issue, ServiceDesk serviceDesk, SLAChangeEvent event, ProcessSlaData processSlaData) {
        IssueIndexingContext issueIndexingContext = IssueIndexingContext.indexingRequired();
        List<TimeMetric> timeMetrics = this.timeMetricManager.getTimeMetrics(serviceDesk);
        SlaThresholdUpdateContext slaThresholdUpdateContext = new SlaThresholdUpdateContext(issue);
        SlaUpdateResults slaUpdateResults = new SlaUpdateResults();
        for (TimeMetric timeMetric : timeMetrics) {
            this.slaFieldUpdateLockManager.lockSlaUpdate(issue, timeMetric);
            try {
                Option<TimelineEvent> timelineEventResult;
                SLAValue currentValue = this.getCurrentSlaValue(timeMetric, issue, (Option<SLAChangeEvent>)Option.some((Object)event));
                SLAValue newValue = this.prepareNewValue(timeMetric, issue, currentValue);
                SlaValueUpdateContext slaValueUpdateContext = new SlaValueUpdateContext();
                if (currentValue.getMetricId() == null) {
                    slaValueUpdateContext.setFieldUpdatedRequired();
                }
                if ((timelineEventResult = this.getTimelineEvent(timeMetric, event, newValue)).isDefined()) {
                    newValue = this.updateTimeline(newValue, (TimelineEvent)timelineEventResult.get());
                    slaValueUpdateContext.setFieldUpdatedRequired();
                }
                newValue = this.processSlaUpdate(timeMetric, issue, newValue, timelineEventResult, slaValueUpdateContext, issueIndexingContext);
                if (!processSlaData.isInSlaThresholdContext()) {
                    newValue = this.updateThresholdData(timeMetric, newValue, processSlaData.getNowDate());
                    this.slaThresholdEventManager.calculateExceededSlaThresholds(timeMetric, currentValue, newValue, slaThresholdUpdateContext);
                    this.slaThresholdEventManager.calculateNextExceedingSlaThresholdTime(timeMetric, newValue, processSlaData.getNowDate(), slaThresholdUpdateContext);
                    if (this.slaThresholdEventManager.hasRemainingTimePassedThresholds(slaThresholdUpdateContext)) {
                        slaValueUpdateContext.setFieldUpdatedRequired();
                    }
                }
                if (slaValueUpdateContext.isRequiresFieldUpdate()) {
                    this.writeSlaValueData(timeMetric, issue, newValue);
                }
                slaUpdateResults.addUpdate(slaValueUpdateContext);
            }
            finally {
                this.slaFieldUpdateLockManager.unlockSlaUpdate(issue, timeMetric);
            }
        }
        if (slaUpdateResults.requiresReindex()) {
            IssueIndexingHelper.reindexIssue(issue, this.issueIndexManager);
        }
        return slaThresholdUpdateContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SlaThresholdUpdateContext processSlaThresholdUpdates(Issue issue, ServiceDesk serviceDesk, DateTime nowDate) {
        List<TimeMetric> timeMetrics = this.timeMetricManager.getTimeMetrics(serviceDesk);
        SlaThresholdUpdateContext slaThresholdUpdateContext = new SlaThresholdUpdateContext(issue);
        if (timeMetrics.isEmpty()) {
            return slaThresholdUpdateContext;
        }
        for (TimeMetric timeMetric : timeMetrics) {
            this.slaFieldUpdateLockManager.lockSlaUpdate(issue, timeMetric);
            try {
                SLAValue currentValue = this.getCurrentSlaValue(timeMetric, issue, (Option<SLAChangeEvent>)Option.none());
                SLAValue newValue = this.prepareNewValue(timeMetric, issue, currentValue);
                newValue = this.updateThresholdData(timeMetric, newValue, nowDate);
                this.writeSlaValueData(timeMetric, issue, newValue);
                this.slaThresholdEventManager.calculateExceededSlaThresholds(timeMetric, currentValue, newValue, slaThresholdUpdateContext);
                this.slaThresholdEventManager.calculateNextExceedingSlaThresholdTime(timeMetric, newValue, nowDate, slaThresholdUpdateContext);
            }
            finally {
                this.slaFieldUpdateLockManager.unlockSlaUpdate(issue, timeMetric);
            }
        }
        IssueIndexingHelper.reindexIssue(issue, this.issueIndexManager);
        return slaThresholdUpdateContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSlaIssueFromMoveEvent(Issue issue, ServiceDesk serviceDesk, SLAChangeEvent event) {
        List<TimeMetric> timeMetrics = this.timeMetricManager.getTimeMetrics(serviceDesk);
        if (timeMetrics.isEmpty()) {
            return;
        }
        for (TimeMetric timeMetric : timeMetrics) {
            this.slaFieldUpdateLockManager.lockSlaUpdate(issue, timeMetric);
            try {
                SLAValue newValue = SLAValue.builder(this.getCurrentSlaValue(timeMetric, issue, (Option<SLAChangeEvent>)Option.some((Object)event))).setDefinitionChangeMsEpoch(CLEARED_DATETIME.getMillis()).setDefinitionChangeDate(CLEARED_DATETIME).setGoalsChangeMsEpoch(CLEARED_DATETIME.getMillis()).setGoalsChangeDate(CLEARED_DATETIME).setGoalTimeUpdatedMsEpoch(CLEARED_DATETIME.getMillis()).setGoalTimeUpdatedDate(CLEARED_DATETIME).clearOngoingSLAData().build();
                this.writeSlaValueData(timeMetric, issue, newValue);
            }
            finally {
                this.slaFieldUpdateLockManager.unlockSlaUpdate(issue, timeMetric);
            }
        }
        IssueIndexingHelper.reindexIssue(issue, this.issueIndexManager);
    }

    private SLAValue getCurrentSlaValue(TimeMetric timeMetric, Issue issue, Option<SLAChangeEvent> event) {
        SLAValue currentValue = this.slaFieldManager.getFieldValue(issue, timeMetric);
        if (event.exists(SLAChangeEvent::isIssueCreatedEvent) && !currentValue.isEmpty()) {
            logger.debug("Detected non-empty SLA value at issue creation time. This most likely is due to a issue clone action.", new Object[0]);
            logger.debug("Issue %s has SLA customfield %d containing a non empty value '%s'", new Object[]{issue.getKey(), timeMetric.getCustomFieldId(), slaValueSerializer.serialize(currentValue)});
            currentValue = new SLAValue();
        }
        return currentValue;
    }

    private SLAValue prepareNewValue(TimeMetric timeMetric, Issue issue, SLAValue currentValue) {
        Timestamp created;
        SLAValue.Builder newValue = SLAValue.builder(currentValue);
        if (newValue.getMetricId() == null && (created = issue.getCreated()) != null) {
            boolean afterMetricUpdate;
            boolean bl = afterMetricUpdate = timeMetric.getDefinitionChangeMsEpoch() != null && timeMetric.getDefinitionChangeMsEpoch() < created.getTime();
            if (afterMetricUpdate) {
                newValue.setMetricId(timeMetric.getId()).setMetricCreatedDate(timeMetric.getCreatedDate()).setDefinitionChangeDate(timeMetric.getDefinitionChangeDate()).setDefinitionChangeMsEpoch(timeMetric.getDefinitionChangeMsEpoch());
            }
        }
        return newValue.build();
    }

    private Option<TimelineEvent> getTimelineEvent(TimeMetric timeMetric, SLAChangeEvent event, SLAValue newValue) {
        return this.metricStateEventExtractor.getTimelineEvent(timeMetric, event, newValue.getTimeline());
    }

    private SLAValue updateTimeline(SLAValue newValue, TimelineEvent timelineEvent) {
        SLAValue.Builder updatingValue = SLAValue.builder(newValue);
        Timeline newTimeline = this.metricStateEventExtractor.updateTimeline(newValue.getTimeline(), timelineEvent);
        updatingValue.timeline(newTimeline);
        return updatingValue.build();
    }

    private SLAValue processSlaUpdate(TimeMetric timeMetric, Issue issue, SLAValue newValue, Option<TimelineEvent> timelineEventResult, SlaValueUpdateContext slaValueUpdateContext, IssueIndexingContext issueIndexingContext) {
        SLAValue.Builder updatingValue = SLAValue.builder(newValue);
        boolean isSlaUpdated = this.slaUpdateManager.updateSla(timeMetric, issue, timelineEventResult, updatingValue, issueIndexingContext);
        if (isSlaUpdated) {
            slaValueUpdateContext.setFieldUpdatedRequired();
        }
        return updatingValue.build();
    }

    private void writeSlaValueData(TimeMetric timeMetric, Issue issue, SLAValue newValue) {
        this.slaFieldManager.setFieldValue(timeMetric, issue, newValue);
    }

    private SLAValue updateThresholdData(TimeMetric timeMetric, SLAValue newValue, DateTime nowDate) {
        Option<OngoingSLAData> ongoingSLAData;
        SLAValue.Builder updatingValue = SLAValue.builder(newValue);
        if (newValue.getOngoingSLAData() != null && (ongoingSLAData = this.slaThresholdDataManager.updateThresholdData(timeMetric, newValue.getTimeline(), newValue.getOngoingSLAData(), nowDate)).isDefined()) {
            updatingValue.ongoingSLAData((OngoingSLAData)ongoingSLAData.get());
        }
        return updatingValue.build();
    }

    private DateTime getNowDate(Option<SLAChangeEvent> eventOpt) {
        return (DateTime)eventOpt.fold(DateTime::now, event -> new DateTime((Object)event.getTime()));
    }

    private static class ProcessSlaData {
        private final boolean inSlaThresholdContext;
        private final DateTime nowDate;

        ProcessSlaData(boolean inSlaThresholdContext, DateTime nowDate) {
            this.inSlaThresholdContext = inSlaThresholdContext;
            this.nowDate = nowDate;
        }

        boolean isInSlaThresholdContext() {
            return this.inSlaThresholdContext;
        }

        DateTime getNowDate() {
            return this.nowDate;
        }
    }
}

