/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.customfield;

import com.atlassian.fugue.Either;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.pocketknife.api.util.ServiceResult;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.internal.api.sla.PermissionService;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetric;
import com.atlassian.servicedesk.internal.sla.customfield.SLAFieldManager;
import com.atlassian.servicedesk.internal.sla.customfield.SLAFieldService;
import com.atlassian.servicedesk.internal.sla.model.SLAValue;
import io.atlassian.fugue.Unit;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SLAFieldServiceImpl
implements SLAFieldService {
    @Autowired
    PermissionService permissionService;
    @Autowired
    SLAFieldManager slaFieldManager;

    @Override
    public boolean isProjectAdminFieldCreationEnabled() {
        return this.slaFieldManager.isProjectAdminFieldCreationEnabled();
    }

    @Override
    public io.atlassian.fugue.Either<ErrorCollection, Unit> setProjectAdminFieldCreationEnabled(ApplicationUser user, boolean enabled) {
        if (!this.permissionService.isJiraAdministrator(user)) {
            return StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.FORBIDDEN, (String)"sd.sla.field.service.permission.jira.admin", (Object[])new Object[0]));
        }
        this.slaFieldManager.setProjectAdminFieldCreationEnabled(enabled);
        return io.atlassian.fugue.Either.right((Object)Unit.Unit());
    }

    @Override
    public io.atlassian.fugue.Either<ErrorCollection, List<CustomField>> getAll(ApplicationUser user) {
        if (!this.permissionService.canBrowseSomeProject(user)) {
            return StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.FORBIDDEN, (String)"sd.sla.field.service.permission.error.fetch", (Object[])new Object[0]));
        }
        return io.atlassian.fugue.Either.right(this.slaFieldManager.getAll());
    }

    @Override
    public io.atlassian.fugue.Either<ErrorCollection, List<CustomField>> getAllUnusedFields(ApplicationUser user) {
        if (!this.permissionService.canBrowseSomeProject(user)) {
            return StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.FORBIDDEN, (String)"sd.sla.field.service.permission.error.fetch", (Object[])new Object[0]));
        }
        return io.atlassian.fugue.Either.right(this.slaFieldManager.getAllUnusedFields());
    }

    @Override
    public io.atlassian.fugue.Either<ErrorCollection, CustomField> getById(ApplicationUser user, long id) {
        if (!this.permissionService.canBrowseSomeProject(user)) {
            return StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.FORBIDDEN, (String)"sd.sla.field.service.permission.error.fetch", (Object[])new Object[0]));
        }
        return this.slaFieldManager.getById(id);
    }

    @Override
    public io.atlassian.fugue.Either<ErrorCollection, CustomField> getByName(ApplicationUser user, String name) {
        if (!this.permissionService.canBrowseSomeProject(user)) {
            return StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.FORBIDDEN, (String)"sd.sla.field.service.permission.error.fetch", (Object[])new Object[0]));
        }
        return this.slaFieldManager.getByName(name);
    }

    @Override
    public io.atlassian.fugue.Either<ErrorCollection, CustomField> createSLAField(ApplicationUser user, String name) {
        if (!this.canManageField(user)) {
            return StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.FORBIDDEN, (String)"sd.sla.field.service.permission.error.create", (Object[])new Object[0]));
        }
        return this.slaFieldManager.createSLAField(name);
    }

    @Override
    public io.atlassian.fugue.Either<ErrorCollection, Unit> deleteSLAField(ApplicationUser user, CustomField field) {
        if (!this.canManageField(user)) {
            return StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.FORBIDDEN, (String)"sd.sla.field.service.permission.error.delete", (Object[])new Object[0]));
        }
        return this.slaFieldManager.deleteSLAField(field);
    }

    @Override
    public io.atlassian.fugue.Either<ErrorCollection, Unit> deleteUnusedSLAFields(ApplicationUser user) {
        if (!this.canManageField(user)) {
            return StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.FORBIDDEN, (String)"sd.sla.field.service.permission.error.delete", (Object[])new Object[0]));
        }
        return this.slaFieldManager.deleteUnusedSLAFields();
    }

    @Override
    public SLAValue getFieldValue(ApplicationUser user, Issue issue, CustomField cf) {
        return this.slaFieldManager.getFieldValue(issue, cf);
    }

    @Override
    public io.atlassian.fugue.Either<ErrorCollection, SLAValue> getFieldValue(ApplicationUser user, Issue issue, TimeMetric timeMetric) {
        return io.atlassian.fugue.Either.right((Object)this.slaFieldManager.getFieldValue(issue, timeMetric));
    }

    @Override
    public boolean canManageField(ApplicationUser user) {
        if (this.isProjectAdminFieldCreationEnabled()) {
            return this.permissionService.canAdministerSomeProject(user) || this.permissionService.isJiraAdministrator(user);
        }
        return this.permissionService.isJiraAdministrator(user);
    }

    @Override
    public io.atlassian.fugue.Either<ErrorCollection, String> validateFieldName(String fieldName) {
        return this.slaFieldManager.validateFieldName(fieldName);
    }
}

