/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.customfield;

import com.atlassian.fugue.Either;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.impl.AbstractSingleFieldType;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.customfields.manager.GenericConfigManager;
import com.atlassian.jira.issue.customfields.persistence.CustomFieldValuePersister;
import com.atlassian.jira.issue.customfields.persistence.PersistenceFieldType;
import com.atlassian.jira.issue.export.FieldExportParts;
import com.atlassian.jira.issue.export.FieldExportPartsBuilder;
import com.atlassian.jira.issue.export.customfield.CustomFieldExportContext;
import com.atlassian.jira.issue.export.customfield.ExportableCustomFieldType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.rest.FieldJsonRepresentation;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfo;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfoContext;
import com.atlassian.jira.issue.fields.rest.RestAwareCustomFieldType;
import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.bean.BulkEditBean;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.ErrorBuilder;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.sla.info.SlaInformation;
import com.atlassian.servicedesk.api.sla.info.SlaInformationQuery;
import com.atlassian.servicedesk.api.sla.info.SlaInformationService;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.api.user.UncheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.bootstrap.lifecycle.ServiceDeskComponentAccessor;
import com.atlassian.servicedesk.internal.api.user.permission.ServiceDeskLicenseAndPermissionService;
import com.atlassian.servicedesk.internal.api.util.SoyTemplateRenderer;
import com.atlassian.servicedesk.internal.customfields.util.FieldJsonBuilderAccessor;
import com.atlassian.servicedesk.internal.featureflag.SDFeatureFlags;
import com.atlassian.servicedesk.internal.sla.customfield.SLAValueSerializer;
import com.atlassian.servicedesk.internal.sla.goal.view.GoalSummaryViewData;
import com.atlassian.servicedesk.internal.sla.goal.view.GoalViewService;
import com.atlassian.servicedesk.internal.sla.model.SLAValue;
import com.atlassian.servicedesk.internal.spi.jira.field.json.FieldJsonBuilderService;
import com.atlassian.servicedesk.internal.user.license.ServiceDeskUserLicenseService;
import io.atlassian.fugue.Option;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public class SLACFType
extends AbstractSingleFieldType<SLAValue>
implements RestAwareCustomFieldType,
ExportableCustomFieldType {
    private static final String JSON_SCHEMA_TYPE = "sd-servicelevelagreement";
    private static final String HAS_VALID_AGENT_LICENSE = "isAgent";
    private static final String GOAL_VIEW = "goalView";
    private static final String SOY_RENDERER = "soyRenderer";
    private static final String SOY_CONTEXT = "soyContext";
    private static final SLAValueSerializer serializer = new SLAValueSerializer();
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final GoalViewService goalViewService;
    private final SlaInformationService slaInformationService;
    private final FieldJsonBuilderAccessor fieldJsonBuilderAccessor;
    private final I18nHelper i18nHelper;
    private final FeatureManager featureManager;
    private final ServiceDeskLicenseAndPermissionService serviceDeskLicenseAndPermissionService;
    private final UserFactory userFactory;

    @Autowired
    public SLACFType(CustomFieldValuePersister customFieldValuePersister, GenericConfigManager genericConfigManager, SoyTemplateRenderer soyTemplateRenderer, GoalViewService goalViewService, SlaInformationService slaInformationService, FieldJsonBuilderAccessor fieldJsonBuilderAccessor, I18nHelper i18nHelper, FeatureManager featureManager, ServiceDeskLicenseAndPermissionService serviceDeskLicenseAndPermissionService, UserFactory userFactory) {
        super(customFieldValuePersister, genericConfigManager);
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.goalViewService = goalViewService;
        this.slaInformationService = slaInformationService;
        this.fieldJsonBuilderAccessor = fieldJsonBuilderAccessor;
        this.i18nHelper = i18nHelper;
        this.featureManager = featureManager;
        this.serviceDeskLicenseAndPermissionService = serviceDeskLicenseAndPermissionService;
        this.userFactory = userFactory;
    }

    @Nonnull
    protected PersistenceFieldType getDatabaseType() {
        return PersistenceFieldType.TYPE_UNLIMITED_TEXT;
    }

    protected Object getDbValueFromObject(SLAValue slaValue) {
        return serializer.serialize(slaValue);
    }

    public void updateValue(CustomField customField, Issue issue, SLAValue value) {
        if (value != null) {
            super.updateValue(customField, issue, (Object)value);
        }
    }

    public String availableForBulkEdit(BulkEditBean bulkEditBean) {
        return "bulk.edit.unavailable";
    }

    protected SLAValue getObjectFromDbValue(@Nonnull Object o) throws FieldValidationException {
        if (o instanceof String) {
            return serializer.unserialize((String)o);
        }
        return null;
    }

    public String getStringFromSingularObject(SLAValue slaValue) {
        return serializer.serialize(slaValue);
    }

    public SLAValue getSingularObjectFromString(String s) throws FieldValidationException {
        return serializer.unserialize(s);
    }

    @Nonnull
    public Map<String, Object> getVelocityParameters(Issue issue, CustomField field, FieldLayoutItem fieldLayoutItem) {
        GoalSummaryViewData goalViewData;
        boolean isAgent2;
        UncheckedUser user = this.userFactory.getUncheckedUser();
        ServiceDeskUserLicenseService sdUserLicenseService = ServiceDeskComponentAccessor.getServiceDeskUserLicenseService();
        Map values2 = super.getVelocityParameters(issue, field, fieldLayoutItem);
        HashMap<String, Object> soyContext = new HashMap<String, Object>();
        if (issue != null) {
            boolean isLegacyOrServiceDesk;
            if (this.featureManager.isEnabled(SDFeatureFlags.SLA_JQL_AGENT_SECURITY_RESTRICTED)) {
                if (ServiceDeskComponentAccessor.getServiceDeskInternalManager().hasServiceDesk(issue.getProjectObject(), false)) {
                    isAgent2 = this.serviceDeskLicenseAndPermissionService.canViewAgentView((SDUser)user, issue);
                    isLegacyOrServiceDesk = true;
                } else {
                    isAgent2 = sdUserLicenseService.hasValidAgentLicense((SDUser)user);
                    isLegacyOrServiceDesk = false;
                }
            } else {
                isAgent2 = sdUserLicenseService.hasValidAgentLicense((SDUser)user);
                isLegacyOrServiceDesk = true;
            }
            goalViewData = isAgent2 && isLegacyOrServiceDesk ? (GoalSummaryViewData)this.goalViewService.getGoalSummaryView(user.forJIRA(), issue, field).getOrNull() : null;
        } else {
            goalViewData = null;
            isAgent2 = sdUserLicenseService.hasValidAgentLicense((SDUser)user);
        }
        soyContext.put(HAS_VALID_AGENT_LICENSE, isAgent2);
        soyContext.put(GOAL_VIEW, goalViewData);
        values2.put(SOY_RENDERER, this.soyTemplateRenderer);
        values2.put(SOY_CONTEXT, soyContext);
        return values2;
    }

    public List<Object> getRawSlaFieldValue(CustomField customField, Issue issue) {
        return this.customFieldValuePersister.getValues(customField, issue.getId(), this.getDatabaseType());
    }

    public JsonType getJsonSchema(CustomField customField) {
        return JsonTypeBuilder.custom((String)JSON_SCHEMA_TYPE, (String)this.getKey(), (Long)customField.getIdAsLong());
    }

    public FieldTypeInfo getFieldTypeInfo(FieldTypeInfoContext fieldTypeInfoContext) {
        return new FieldTypeInfo(null, null);
    }

    public FieldJsonRepresentation getJsonFromIssue(CustomField field, Issue issue, boolean renderedVersionRequested, @Nullable FieldLayoutItem fieldLayoutItem) {
        Option rawValue = Option.option((Object)field.getValue(issue));
        if (rawValue.isEmpty()) {
            return this.fieldJsonBuilderAccessor.build(FieldJsonBuilderService::buildNullJson);
        }
        SlaInformationQuery query = this.slaInformationService.newInfoQueryBuilder().issue(issue.getId()).customField(field).build();
        ApplicationUser user = this.userFactory.getUncheckedUser().forJIRA();
        io.atlassian.fugue.Either slaInformation = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.slaInformationService.getInfo(user, query))).then(pr -> Option.fromOptional((Optional)pr.findFirst()).toRight(this::entityNotFound)).yield((pr, slaInfo) -> slaInfo);
        return this.fieldJsonBuilderAccessor.build(this.buildJson(issue, user, (io.atlassian.fugue.Either<AnError, SlaInformation>)slaInformation));
    }

    private Function<FieldJsonBuilderService, FieldJsonRepresentation> buildJson(Issue issue, ApplicationUser user, io.atlassian.fugue.Either<AnError, SlaInformation> slaInformation) {
        return fieldJsonService -> (FieldJsonRepresentation)slaInformation.fold(arg_0 -> ((FieldJsonBuilderService)fieldJsonService).buildErrorJson(arg_0), slaInfo -> fieldJsonService.buildSlaInformationJson(user, issue, slaInfo));
    }

    private AnError entityNotFound() {
        String text = this.i18nHelper.getText("sd.entity.not.found");
        return ErrorBuilder.errorBuilder().addError(text, "sd.entity.not.found").buildSingleError();
    }

    public String getChangelogValue(CustomField field, SLAValue value) {
        return null;
    }

    public FieldExportParts getRepresentationFromIssue(Issue issue, CustomFieldExportContext context) {
        return new FieldExportPartsBuilder().build();
    }
}

