/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.configuration.timemetric;

import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.pocketknife.api.querydsl.stream.CloseableIterable;
import com.atlassian.pocketknife.api.querydsl.stream.StreamingQueryFactory;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.internal.querydsl.mapping.Tables;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetric;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetricMapper;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetricQStore;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import io.atlassian.fugue.Option;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TimeMetricQStoreImpl
implements TimeMetricQStore {
    private final Timestamp EPOCH_TIME = new Timestamp(0L);
    private final DatabaseAccessor databaseAccessor;
    private final StreamingQueryFactory streamingQueryFactory;

    @Autowired
    public TimeMetricQStoreImpl(DatabaseAccessor databaseAccessor, StreamingQueryFactory streamingQueryFactory) {
        this.databaseAccessor = databaseAccessor;
        this.streamingQueryFactory = streamingQueryFactory;
    }

    @Override
    public CloseableIterable<Tuple> streamTimeMetricsForSlaThresholdsUpgradeTask(DatabaseConnection connection) {
        return this.streamingQueryFactory.stream(connection, () -> (SQLQuery)((SQLQuery)connection.select((Expression[])new Path[]{Tables.TIME_METRIC.ID}).from((Expression)Tables.TIME_METRIC)).where((Predicate)Tables.TIME_METRIC.THRESHOLDS_CONFIG_CHANGE_DATE.isNull().or((Predicate)Tables.TIME_METRIC.THRESHOLDS_CONFIG_CHANGE_DATE.eq((Object)this.EPOCH_TIME))));
    }

    @Override
    public Integer getServiceDeskIdForTimeMetric(TimeMetric timeMetric) {
        return (Integer)this.databaseAccessor.runInTransaction(conn -> (Integer)((SQLQuery)((SQLQuery)conn.select(Tables.TIME_METRIC.SERVICE_DESK_ID).from((Expression)Tables.TIME_METRIC)).where((Predicate)Tables.TIME_METRIC.ID.eq((Object)timeMetric.getId()))).fetchOne());
    }

    @Override
    public Option<TimeMetric> createTimeMetric(ServiceDesk serviceDesk, TimeMetric timeMetric) {
        return (Option)this.databaseAccessor.runInTransaction(conn -> this.createTimeMetric((DatabaseConnection)conn, serviceDesk, timeMetric).flatMap(id -> this.getTimeMetricWithConnection((DatabaseConnection)conn, serviceDesk, (int)id)));
    }

    private Option<Integer> createTimeMetric(DatabaseConnection connection, ServiceDesk serviceDesk, TimeMetric timeMetric) {
        Integer timeMetricId = (Integer)connection.insert((RelationalPath)Tables.TIME_METRIC).set((Path)Tables.TIME_METRIC.NAME, (Object)timeMetric.getName()).set(Tables.TIME_METRIC.CUSTOM_FIELD_ID, (Object)timeMetric.getCustomFieldId()).set(Tables.TIME_METRIC.DEFINITION_CHANGE_DATE, (Object)this.toTimestampOrDefault(timeMetric.getDefinitionChangeDate())).set(Tables.TIME_METRIC.DEFINITION_CHANGE_MS_EPOCH, (Object)timeMetric.getDefinitionChangeMsEpoch()).set(Tables.TIME_METRIC.GOALS_CHANGE_DATE, (Object)this.toTimestampOrDefault(timeMetric.getGoalsChangeDate())).set(Tables.TIME_METRIC.GOALS_CHANGE_MS_EPOCH, (Object)timeMetric.getGoalsChangeMsEpoch()).set(Tables.TIME_METRIC.THRESHOLDS_CONFIG_CHANGE_DATE, (Object)this.toTimestampOrDefault(timeMetric.getThresholdsConfigChangedDate())).set(Tables.TIME_METRIC.THRESHOLDS_CHANGE_MS_EPOCH, (Object)timeMetric.getThresholdsChangedMsEpoch()).set(Tables.TIME_METRIC.CREATED_DATE, (Object)timeMetric.getCreatedDate()).set(Tables.TIME_METRIC.SERVICE_DESK_ID, (Object)serviceDesk.getId()).executeWithKey(Tables.TIME_METRIC.ID);
        return Option.option((Object)timeMetricId);
    }

    @Override
    public Option<TimeMetric> getTimeMetric(ServiceDesk serviceDesk, int timeMetricId) {
        return (Option)this.databaseAccessor.runInTransaction(conn -> this.getTimeMetricWithConnection((DatabaseConnection)conn, serviceDesk, timeMetricId));
    }

    private Option<TimeMetric> getTimeMetricWithConnection(DatabaseConnection connection, ServiceDesk serviceDesk, int timeMetricId) {
        TimeMetric timeMetric = (TimeMetric)((Object)((SQLQuery)((SQLQuery)connection.select((Expression)new TimeMetricMapper()).from((Expression)Tables.TIME_METRIC)).where((Predicate)Tables.TIME_METRIC.SERVICE_DESK_ID.eq((Object)serviceDesk.getId()).and((Predicate)Tables.TIME_METRIC.ID.eq((Object)timeMetricId)))).fetchOne());
        return Option.option((Object)((Object)timeMetric));
    }

    @Override
    public List<TimeMetric> getTimeMetricsForServiceDesk(ServiceDesk serviceDesk) {
        return (List)this.databaseAccessor.runInTransaction(conn -> ((SQLQuery)((SQLQuery)conn.select((Expression)new TimeMetricMapper()).from((Expression)Tables.TIME_METRIC)).where((Predicate)Tables.TIME_METRIC.SERVICE_DESK_ID.eq((Object)serviceDesk.getId()))).fetch());
    }

    @Override
    public Option<TimeMetric> getTimeMetricByServiceDeskAndCustomField(ServiceDesk serviceDesk, CustomField customField) {
        TimeMetric timeMetric = (TimeMetric)((Object)this.databaseAccessor.run(conn -> (TimeMetric)((Object)((Object)((SQLQuery)((SQLQuery)conn.select((Expression)new TimeMetricMapper()).from((Expression)Tables.TIME_METRIC)).where((Predicate)Tables.TIME_METRIC.SERVICE_DESK_ID.eq((Object)serviceDesk.getId()).and((Predicate)Tables.TIME_METRIC.CUSTOM_FIELD_ID.eq((Object)customField.getIdAsLong())))).fetchFirst()))));
        return Option.option((Object)((Object)timeMetric));
    }

    @Override
    public List<TimeMetric> getAllTimeMetricByCustomFieldForServiceDesks(CustomField customField, Collection<ServiceDesk> serviceDesks) {
        Set serviceDeskIds = serviceDesks.stream().map(ServiceDesk::getId).collect(Collectors.toSet());
        return (List)this.databaseAccessor.run(conn -> ((SQLQuery)((SQLQuery)conn.select((Expression)new TimeMetricMapper()).from((Expression)Tables.TIME_METRIC)).where((Predicate)Tables.TIME_METRIC.SERVICE_DESK_ID.in((Collection)serviceDeskIds).and((Predicate)Tables.TIME_METRIC.CUSTOM_FIELD_ID.eq((Object)customField.getIdAsLong())))).fetch());
    }

    @Override
    public List<TimeMetric> getAll() {
        return (List)this.databaseAccessor.runInTransaction(conn -> ((SQLQuery)conn.select((Expression)new TimeMetricMapper()).from((Expression)Tables.TIME_METRIC)).fetch());
    }

    @Override
    public long getTotalNumberOfTimeMetrics() {
        return (Long)this.databaseAccessor.runInTransaction(conn -> ((SQLQuery)conn.select((Expression)new TimeMetricMapper()).from((Expression)Tables.TIME_METRIC)).fetchCount());
    }

    @Override
    public List<TimeMetric> getTimeMetricsByCustomField(CustomField customField) {
        return (List)this.databaseAccessor.runInTransaction(conn -> ((SQLQuery)((SQLQuery)conn.select((Expression)new TimeMetricMapper()).from((Expression)Tables.TIME_METRIC)).where((Predicate)Tables.TIME_METRIC.CUSTOM_FIELD_ID.eq((Object)customField.getIdAsLong()))).fetch());
    }

    @Override
    public Option<TimeMetric> updateTimeMetric(TimeMetric updatedTimeMetric) {
        if (updatedTimeMetric.getId() == null) {
            return Option.none();
        }
        return (Option)this.databaseAccessor.runInTransaction(conn -> {
            this.updateTimeMetric((DatabaseConnection)conn, updatedTimeMetric);
            return this.getTimeMetricById((DatabaseConnection)conn, updatedTimeMetric.getId());
        });
    }

    private void updateTimeMetric(DatabaseConnection connection, TimeMetric updatedTimeMetric) {
        long rowsUpdated = connection.update((RelationalPath)Tables.TIME_METRIC).where((Predicate)Tables.TIME_METRIC.ID.eq((Object)updatedTimeMetric.getId())).set((Path)Tables.TIME_METRIC.NAME, (Object)updatedTimeMetric.getName()).set(Tables.TIME_METRIC.CUSTOM_FIELD_ID, (Object)updatedTimeMetric.getCustomFieldId()).set(Tables.TIME_METRIC.DEFINITION_CHANGE_DATE, (Object)this.toTimestampOrDefault(updatedTimeMetric.getDefinitionChangeDate())).set(Tables.TIME_METRIC.DEFINITION_CHANGE_MS_EPOCH, (Object)updatedTimeMetric.getDefinitionChangeMsEpoch()).set(Tables.TIME_METRIC.GOALS_CHANGE_DATE, (Object)this.toTimestampOrDefault(updatedTimeMetric.getGoalsChangeDate())).set(Tables.TIME_METRIC.GOALS_CHANGE_MS_EPOCH, (Object)updatedTimeMetric.getGoalsChangeMsEpoch()).set(Tables.TIME_METRIC.THRESHOLDS_CONFIG_CHANGE_DATE, (Object)this.toTimestampOrDefault(updatedTimeMetric.getThresholdsConfigChangedDate())).set(Tables.TIME_METRIC.THRESHOLDS_CHANGE_MS_EPOCH, (Object)updatedTimeMetric.getThresholdsChangedMsEpoch()).set(Tables.TIME_METRIC.CREATED_DATE, (Object)updatedTimeMetric.getCreatedDate()).execute();
        if (rowsUpdated != 1L) {
            throw new RuntimeException(String.format("Expected %d row of time metric to be updated, but %d updated", 1, rowsUpdated));
        }
    }

    @Override
    public long delete(TimeMetric timeMetric) {
        return (Long)this.databaseAccessor.runInTransaction(conn -> this.delete((DatabaseConnection)conn, timeMetric));
    }

    @Override
    public long delete(DatabaseConnection databaseConnection, TimeMetric timeMetric) {
        return databaseConnection.delete((RelationalPath)Tables.TIME_METRIC).where((Predicate)Tables.TIME_METRIC.ID.eq((Object)timeMetric.getId())).execute();
    }

    private Option<TimeMetric> getTimeMetricById(DatabaseConnection connection, int timeMetricId) {
        TimeMetric timeMetric = (TimeMetric)((Object)((SQLQuery)((SQLQuery)connection.select((Expression)new TimeMetricMapper()).from((Expression)Tables.TIME_METRIC)).where((Predicate)Tables.TIME_METRIC.ID.eq((Object)timeMetricId))).fetchOne());
        return Option.option((Object)((Object)timeMetric));
    }

    private Timestamp toTimestampOrDefault(DateTime dateTime) {
        return dateTime == null ? new Timestamp(0L) : new Timestamp(dateTime.getMillis());
    }
}

