/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.configuration.timemetric;

import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;
import com.atlassian.fugue.Either;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.pocketknife.api.util.ServiceResult;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.bootstrap.lifecycle.ServiceDeskComponentAccessor;
import com.atlassian.servicedesk.internal.api.ServiceDeskManager;
import com.atlassian.servicedesk.internal.feature.report.series.SeriesQStore;
import com.atlassian.servicedesk.internal.sla.audit.SlaAuditLogDataHelper;
import com.atlassian.servicedesk.internal.sla.audit.SlaAuditLogInput;
import com.atlassian.servicedesk.internal.sla.audit.SlaAuditLogManager;
import com.atlassian.servicedesk.internal.sla.audit.SlaAuditLogReason;
import com.atlassian.servicedesk.internal.sla.configuration.condition.MetricConditionRefQStore;
import com.atlassian.servicedesk.internal.sla.configuration.goal.GoalManager;
import com.atlassian.servicedesk.internal.sla.configuration.threshold.SlaThresholdQStore;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetric;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetricManager;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetricQStore;
import com.atlassian.servicedesk.internal.util.SafeRunner;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Unit;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
public class TimeMetricManagerImpl
implements TimeMetricManager {
    protected final Log log = Log.with(this.getClass());
    private TimeMetricQStore timeMetricQStore;
    private MetricConditionRefQStore metricConditionRefQStore;
    private GoalManager goalManager;
    private SeriesQStore seriesStore;
    private SlaThresholdQStore slaThresholdQStore;
    private final SlaAuditLogManager slaAuditLogManager;
    private final SlaAuditLogDataHelper slaAuditLogDataHelper;
    private final SafeRunner safeRunner;

    @Autowired
    public TimeMetricManagerImpl(TimeMetricQStore timeMetricQStore, MetricConditionRefQStore metricConditionRefQStore, GoalManager goalManager, SeriesQStore seriesStore, SlaThresholdQStore slaThresholdQStore, SlaAuditLogManager slaAuditLogManager, SlaAuditLogDataHelper slaAuditLogDataHelper, SafeRunner safeRunner) {
        this.timeMetricQStore = timeMetricQStore;
        this.metricConditionRefQStore = metricConditionRefQStore;
        this.goalManager = goalManager;
        this.seriesStore = seriesStore;
        this.slaThresholdQStore = slaThresholdQStore;
        this.slaAuditLogManager = slaAuditLogManager;
        this.slaAuditLogDataHelper = slaAuditLogDataHelper;
        this.safeRunner = safeRunner;
    }

    @Override
    @Nonnull
    public io.atlassian.fugue.Either<ErrorCollection, TimeMetric> getTimeMetric(ServiceDesk serviceDesk, int id) {
        return (io.atlassian.fugue.Either)this.timeMetricQStore.getTimeMetric(serviceDesk, id).fold(() -> StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.NOT_FOUND, (String)"metric not found", (Object[])new Object[0])), io.atlassian.fugue.Either::right);
    }

    @Override
    @Nonnull
    public List<TimeMetric> getTimeMetrics(ServiceDesk serviceDesk) {
        return this.timeMetricQStore.getTimeMetricsForServiceDesk(serviceDesk);
    }

    @Override
    public io.atlassian.fugue.Either<ErrorCollection, TimeMetric> getTimeMetric(ServiceDesk serviceDesk, CustomField customField) {
        return (io.atlassian.fugue.Either)this.timeMetricQStore.getTimeMetricByServiceDeskAndCustomField(serviceDesk, customField).fold(() -> StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.NOT_FOUND, (String)"metric not found", (Object[])new Object[0])), io.atlassian.fugue.Either::right);
    }

    @Override
    public List<TimeMetric> getAllTimeMetricByCustomFieldForServiceDesks(CustomField customField, Collection<ServiceDesk> serviceDesks) {
        return this.timeMetricQStore.getAllTimeMetricByCustomFieldForServiceDesks(customField, serviceDesks);
    }

    @Override
    public List<TimeMetric> getTimeMetricsByCustomField(CustomField field) {
        return this.timeMetricQStore.getTimeMetricsByCustomField(field);
    }

    @Override
    public Set<Long> getSlaCustomFieldIdsInUse() {
        List<TimeMetric> allTimeMetrics = this.timeMetricQStore.getAll();
        return allTimeMetrics.stream().map(TimeMetric::getCustomFieldId).collect(Collectors.toSet());
    }

    @Override
    public long getTotalNumberOfConfiguredSlaTimeMetrics() {
        return this.timeMetricQStore.getTotalNumberOfTimeMetrics();
    }

    @Override
    @Nonnull
    public io.atlassian.fugue.Either<ErrorCollection, TimeMetric> createTimeMetric(ServiceDesk serviceDesk, TimeMetric timeMetric) {
        io.atlassian.fugue.Either<ErrorCollection, Unit> validate2 = this.validate(serviceDesk, timeMetric);
        if (validate2.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)validate2.left().get());
        }
        DateTime now = DateTime.now();
        timeMetric = TimeMetric.builder(timeMetric).thresholdsConfigChangeDate(now).thresholdsChangeMsEpoch(now.getMillis()).createdDate(now.getMillis()).build();
        return (io.atlassian.fugue.Either)this.timeMetricQStore.createTimeMetric(serviceDesk, timeMetric).fold(() -> StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.SERVER_ERROR, (String)"sd.error.can.not.create", (Object[])new Object[]{"TimeMetric"})), io.atlassian.fugue.Either::right);
    }

    @Override
    @Nonnull
    public io.atlassian.fugue.Either<ErrorCollection, TimeMetric> updateTimeMetric(ServiceDesk serviceDesk, TimeMetric timeMetric) {
        io.atlassian.fugue.Either<ErrorCollection, Unit> validate2 = this.validate(serviceDesk, timeMetric);
        if (validate2.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)validate2.left().get());
        }
        return this.updateTimeMetricImpl(timeMetric);
    }

    @Override
    @Nonnull
    public io.atlassian.fugue.Either<ErrorCollection, TimeMetric> updateDefinitionChangeDate(TimeMetric timeMetric) {
        TimeMetric updated = TimeMetric.builder(timeMetric).definitionChangeDate(DateTime.now()).build();
        return this.updateTimeMetricImpl(updated);
    }

    @Override
    @Nonnull
    public io.atlassian.fugue.Either<ErrorCollection, TimeMetric> updateDefinitionChangeMsEpoch(TimeMetric timeMetric) {
        TimeMetric updated = TimeMetric.builder(timeMetric).definitionChangeMsEpoch(DateTime.now().getMillis()).build();
        return this.updateTimeMetricImpl(updated);
    }

    @Override
    @Nonnull
    public io.atlassian.fugue.Either<ErrorCollection, TimeMetric> updateDefinitionChangeDateAndMsEpoch(TimeMetric timeMetric) {
        DateTime now = DateTime.now();
        TimeMetric updated = TimeMetric.builder(timeMetric).definitionChangeDate(now).definitionChangeMsEpoch(now.getMillis()).build();
        return this.updateTimeMetricImpl(updated);
    }

    @Override
    @Nonnull
    public io.atlassian.fugue.Either<ErrorCollection, TimeMetric> updateGoalsChangeDate(TimeMetric timeMetric) {
        TimeMetric updated = TimeMetric.builder(timeMetric).goalsChangeDate(DateTime.now()).build();
        return this.updateTimeMetricImpl(updated);
    }

    @Override
    @Nonnull
    public io.atlassian.fugue.Either<ErrorCollection, TimeMetric> updateGoalsChangeMsEpoch(TimeMetric timeMetric) {
        TimeMetric updated = TimeMetric.builder(timeMetric).goalsChangeMsEpoch(DateTime.now().getMillis()).build();
        return this.updateTimeMetricImpl(updated);
    }

    @Override
    @Nonnull
    public io.atlassian.fugue.Either<ErrorCollection, TimeMetric> updateGoalsChangeDateAndMsEpoch(TimeMetric timeMetric) {
        DateTime now = DateTime.now();
        TimeMetric updated = TimeMetric.builder(timeMetric).goalsChangeDate(now).goalsChangeMsEpoch(now.getMillis()).build();
        return this.updateTimeMetricImpl(updated);
    }

    @Override
    @Nonnull
    public io.atlassian.fugue.Either<ErrorCollection, TimeMetric> updateThresholdConfigChangeDate(TimeMetric timeMetric) {
        TimeMetric updated = TimeMetric.builder(timeMetric).thresholdsConfigChangeDate(new DateTime()).build();
        return this.updateTimeMetricImpl(updated);
    }

    @Override
    @Nonnull
    public io.atlassian.fugue.Either<ErrorCollection, TimeMetric> updateThresholdConfigChangeMsEpoch(TimeMetric timeMetric) {
        TimeMetric updated = TimeMetric.builder(timeMetric).thresholdsChangeMsEpoch(DateTime.now().getMillis()).build();
        return this.updateTimeMetricImpl(updated);
    }

    @Override
    @Nonnull
    public io.atlassian.fugue.Either<ErrorCollection, TimeMetric> updateThresholdConfigChangeDateAndMsEpoch(TimeMetric timeMetric) {
        DateTime now = DateTime.now();
        TimeMetric updated = TimeMetric.builder(timeMetric).thresholdsConfigChangeDate(now).thresholdsChangeMsEpoch(now.getMillis()).build();
        return this.updateTimeMetricImpl(updated);
    }

    @Override
    @Nonnull
    public io.atlassian.fugue.Either<ErrorCollection, Unit> deleteTimeMetric(ServiceDesk serviceDesk, TimeMetric timeMetric) {
        this.seriesStore.deleteSeriesByMetricId(serviceDesk, timeMetric);
        this.metricConditionRefQStore.deleteMetricConditionsByTimeMetric(timeMetric);
        this.goalManager.deleteGoalsForTimeMetric(timeMetric);
        this.slaThresholdQStore.deleteSlaThresholdForTimeMetric(timeMetric);
        long deletedRows = this.timeMetricQStore.delete(timeMetric);
        if (deletedRows != 1L) {
            return StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.NOT_FOUND, (String)"No time metric found to delete", (Object[])new Object[0]));
        }
        this.safeRunner.run(() -> this.auditLogForDeletion(timeMetric));
        return io.atlassian.fugue.Either.right((Object)Unit.Unit());
    }

    @Override
    @Nonnull
    public io.atlassian.fugue.Either<ErrorCollection, Unit> deleteTimeMetric(DatabaseConnection databaseConnection, ServiceDesk serviceDesk, TimeMetric timeMetric) {
        this.seriesStore.deleteSeriesByMetricId(databaseConnection, serviceDesk, timeMetric);
        this.metricConditionRefQStore.deleteMetricConditionsByTimeMetric(databaseConnection, timeMetric);
        this.goalManager.deleteGoalsForTimeMetric(databaseConnection, timeMetric);
        this.slaThresholdQStore.deleteSlaThresholdForTimeMetric(databaseConnection, timeMetric);
        long deletedRows = this.timeMetricQStore.delete(databaseConnection, timeMetric);
        if (deletedRows != 1L) {
            return StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.NOT_FOUND, (String)"No time metric found to delete", (Object[])new Object[0]));
        }
        this.safeRunner.run(() -> this.auditLogForDeletion(timeMetric, databaseConnection));
        return io.atlassian.fugue.Either.right((Object)Unit.Unit());
    }

    @Override
    @Nonnull
    public io.atlassian.fugue.Either<ErrorCollection, Unit> validate(ServiceDesk serviceDesk, TimeMetric timeMetric) {
        List<TimeMetric> existingTimeMetrics = this.timeMetricQStore.getTimeMetricsForServiceDesk(serviceDesk);
        String finalName = StringUtils.defaultString((String)timeMetric.getName()).trim();
        if (finalName.isEmpty()) {
            return StepsConverters.newerEither((Either)ServiceResult.error((String)"name", (ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED, (String)"sd.sla.metric.name.required", (Object[])new Object[0]));
        }
        timeMetric = TimeMetric.builder(timeMetric).name(finalName).build();
        if (finalName.length() > 255) {
            return StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED, (String)"sd.sla.metric.name.too.long", (Object[])new Object[0]));
        }
        if (this.nameInUse(timeMetric, existingTimeMetrics)) {
            return StepsConverters.newerEither((Either)ServiceResult.error((String)"name", (ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED, (String)"sd.sla.metric.name.used", (Object[])new Object[0]));
        }
        if (timeMetric.getCustomFieldId() == null) {
            return StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED, (String)"sd.sla.metric.custom.field.id.required", (Object[])new Object[0]));
        }
        if (this.customFieldInUse(timeMetric, existingTimeMetrics)) {
            return StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED, (String)"sd.sla.metric.custom.field.id.used", (Object[])new Object[0]));
        }
        return io.atlassian.fugue.Either.right((Object)Unit.Unit());
    }

    @Override
    @Nonnull
    public io.atlassian.fugue.Either<ErrorCollection, ServiceDesk> getServiceDeskForTimeMetric(TimeMetric timeMetric) {
        Integer serviceDeskId = this.timeMetricQStore.getServiceDeskIdForTimeMetric(timeMetric);
        if (serviceDeskId == null) {
            return StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.NOT_FOUND, (String)"sd.agent.servicedesk.error.servicedesk.missing", (Object[])new Object[0]));
        }
        ServiceDeskManager serviceDeskManager = ServiceDeskComponentAccessor.getServiceDeskManager();
        io.atlassian.fugue.Either serviceDeskById = serviceDeskManager.getServiceDeskById(serviceDeskId.intValue());
        if (serviceDeskById.isLeft()) {
            return StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.NOT_FOUND, (String)"sd.agent.servicedesk.error.servicedesk.missing", (Object[])new Object[0]));
        }
        ServiceDesk serviceDesk = (ServiceDesk)serviceDeskById.right().get();
        return io.atlassian.fugue.Either.right((Object)serviceDesk);
    }

    private io.atlassian.fugue.Either<ErrorCollection, TimeMetric> updateTimeMetricImpl(TimeMetric timeMetric) {
        return (io.atlassian.fugue.Either)this.timeMetricQStore.updateTimeMetric(timeMetric).fold(() -> StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.NOT_FOUND, (String)"metric not found", (Object[])new Object[0])), io.atlassian.fugue.Either::right);
    }

    private boolean nameInUse(TimeMetric timeMetric, List<TimeMetric> existingTimeMetrics) {
        for (TimeMetric tm : existingTimeMetrics) {
            if (timeMetric.getId() != null && tm.getId().equals(timeMetric.getId()) || tm.getName() == null || !tm.getName().equals(timeMetric.getName())) continue;
            return true;
        }
        return false;
    }

    private boolean customFieldInUse(TimeMetric timeMetric, List<TimeMetric> existingTimeMetrics) {
        for (TimeMetric tm : existingTimeMetrics) {
            if (timeMetric.getId() != null && tm.getId().equals(timeMetric.getId()) || tm.getCustomFieldId() == null || !tm.getCustomFieldId().equals(timeMetric.getCustomFieldId())) continue;
            return true;
        }
        return false;
    }

    private void auditLogForDeletion(TimeMetric timeMetric, DatabaseConnection databaseConnection) {
        SlaAuditLogInput input = new SlaAuditLogInput((Option<Long>)Option.none(), (Option<Long>)Option.none(), (Option<SlaAuditLogReason>)Option.some((Object)((Object)SlaAuditLogReason.SLA_DELETED)), System.currentTimeMillis(), (Option<Map<String, String>>)Option.some(this.slaAuditLogDataHelper.determineDeletionData(timeMetric)));
        this.slaAuditLogManager.createAuditLogRecords(Lists.newArrayList((Object[])new SlaAuditLogInput[]{input}), databaseConnection);
    }

    private void auditLogForDeletion(TimeMetric timeMetric) {
        SlaAuditLogInput input = new SlaAuditLogInput((Option<Long>)Option.none(), (Option<Long>)Option.none(), (Option<SlaAuditLogReason>)Option.some((Object)((Object)SlaAuditLogReason.SLA_DELETED)), System.currentTimeMillis(), (Option<Map<String, String>>)Option.some(this.slaAuditLogDataHelper.determineDeletionData(timeMetric)));
        this.slaAuditLogManager.createAuditLogRecords(Lists.newArrayList((Object[])new SlaAuditLogInput[]{input}));
    }
}

