/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.configuration.timemetric;

import com.atlassian.activeobjects.tx.Transactional;
import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetric;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Unit;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
public interface TimeMetricManager {
    public Either<ErrorCollection, TimeMetric> getTimeMetric(ServiceDesk var1, int var2);

    public Either<ErrorCollection, TimeMetric> getTimeMetric(ServiceDesk var1, CustomField var2);

    public List<TimeMetric> getAllTimeMetricByCustomFieldForServiceDesks(CustomField var1, Collection<ServiceDesk> var2);

    public List<TimeMetric> getTimeMetrics(ServiceDesk var1);

    public List<TimeMetric> getTimeMetricsByCustomField(CustomField var1);

    public Set<Long> getSlaCustomFieldIdsInUse();

    public long getTotalNumberOfConfiguredSlaTimeMetrics();

    @Transactional
    public Either<ErrorCollection, TimeMetric> createTimeMetric(ServiceDesk var1, TimeMetric var2);

    @Transactional
    public Either<ErrorCollection, TimeMetric> updateTimeMetric(ServiceDesk var1, TimeMetric var2);

    @Transactional
    public Either<ErrorCollection, TimeMetric> updateDefinitionChangeDate(TimeMetric var1);

    @Transactional
    public Either<ErrorCollection, TimeMetric> updateDefinitionChangeMsEpoch(TimeMetric var1);

    @Transactional
    public Either<ErrorCollection, TimeMetric> updateDefinitionChangeDateAndMsEpoch(TimeMetric var1);

    @Transactional
    public Either<ErrorCollection, TimeMetric> updateGoalsChangeDate(TimeMetric var1);

    @Transactional
    public Either<ErrorCollection, TimeMetric> updateGoalsChangeMsEpoch(TimeMetric var1);

    @Transactional
    public Either<ErrorCollection, TimeMetric> updateGoalsChangeDateAndMsEpoch(TimeMetric var1);

    public Either<ErrorCollection, TimeMetric> updateThresholdConfigChangeDate(TimeMetric var1);

    public Either<ErrorCollection, TimeMetric> updateThresholdConfigChangeMsEpoch(TimeMetric var1);

    public Either<ErrorCollection, TimeMetric> updateThresholdConfigChangeDateAndMsEpoch(TimeMetric var1);

    @Transactional
    public Either<ErrorCollection, Unit> deleteTimeMetric(ServiceDesk var1, TimeMetric var2);

    @Transactional
    public Either<ErrorCollection, Unit> deleteTimeMetric(DatabaseConnection var1, ServiceDesk var2, TimeMetric var3);

    public Either<ErrorCollection, Unit> validate(ServiceDesk var1, TimeMetric var2);

    public Either<ErrorCollection, ServiceDesk> getServiceDeskForTimeMetric(TimeMetric var1);
}

