/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.configuration.timemetric;

import com.atlassian.fugue.Either;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.ErrorBuilder;
import com.atlassian.pocketknife.api.commons.error.HttpStatusCode;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.api.commons.result.ServiceResult;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.sla.metrics.TimeMetricService;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.InternalTimeMetricService;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetric;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class PublicTimeMetricServiceImpl
implements TimeMetricService {
    @Autowired
    private InternalTimeMetricService internalTimeMetricService;
    @Autowired
    private ErrorResultHelper errorResultHelper;

    public Either<AnError, Collection<com.atlassian.servicedesk.api.sla.metrics.TimeMetric>> getTimeMetrics(ApplicationUser user, ServiceDesk serviceDesk) {
        List<TimeMetric> timeMetrics = this.internalTimeMetricService.getTimeMetrics(user, serviceDesk);
        List casted = PublicTimeMetricServiceImpl.cast(timeMetrics);
        return ServiceResult.ok(casted);
    }

    public Either<AnError, com.atlassian.servicedesk.api.sla.metrics.TimeMetric> getTimeMetric(ApplicationUser user, ServiceDesk serviceDesk, int metricId) {
        Either timeMetricResult = StepsConverters.olderEither(this.internalTimeMetricService.getTimeMetric(user, serviceDesk, metricId));
        if (timeMetricResult.isLeft()) {
            return Either.left((Object)ErrorBuilder.errorBuilder().addError((String)((ErrorCollection)timeMetricResult.left().get()).getErrorMessages().iterator().next()).httpStatusCode(HttpStatusCode.NOT_FOUND).buildSingleError());
        }
        return ServiceResult.ok((Object)timeMetricResult.right().get());
    }

    private static <T> List<T> cast(List<?> list) {
        return list;
    }
}

