/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.configuration.goal;

import com.atlassian.fugue.Either;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.pocketknife.api.jql.JqlValidation;
import com.atlassian.pocketknife.api.util.ServiceResult;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.sla.metrics.TimeMetricService;
import com.atlassian.servicedesk.internal.api.sla.PermissionService;
import com.atlassian.servicedesk.internal.sla.configuration.goal.Goal;
import com.atlassian.servicedesk.internal.sla.configuration.goal.GoalManager;
import com.atlassian.servicedesk.internal.sla.configuration.goal.GoalService;
import com.atlassian.servicedesk.internal.sla.configuration.goal.GoalWithTimeMetricId;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetric;
import io.atlassian.fugue.Unit;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GoalServiceImpl
implements GoalService {
    private final GoalManager goalManager;
    private final PermissionService permissionService;
    private final JqlValidation jqlValidation;
    private final TimeMetricService timeMetricService;

    @Autowired
    public GoalServiceImpl(GoalManager goalManager, PermissionService permissionService, JqlValidation jqlValidation, TimeMetricService timeMetricService) {
        this.goalManager = goalManager;
        this.permissionService = permissionService;
        this.jqlValidation = jqlValidation;
        this.timeMetricService = timeMetricService;
    }

    @Override
    public List<Goal> getAllByTimeMetric(ApplicationUser user, ServiceDesk serviceDesk, TimeMetric timeMetric) {
        return this.goalManager.getAllByTimeMetric(timeMetric);
    }

    @Override
    public List<GoalWithTimeMetricId> getAll(ApplicationUser user, ServiceDesk sd) {
        io.atlassian.fugue.Either timeMetrics = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.timeMetricService.getTimeMetrics(user, sd))).yield(tm -> tm.stream().collect(Collectors.toList()));
        if (timeMetrics.isLeft()) {
            return new ArrayList<GoalWithTimeMetricId>();
        }
        return this.goalManager.getAllByTimeMetrics((List)timeMetrics.right().get());
    }

    @Override
    public io.atlassian.fugue.Either<ErrorCollection, List<Goal>> updateAll(ApplicationUser user, ServiceDesk serviceDesk, TimeMetric timeMetric, List<Goal> goals) {
        if (!this.permissionService.canManageSlas(user, serviceDesk)) {
            return StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.FORBIDDEN, (String)"sd.sla.goal.service.permission.error.update", (Object[])new Object[0]));
        }
        io.atlassian.fugue.Either<ErrorCollection, Unit> validate2 = this.validateGoals(user, serviceDesk, goals);
        if (validate2.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)validate2.left().get());
        }
        return this.goalManager.updateAll(timeMetric, goals);
    }

    @Override
    public io.atlassian.fugue.Either<ErrorCollection, Unit> validateGoals(ApplicationUser user, ServiceDesk serviceDesk, List<Goal> goals) {
        if (goals == null || goals.isEmpty()) {
            return StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED, (String)"sd.sla.configuration.metric.goal.default.required", (Object[])new Object[0]));
        }
        io.atlassian.fugue.Either<ErrorCollection, Unit> goalsValidation = this.validateDefault(goals);
        if (goalsValidation.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)goalsValidation.left().get());
        }
        for (Goal goal : goals) {
            io.atlassian.fugue.Either<ErrorCollection, Unit> goalValidation = this.validateGoal(user, goal);
            if (!goalValidation.isLeft()) continue;
            return io.atlassian.fugue.Either.left((Object)goalValidation.left().get());
        }
        return io.atlassian.fugue.Either.right((Object)Unit.Unit());
    }

    private io.atlassian.fugue.Either<ErrorCollection, Unit> validateDefault(List<Goal> goals) {
        Goal lastGoal = goals.get(goals.size() - 1);
        for (Goal goal : goals) {
            if (!(goal != lastGoal ? goal.isDefaultGoal() : !goal.isDefaultGoal())) continue;
            return StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED, (String)"sd.sla.configuration.metric.goal.default.wrong.position", (Object[])new Object[0]));
        }
        return io.atlassian.fugue.Either.right((Object)Unit.Unit());
    }

    @Override
    public io.atlassian.fugue.Either<ErrorCollection, Unit> validateGoal(ApplicationUser user, Goal goal) {
        String jqlQuery = StringUtils.defaultString((String)goal.getJqlQuery()).trim();
        if (!goal.isDefaultGoal() && jqlQuery.isEmpty()) {
            return StepsConverters.newerEither((Either)ServiceResult.error((String)"jqlQuery", (ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED, (String)"sd.sla.configuration.metric.goal.jql.required", (Object[])new Object[0]));
        }
        if (goal.isDefaultGoal() && !jqlQuery.isEmpty()) {
            return StepsConverters.newerEither((Either)ServiceResult.error((String)"jqlQuery", (ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED, (String)"sd.sla.configuration.metric.goal.jql.not.empty", (Object[])new Object[0]));
        }
        List<String> jqlErrors = this.jqlValidation.validateJql(user, jqlQuery);
        if (!jqlErrors.isEmpty()) {
            StringBuilder message = new StringBuilder();
            for (String error : jqlErrors) {
                message.append(error).append(" ");
            }
            return StepsConverters.newerEither((Either)ServiceResult.error((String)"jqlQuery", (ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED, (String)message.toString(), (Object[])new Object[0]));
        }
        if (goal.getDuration() != null && goal.getDuration() <= 0L) {
            return StepsConverters.newerEither((Either)ServiceResult.error((String)"duration", (ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED, (String)"sd.sla.configuration.metric.goal.duration.invalid", (Object[])new Object[0]));
        }
        return io.atlassian.fugue.Either.right((Object)Unit.Unit());
    }

    @Override
    public io.atlassian.fugue.Either<ErrorCollection, Goal> getGoal(ApplicationUser user, TimeMetric timeMetric, Integer goalId) {
        return this.goalManager.getGoal(timeMetric, goalId);
    }
}

