/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.configuration.goal;

import com.atlassian.servicedesk.internal.querydsl.mapping.Tables;
import com.atlassian.servicedesk.internal.sla.configuration.goal.Goal;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import io.atlassian.fugue.Option;
import java.sql.Timestamp;
import org.apache.commons.lang.BooleanUtils;
import org.joda.time.DateTime;

class GoalMapperHelper {
    GoalMapperHelper() {
    }

    public static Goal map(Tuple tuple) {
        Integer id = (Integer)tuple.get(Tables.GOAL.ID);
        Integer calendarId = (Integer)tuple.get(Tables.GOAL.CALENDAR_ID);
        Boolean defaultGoal = (Boolean)tuple.get((Expression)Tables.GOAL.DEFAULT_GOAL);
        String jqlQuery = (String)tuple.get((Expression)Tables.GOAL.JQL_QUERY);
        Option position = Option.option((Object)tuple.get(Tables.GOAL.POS));
        Long targetDuration = (Long)tuple.get(Tables.GOAL.TARGET_DURATION);
        Timestamp updatedDate = (Timestamp)tuple.get(Tables.GOAL.TIME_UPDATED_DATE);
        Long updatedMsEpoch = (Long)tuple.get(Tables.GOAL.TIME_UPDATED_MS_EPOCH);
        Goal.GoalBuilder builder = Goal.builder().id(id).calendarId(calendarId).defaultGoal(BooleanUtils.toBoolean((Boolean)defaultGoal)).jqlQuery(jqlQuery).duration(targetDuration).timeUpdatedDate(GoalMapperHelper.toDateTime(updatedDate)).timeUpdatedMsEpoch(GoalMapperHelper.defaultZeroLong(updatedMsEpoch));
        position.forEach(builder::position);
        return builder.build();
    }

    private static DateTime toDateTime(Timestamp t) {
        return (DateTime)Option.option((Object)t).map(DateTime::new).getOrElse((Object)new DateTime(0L));
    }

    private static long defaultZeroLong(Long l) {
        return (Long)Option.option((Object)l).getOrElse((Object)0L);
    }
}

