/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.configuration.goal;

import com.atlassian.fugue.Either;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.pocketknife.api.ao.dao.AbstractModel;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.pocketknife.api.util.ServiceResult;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.bootstrap.lifecycle.ServiceDeskComponentAccessor;
import com.atlassian.servicedesk.internal.api.sla.configuration.calendar.CalendarReference;
import com.atlassian.servicedesk.internal.api.util.CollectorsHelper;
import com.atlassian.servicedesk.internal.sla.configuration.goal.Goal;
import com.atlassian.servicedesk.internal.sla.configuration.goal.GoalManager;
import com.atlassian.servicedesk.internal.sla.configuration.goal.GoalQStore;
import com.atlassian.servicedesk.internal.sla.configuration.goal.GoalWithTimeMetricId;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetric;
import com.atlassian.servicedesk.internal.utils.CacheUtil;
import com.atlassian.vcache.RequestCache;
import com.atlassian.vcache.VCacheFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GoalManagerImpl
implements GoalManager {
    @VisibleForTesting
    static final String GOAL_CACHE_ENTITY_KEY = "allGoalsCacheEntity";
    private final GoalQStore goalQStore;
    private final RequestCache<String, AllGoalsCache> allGoalsCache;

    @Autowired
    public GoalManagerImpl(GoalQStore goalQStore, VCacheFactory vCacheFactory) {
        this.goalQStore = goalQStore;
        this.allGoalsCache = vCacheFactory.getRequestCache(CacheUtil.standardName(this, "allGoalsCache"));
    }

    private AllGoalsCache getOrCreateAllGoalsCache() {
        return (AllGoalsCache)this.allGoalsCache.get((Object)GOAL_CACHE_ENTITY_KEY, () -> {
            List<GoalWithTimeMetricId> allGoalsOrderedByPosition = this.goalQStore.getAllGoalsWithTimeMetricIdOrderedByPosition();
            return new AllGoalsCache(allGoalsOrderedByPosition);
        });
    }

    @Override
    public List<Goal> getAllByTimeMetric(TimeMetric timeMetric) {
        AllGoalsCache allGoalsCache = this.getOrCreateAllGoalsCache();
        List<Goal> goalsForTimeMetric = allGoalsCache.getGoalsForTimeMetric(timeMetric);
        if (goalsForTimeMetric.isEmpty()) {
            Goal defaultGoal = new Goal.GoalBuilder().defaultGoal(true).build();
            this.allGoalsCache.removeAll();
            goalsForTimeMetric = this.updateAllImpl(timeMetric, goalsForTimeMetric, Lists.newArrayList((Object[])new Goal[]{defaultGoal}));
        }
        return ImmutableList.copyOf(goalsForTimeMetric);
    }

    @Override
    public List<GoalWithTimeMetricId> getAllByTimeMetrics(List<com.atlassian.servicedesk.api.sla.metrics.TimeMetric> timeMetrics) {
        AllGoalsCache allGoalsCache = this.getOrCreateAllGoalsCache();
        List<GoalWithTimeMetricId> goals = allGoalsCache.getGoalsForTimeMetrics(timeMetrics);
        return ImmutableList.copyOf(goals);
    }

    @Override
    public List<Goal> getByCalendar(CalendarReference calendarReference) {
        if (calendarReference.isDefaultCalendar()) {
            return Collections.emptyList();
        }
        Optional allGoalsCacheOpt = this.allGoalsCache.get((Object)GOAL_CACHE_ENTITY_KEY);
        if (allGoalsCacheOpt.isPresent()) {
            return ImmutableList.copyOf(((AllGoalsCache)allGoalsCacheOpt.get()).getGoalsForCalendar(calendarReference));
        }
        return ImmutableList.copyOf(this.goalQStore.getAllGoalsByCalendarReference(calendarReference));
    }

    @Override
    public io.atlassian.fugue.Either<ErrorCollection, List<Goal>> updateAll(TimeMetric timeMetric, List<Goal> goals) {
        this.allGoalsCache.removeAll();
        List<Goal> goalsBeforeUpdate = this.goalQStore.getGoalsForTimeMetric(timeMetric);
        UpdateDateResult updateDateResult = this.updateChangedDates(goalsBeforeUpdate, goals);
        if (!updateDateResult.goalsChanged && !updateDateResult.goalTimeUpdated) {
            return io.atlassian.fugue.Either.right(goals);
        }
        List<Goal> updatedGoals = this.updateAllImpl(timeMetric, goalsBeforeUpdate, updateDateResult.goals);
        if (updateDateResult.goalsChanged) {
            ServiceDeskComponentAccessor.getTimeMetricManager().updateGoalsChangeDateAndMsEpoch(timeMetric);
        }
        return io.atlassian.fugue.Either.right(updatedGoals);
    }

    @Override
    public io.atlassian.fugue.Either<ErrorCollection, Goal> getGoal(TimeMetric timeMetric, Integer goalId) {
        AllGoalsCache allGoalsCache = this.getOrCreateAllGoalsCache();
        return (io.atlassian.fugue.Either)allGoalsCache.getGoalForTimeMetric(timeMetric, goalId).fold(() -> StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.NOT_FOUND, (String)("No goal with this id " + goalId + " for time metric " + timeMetric.getId()), (Object[])new Object[0])), io.atlassian.fugue.Either::right);
    }

    @Override
    public io.atlassian.fugue.Either<ErrorCollection, Goal> getGoal(Integer goalId) {
        AllGoalsCache allGoalsCache = this.getOrCreateAllGoalsCache();
        return (io.atlassian.fugue.Either)allGoalsCache.getGoal(goalId).fold(() -> StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.NOT_FOUND, (String)("No goal with this id " + goalId), (Object[])new Object[0])), io.atlassian.fugue.Either::right);
    }

    @Override
    public void updateTimeUpdatedDate(List<Goal> goals, DateTime timeUpdatedDate) {
        this.allGoalsCache.removeAll();
        for (Goal goal : goals) {
            this.updateTimeUpdatedDate(goal, timeUpdatedDate, true, false);
        }
    }

    @Override
    public void updateTimeUpdatedMsEpoch(List<Goal> goals, DateTime timeUpdatedDate) {
        this.allGoalsCache.removeAll();
        for (Goal goal : goals) {
            this.updateTimeUpdatedDate(goal, timeUpdatedDate, false, true);
        }
    }

    @Override
    public void updateTimeUpdatedDateAndMsEpoch(List<Goal> goals, DateTime timeUpdatedDate) {
        this.allGoalsCache.removeAll();
        for (Goal goal : goals) {
            this.updateTimeUpdatedDate(goal, timeUpdatedDate, true, true);
        }
    }

    @Override
    public void deleteGoalsForTimeMetric(TimeMetric timeMetric) {
        this.allGoalsCache.removeAll();
        this.goalQStore.deleteGoalsForTimeMetric(timeMetric);
    }

    @Override
    public void deleteGoalsForTimeMetric(DatabaseConnection databaseConnection, TimeMetric timeMetric) {
        this.allGoalsCache.removeAll();
        this.goalQStore.deleteGoalsForTimeMetric(databaseConnection, timeMetric);
    }

    private void updateTimeUpdatedDate(Goal goal, DateTime timeUpdatedDate, boolean updateDate, boolean updateMsEpoch) {
        Goal.GoalBuilder builder = Goal.builder(goal);
        if (updateDate) {
            builder.timeUpdatedDate(timeUpdatedDate);
        }
        if (updateMsEpoch) {
            builder.timeUpdatedMsEpoch(timeUpdatedDate.getMillis());
        }
        this.goalQStore.updateGoalTimeUpdated(builder.build());
    }

    private List<Goal> updateAllImpl(TimeMetric timeMetric, List<Goal> goalsBeforeUpdate, List<Goal> goals) {
        return this.goalQStore.updateAllGoalsForTimeMetric(timeMetric, goalsBeforeUpdate, goals);
    }

    private UpdateDateResult updateChangedDates(List<Goal> existingGoals, List<Goal> goals) {
        UpdateDateResult result = new UpdateDateResult();
        result.goalsChanged = this.haveGoalsChanged(existingGoals, goals);
        this.updateGoalTimeUpdated(existingGoals, goals, result);
        return result;
    }

    private void updateGoalTimeUpdated(List<Goal> existing, List<Goal> goals, UpdateDateResult result) {
        ArrayList<Goal> newGoals = new ArrayList<Goal>();
        DateTime now = DateTime.now();
        boolean goalTimeUpdated = false;
        for (Goal goal : goals) {
            Goal.GoalBuilder builder = Goal.builder(goal);
            Goal existingGoal = this.findById(existing, goal.getId());
            if (existingGoal == null || !this.areDurationsEqual(goal, existingGoal) || !this.areCalendarsEqual(goal, existingGoal)) {
                builder.timeUpdatedDate(now).timeUpdatedMsEpoch(now.getMillis());
                goalTimeUpdated = true;
            } else {
                builder.timeUpdatedDate(existingGoal.getTimeUpdatedDate()).timeUpdatedMsEpoch(existingGoal.getTimeUpdatedMsEpoch());
            }
            newGoals.add(builder.build());
        }
        result.goals = newGoals;
        result.goalTimeUpdated = goalTimeUpdated;
    }

    private boolean areDurationsEqual(Goal a, Goal b) {
        Long durationA = a.getDuration() != null ? a.getDuration() : 0L;
        Long durationB = b.getDuration() != null ? b.getDuration() : 0L;
        return durationA.equals(durationB);
    }

    private boolean areCalendarsEqual(Goal a, Goal b) {
        Integer calendarIdA = a.getCalendarId();
        Integer calendarIdB = b.getCalendarId();
        return calendarIdA == null ? calendarIdB == null : calendarIdA.equals(calendarIdB);
    }

    private Goal findById(List<Goal> goals, Integer id) {
        if (id == null) {
            return null;
        }
        for (Goal g : goals) {
            if (!id.equals(g.getId())) continue;
            return g;
        }
        return null;
    }

    private boolean haveGoalsChanged(List<Goal> listA, List<Goal> listB) {
        if (listA.size() != listB.size()) {
            return true;
        }
        for (int x = 0; x < listA.size(); ++x) {
            String jqlB;
            Goal a = listA.get(x);
            Goal b = listB.get(x);
            String jqlA = StringUtils.defaultString((String)a.getJqlQuery()).trim();
            if (!jqlA.equals(jqlB = StringUtils.defaultString((String)b.getJqlQuery()).trim())) {
                return true;
            }
            Integer idA = a.getId();
            Integer idB = b.getId();
            if (idA == null ? idB != null : !idA.equals(idB)) {
                return true;
            }
            Integer calA = a.getCalendarId();
            Integer calB = b.getCalendarId();
            if (!(calA == null ? calB != null : !calA.equals(calB))) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    static class AllGoalsCache {
        private final Map<Integer, GoalWithTimeMetricId> allGoals;

        public AllGoalsCache(@Nonnull List<GoalWithTimeMetricId> allGoals) {
            this.allGoals = (Map)allGoals.stream().collect(CollectorsHelper.toLinkedHashMap(AbstractModel::getId, Function.identity()));
        }

        public List<Goal> getGoalsForTimeMetric(TimeMetric timeMetric) {
            return this.allGoals.values().stream().filter(goal -> Objects.equals(timeMetric.getId(), goal.getTimeMetricId())).collect(Collectors.toList());
        }

        public List<Goal> getGoalsForCalendar(CalendarReference calendarReference) {
            return this.allGoals.values().stream().filter(goal -> Objects.equals(calendarReference.getId(), goal.getCalendarId())).collect(Collectors.toList());
        }

        public List<GoalWithTimeMetricId> getGoalsForTimeMetrics(List<com.atlassian.servicedesk.api.sla.metrics.TimeMetric> timeMetrics) {
            return this.allGoals.values().stream().filter(goal -> timeMetrics.stream().anyMatch(tm -> Objects.equals(goal.getTimeMetricId(), tm.getId()))).collect(Collectors.toList());
        }

        public Option<Goal> getGoalForTimeMetric(TimeMetric timeMetric, Integer goalId) {
            GoalWithTimeMetricId goal = this.allGoals.get(goalId);
            if (goal != null && Objects.equals(timeMetric.getId(), goal.getTimeMetricId())) {
                return Option.some((Object)((Object)goal));
            }
            return Option.none();
        }

        public Option<Goal> getGoal(Integer goalId) {
            return Option.option((Object)((Object)this.allGoals.get(goalId)));
        }
    }

    private static class UpdateDateResult {
        List<Goal> goals;
        boolean goalsChanged;
        boolean goalTimeUpdated;

        private UpdateDateResult() {
        }
    }
}

