/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.configuration.condition;

import com.atlassian.fugue.Either;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.pocketknife.api.util.ServiceResult;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.internal.api.sla.PermissionService;
import com.atlassian.servicedesk.internal.sla.configuration.condition.MetricConditionRef;
import com.atlassian.servicedesk.internal.sla.configuration.condition.MetricConditionRefManager;
import com.atlassian.servicedesk.internal.sla.configuration.condition.MetricConditionRefService;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetric;
import io.atlassian.fugue.Unit;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MetricConditionRefServiceImpl
implements MetricConditionRefService {
    @Autowired
    private MetricConditionRefManager metricConditionRefManager;
    @Autowired
    private PermissionService permissionService;

    @Override
    public io.atlassian.fugue.Either<ErrorCollection, MetricConditionRef> addCondition(ApplicationUser user, ServiceDesk serviceDesk, TimeMetric timeMetric, MetricConditionRef condition) {
        if (!this.permissionService.canManageSlas(user, serviceDesk)) {
            return StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.FORBIDDEN, (String)"sd.sla.metric.condition.service.permission.error", (Object[])new Object[0]));
        }
        return this.metricConditionRefManager.createMetricCondition(timeMetric, condition, true);
    }

    @Override
    public io.atlassian.fugue.Either<ErrorCollection, Unit> removeCondition(ApplicationUser user, ServiceDesk serviceDesk, TimeMetric timeMetric, MetricConditionRef condition) {
        if (!this.permissionService.canManageSlas(user, serviceDesk)) {
            return StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.FORBIDDEN, (String)"sd.sla.metric.condition.service.permission.error", (Object[])new Object[0]));
        }
        return this.metricConditionRefManager.deleteMetricConditionByParams(timeMetric, condition, true);
    }

    @Override
    public List<MetricConditionRef> getMetricConditions(ApplicationUser user, TimeMetric timeMetric) {
        return this.metricConditionRefManager.getMetricConditions(timeMetric);
    }
}

