/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.configuration.condition;

import com.atlassian.fugue.Either;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.pocketknife.api.util.ServiceResult;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.internal.sla.condition.ConditionFactoryService;
import com.atlassian.servicedesk.internal.sla.condition.TimeMetricHitConditionInfo;
import com.atlassian.servicedesk.internal.sla.condition.TimeMetricMatchConditionInfo;
import com.atlassian.servicedesk.internal.sla.configuration.condition.ConditionType;
import com.atlassian.servicedesk.internal.sla.configuration.condition.MetricConditionRef;
import com.atlassian.servicedesk.internal.sla.configuration.condition.MetricConditionRefManager;
import com.atlassian.servicedesk.internal.sla.configuration.condition.MetricConditionRefQStore;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetric;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetricManager;
import io.atlassian.fugue.Unit;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MetricConditionRefManagerImpl
implements MetricConditionRefManager {
    private static final Logger log = LoggerFactory.getLogger(MetricConditionRefManagerImpl.class);
    private TimeMetricManager timeMetricManager;
    private MetricConditionRefQStore metricConditionRefQStore;
    private ConditionFactoryService conditionFactoryService;

    @Autowired
    public MetricConditionRefManagerImpl(TimeMetricManager timeMetricManager, MetricConditionRefQStore metricConditionRefQStore, ConditionFactoryService conditionFactoryService) {
        this.timeMetricManager = timeMetricManager;
        this.metricConditionRefQStore = metricConditionRefQStore;
        this.conditionFactoryService = conditionFactoryService;
    }

    @Override
    @Nonnull
    public io.atlassian.fugue.Either<ErrorCollection, MetricConditionRef> getMetricCondition(TimeMetric timeMetric, int id) {
        return (io.atlassian.fugue.Either)this.metricConditionRefQStore.getMetricCondition(timeMetric, id).fold(() -> StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.NOT_FOUND, (String)"condition not found", (Object[])new Object[0])), io.atlassian.fugue.Either::right);
    }

    @Override
    @Nonnull
    public List<MetricConditionRef> getMetricConditions(TimeMetric timeMetric) {
        return this.metricConditionRefQStore.getMetricConditionsForTimeMetric(timeMetric);
    }

    @Override
    @Nonnull
    public io.atlassian.fugue.Either<ErrorCollection, MetricConditionRef> createMetricCondition(TimeMetric timeMetric, MetricConditionRef metricConditionRef, boolean updateTimeMetricDate) {
        io.atlassian.fugue.Either<ErrorCollection, MetricConditionRef> validate2 = this.validate(metricConditionRef);
        if (validate2.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)validate2.left().get());
        }
        metricConditionRef = (MetricConditionRef)((Object)validate2.right().get());
        return (io.atlassian.fugue.Either)this.metricConditionRefQStore.createMetricCondition(timeMetric, metricConditionRef).fold(() -> StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.SERVER_ERROR, (String)"sd.error.can.not.create", (Object[])new Object[]{"MetricCondition"})), createdMetricCondition -> {
            this.updateTimeMetric(timeMetric, updateTimeMetricDate);
            return io.atlassian.fugue.Either.right((Object)createdMetricCondition);
        });
    }

    private void updateTimeMetric(TimeMetric timeMetric, boolean updateTimeMetricDate) {
        if (updateTimeMetricDate) {
            this.timeMetricManager.updateDefinitionChangeDateAndMsEpoch(timeMetric).left().foreach(errorCollection -> log.warn("Failed to update definition change data and ms from epoch values in Time Metric table for {} : {}", (Object)timeMetric.getId(), errorCollection));
        }
    }

    @Override
    public io.atlassian.fugue.Either<ErrorCollection, Unit> deleteMetricConditionByParams(TimeMetric timeMetric, MetricConditionRef metricConditionRef, boolean updateTimeMetricDate) {
        long linesDeleted = this.metricConditionRefQStore.deleteMetricCondition(timeMetric, metricConditionRef);
        if (linesDeleted == 1L) {
            this.updateTimeMetric(timeMetric, updateTimeMetricDate);
            return io.atlassian.fugue.Either.right((Object)Unit.Unit());
        }
        return StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.NOT_FOUND, (String)"No condition with given parameters exists", (Object[])new Object[0]));
    }

    private io.atlassian.fugue.Either<ErrorCollection, MetricConditionRef> validate(MetricConditionRef condition) {
        String pluginKey = StringUtils.defaultString((String)condition.getPluginKey()).trim();
        String factoryKey = StringUtils.defaultString((String)condition.getFactoryKey()).trim();
        String conditionId = StringUtils.defaultString((String)condition.getConditionId()).trim();
        if (pluginKey.isEmpty()) {
            return StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED, (String)"Plugin key must not be empty", (Object[])new Object[0]));
        }
        if (factoryKey.isEmpty()) {
            return StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED, (String)"Factory key must not be empty", (Object[])new Object[0]));
        }
        if (conditionId.isEmpty()) {
            return StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED, (String)"Condition id must not be empty", (Object[])new Object[0]));
        }
        if (condition.getType() == null) {
            return StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED, (String)"Condition type must not be null", (Object[])new Object[0]));
        }
        if (condition.getType() == ConditionType.START || condition.getType() == ConditionType.STOP) {
            TimeMetricHitConditionInfo hitCondition = this.conditionFactoryService.getHitCondition(condition.getPluginKey(), condition.getFactoryKey(), condition.getConditionId());
            if (!hitCondition.isComplete()) {
                return StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED, (String)("Cannot find HIT condition :" + condition.getPluginKey() + " " + condition.getFactoryKey() + " " + condition.getConditionId()), (Object[])new Object[0]));
            }
        } else {
            TimeMetricMatchConditionInfo matchCondition = this.conditionFactoryService.getMatchCondition(condition.getPluginKey(), condition.getFactoryKey(), condition.getConditionId());
            if (!matchCondition.isComplete()) {
                return StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED, (String)("Cannot find MATCH condition :" + condition.getPluginKey() + " " + condition.getFactoryKey() + " " + condition.getConditionId()), (Object[])new Object[0]));
            }
        }
        return io.atlassian.fugue.Either.right((Object)((Object)MetricConditionRef.builder(condition).pluginKey(pluginKey).factoryKey(factoryKey).conditionId(conditionId).build()));
    }
}

