/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.configuration.calendar;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.internal.api.ServiceDeskManager;
import com.google.common.collect.Maps;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ServiceDeskCalendarContextHelper {
    public static final String CONTEXT_KEY_SERVICE_DESK_ID = "serviceDeskId";
    public static final String CONTEXT_KEY_OWNER = "owner";
    public static final String CONTEXT_VALUE_OWNER_IS_SERVICE_DESK = "com.atlassian.servicedesk";
    Log log = Log.with(this.getClass());
    @Autowired
    private ServiceDeskManager serviceDeskManager;

    public Map<String, String> getContextForServiceDesk(ServiceDesk serviceDesk) {
        HashMap filter2 = Maps.newHashMap();
        filter2.put(CONTEXT_KEY_OWNER, CONTEXT_VALUE_OWNER_IS_SERVICE_DESK);
        filter2.put(CONTEXT_KEY_SERVICE_DESK_ID, String.valueOf(serviceDesk.getId()));
        return filter2;
    }

    public Option<ServiceDesk> getServiceDesk(Map<String, String> context) {
        String serviceDeskIdString = context.get(CONTEXT_KEY_SERVICE_DESK_ID);
        if (StringUtils.isEmpty((String)serviceDeskIdString)) {
            return Option.none();
        }
        Long serviceDeskId = null;
        try {
            serviceDeskId = Long.valueOf(serviceDeskIdString);
        }
        catch (NumberFormatException e) {
            this.log.debug("Invalid service desk id specified in context: " + context.toString(), new Object[0]);
        }
        if (serviceDeskId == null) {
            return Option.none();
        }
        Either serviceDeskById = this.serviceDeskManager.getServiceDeskById(serviceDeskId.intValue());
        return serviceDeskById.right().toOption();
    }

    public boolean isOwnerServiceDesk(Map<String, String> context) {
        return context.containsKey(CONTEXT_KEY_OWNER) && context.get(CONTEXT_KEY_OWNER).equals(CONTEXT_VALUE_OWNER_IS_SERVICE_DESK);
    }

    public String getServiceDeskId(Map<String, String> context) {
        return context.get(CONTEXT_KEY_SERVICE_DESK_ID);
    }
}

