/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.configuration.calendar;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.plugins.workinghours.api.calendar.Calendar;
import com.atlassian.jira.plugins.workinghours.api.calendar.CalendarInfo;
import com.atlassian.jira.plugins.workinghours.api.calendar.access.Operation;
import com.atlassian.jira.plugins.workinghours.spi.calendar.access.CalendarAccess;
import com.atlassian.jira.plugins.workinghours.spi.calendar.access.Outcome;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.pocketknife.api.util.ServiceResult;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.internal.api.sla.configuration.calendar.CalendarReference;
import com.atlassian.servicedesk.internal.api.sla.configuration.calendar.CalendarReferenceManager;
import com.atlassian.servicedesk.internal.sla.configuration.calendar.ServiceDeskCalendarContextHelper;
import com.atlassian.servicedesk.internal.sla.configuration.goal.Goal;
import com.atlassian.servicedesk.internal.sla.configuration.goal.GoalManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class ServiceDeskCalendarAccess
implements CalendarAccess {
    private final PermissionManager permissionManager;
    private final ProjectManager projectManager;
    private final GlobalPermissionManager globalPermissionManager;
    private final ServiceDeskCalendarContextHelper contextHelper;
    private final CalendarReferenceManager calendarReferenceManager;
    private final GoalManager goalManager;

    @Autowired
    public ServiceDeskCalendarAccess(PermissionManager permissionManager, ProjectManager projectManager, GlobalPermissionManager globalPermissionManager, ServiceDeskCalendarContextHelper contextHelper, CalendarReferenceManager calendarReferenceManager, GoalManager goalManager) {
        this.permissionManager = permissionManager;
        this.projectManager = projectManager;
        this.globalPermissionManager = globalPermissionManager;
        this.contextHelper = contextHelper;
        this.calendarReferenceManager = calendarReferenceManager;
        this.goalManager = goalManager;
    }

    public Outcome matchesFilter(ApplicationUser user, CalendarInfo info, Map<String, String> filter2) {
        if (!this.contextHelper.isOwnerServiceDesk(filter2)) {
            return Outcome.ABSTAIN;
        }
        if (!this.contextHelper.isOwnerServiceDesk(info.getContext())) {
            return Outcome.NO;
        }
        String filterServiceDeskId = this.contextHelper.getServiceDeskId(filter2);
        if (filterServiceDeskId == null) {
            return Outcome.YES;
        }
        String calendarSDId = this.contextHelper.getServiceDeskId(info.getContext());
        if (filterServiceDeskId.equals(calendarSDId)) {
            return Outcome.YES;
        }
        return Outcome.NO;
    }

    public Outcome hasPermission(ApplicationUser user, Map<String, String> context, Operation operation) {
        if (operation == Operation.VIEW) {
            return this.checkPermission(user, context, ProjectPermissions.BROWSE_PROJECTS);
        }
        return this.checkPermission(user, context, ProjectPermissions.ADMINISTER_PROJECTS);
    }

    private Outcome checkPermission(ApplicationUser user, Map<String, String> context, ProjectPermissionKey permissionKey) {
        if (!this.contextHelper.isOwnerServiceDesk(context)) {
            return Outcome.ABSTAIN;
        }
        io.atlassian.fugue.Option<ServiceDesk> serviceDesk = this.contextHelper.getServiceDesk(context);
        if (serviceDesk.isEmpty()) {
            return this.administrator(user);
        }
        Project project = this.projectManager.getProjectObj(Long.valueOf(((ServiceDesk)serviceDesk.get()).getProjectId()));
        if (project == null) {
            return this.administrator(user);
        }
        boolean hasPermission = this.permissionManager.hasPermission(permissionKey, project, user);
        if (hasPermission) {
            return Outcome.YES;
        }
        return this.administrator(user);
    }

    public Either<ErrorCollection, Option<Object>> validate(ApplicationUser user, Calendar calendar, Operation operation) {
        if (operation == Operation.DELETE) {
            return this.validateDelete(calendar);
        }
        return ServiceResult.ok();
    }

    public List<String> getOperationMessages(ApplicationUser user, Calendar calendar, Operation operation) {
        if (operation == Operation.UPDATE) {
            ArrayList<String> messageList = new ArrayList<String>();
            I18nBean textHelper = new I18nBean(user);
            messageList.add(textHelper.getText("sd.sla.configuration.metric.save.sla.changes.dialog.message"));
            return messageList;
        }
        return new ArrayList<String>();
    }

    private Either<ErrorCollection, Option<Object>> validateDelete(Calendar calendar) {
        CalendarReference calendarReference = this.calendarReferenceManager.getReferenceForCalendar(calendar);
        List<Goal> affectedGoals = this.goalManager.getByCalendar(calendarReference);
        if (affectedGoals.isEmpty()) {
            return ServiceResult.ok();
        }
        return ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED, (String)"sd.sla.configuration.metric.calendar.cannot.delete", (Object[])new Object[]{affectedGoals.size()});
    }

    private Outcome administrator(ApplicationUser user) {
        boolean isAdmin = this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user);
        return isAdmin ? Outcome.YES : Outcome.NO;
    }
}

