/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.configuration.calendar;

import com.atlassian.fugue.Either;
import com.atlassian.jira.plugins.workinghours.api.calculator.WorkingHoursCalculator;
import com.atlassian.jira.plugins.workinghours.api.calculator.WorkingHoursCalculatorService;
import com.atlassian.jira.plugins.workinghours.api.calendar.Calendar;
import com.atlassian.jira.plugins.workinghours.api.calendar.CalendarInfo;
import com.atlassian.jira.plugins.workinghours.api.calendar.CalendarManager;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.internal.api.sla.configuration.calendar.CalendarReference;
import com.atlassian.servicedesk.internal.api.sla.configuration.calendar.CalendarReferenceManager;
import com.atlassian.servicedesk.internal.api.sla.goal.Goal;
import com.atlassian.servicedesk.internal.sla.configuration.calendar.CalendarInfoCalendarReference;
import com.atlassian.servicedesk.internal.sla.configuration.calendar.DefaultCalendarReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class CalendarReferenceManagerImpl
implements CalendarReferenceManager {
    @Autowired
    private CalendarManager calendarManager;
    @Autowired
    private WorkingHoursCalculatorService workingHoursCalculatorService;
    private CalendarReference defaultReference = new DefaultCalendarReference();

    public CalendarReference getReferenceForGoal(Goal goal) {
        if (goal.getCalendarId() == null) {
            return this.getDefaultReference();
        }
        io.atlassian.fugue.Either info = StepsConverters.newerEither((Either)this.calendarManager.getInfo(goal.getCalendarId().intValue()));
        if (info.isLeft()) {
            return this.getDefaultReference();
        }
        return new CalendarInfoCalendarReference((CalendarInfo)info.right().get());
    }

    public CalendarReference getReferenceForCalendar(Calendar calendar) {
        return new CalendarInfoCalendarReference((CalendarInfo)calendar);
    }

    public WorkingHoursCalculator getCalculatorForGoal(Goal goal) {
        CalendarReference reference = this.getReferenceForGoal(goal);
        return this.getCalculatorForReference(reference);
    }

    public WorkingHoursCalculator getCalculatorForReference(CalendarReference reference) {
        if (reference.isDefaultCalendar()) {
            return this.getDefaultCalculator();
        }
        io.atlassian.fugue.Either fromInfo = StepsConverters.newerEither((Either)this.calendarManager.getFromInfo((CalendarInfo)reference.getCalendarInfo().get()));
        if (fromInfo.isLeft()) {
            return this.getDefaultCalculator();
        }
        return this.workingHoursCalculatorService.getCalculatorForCalendar((Calendar)fromInfo.right().get());
    }

    public WorkingHoursCalculator getDefaultCalculator() {
        return this.workingHoursCalculatorService.getAlwaysOnCalculator();
    }

    public CalendarReference getDefaultReference() {
        return this.defaultReference;
    }
}

