/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.configuration;

import com.atlassian.fugue.Either;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.pocketknife.api.util.ServiceResult;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.internal.sla.condition.ConditionFactoryService;
import com.atlassian.servicedesk.internal.sla.condition.TimeMetricConditionInfo;
import com.atlassian.servicedesk.internal.sla.condition.TimeMetricHitConditionInfo;
import com.atlassian.servicedesk.internal.sla.condition.TimeMetricMatchConditionInfo;
import com.atlassian.servicedesk.internal.sla.configuration.TimeMetricDefinition;
import com.atlassian.servicedesk.internal.sla.configuration.TimeMetricDefinitionInfo;
import com.atlassian.servicedesk.internal.sla.configuration.TimeMetricDefinitionManager;
import com.atlassian.servicedesk.internal.sla.configuration.condition.ConditionType;
import com.atlassian.servicedesk.internal.sla.configuration.condition.MetricConditionRef;
import com.atlassian.servicedesk.internal.sla.configuration.condition.MetricConditionRefManager;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetric;
import com.atlassian.servicedesk.internal.sla.configuration.timemetric.TimeMetricManager;
import com.atlassian.servicedesk.spi.sla.condition.TimeMetricHitCondition;
import com.atlassian.servicedesk.spi.sla.condition.TimeMetricMatchCondition;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Unit;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TimeMetricDefinitionManagerImpl
implements TimeMetricDefinitionManager {
    private static final Logger log = LoggerFactory.getLogger(TimeMetricDefinitionManagerImpl.class);
    @Autowired
    private MetricConditionRefManager metricConditionRefManager;
    @Autowired
    private TimeMetricManager timeMetricManager;
    @Autowired
    private ConditionFactoryService conditionFactoryService;

    @Override
    public TimeMetricDefinition<TimeMetricHitCondition, TimeMetricMatchCondition> loadDefinition(TimeMetric timeMetric) {
        List<MetricConditionRef> conditions = this.metricConditionRefManager.getMetricConditions(timeMetric);
        return this.loadDefinition(conditions);
    }

    @Override
    public TimeMetricDefinition<TimeMetricHitCondition, TimeMetricMatchCondition> loadDefinition(List<MetricConditionRef> conditions) {
        TimeMetricDefinition<TimeMetricHitCondition, TimeMetricMatchCondition> runtime = new TimeMetricDefinition<TimeMetricHitCondition, TimeMetricMatchCondition>();
        for (MetricConditionRef c : conditions) {
            switch (c.getType()) {
                case START: {
                    TimeMetricHitConditionInfo startConditionInfo = this.conditionFactoryService.getHitCondition(c.getPluginKey(), c.getFactoryKey(), c.getConditionId());
                    if (!startConditionInfo.isComplete()) break;
                    runtime.addStartCondition((TimeMetricHitCondition)startConditionInfo.getCondition());
                    break;
                }
                case PAUSE: {
                    TimeMetricMatchConditionInfo pauseConditionInfo = this.conditionFactoryService.getMatchCondition(c.getPluginKey(), c.getFactoryKey(), c.getConditionId());
                    if (!pauseConditionInfo.isComplete()) break;
                    runtime.addPauseCondition((TimeMetricMatchCondition)pauseConditionInfo.getCondition());
                    break;
                }
                case STOP: {
                    TimeMetricHitConditionInfo stopConditionInfo = this.conditionFactoryService.getHitCondition(c.getPluginKey(), c.getFactoryKey(), c.getConditionId());
                    if (!stopConditionInfo.isComplete()) break;
                    runtime.addStopCondition((TimeMetricHitCondition)stopConditionInfo.getCondition());
                }
            }
        }
        return runtime;
    }

    @Override
    public TimeMetricDefinitionInfo loadDefinitionConfiguration(TimeMetric timeMetric) {
        List<MetricConditionRef> conditions = this.metricConditionRefManager.getMetricConditions(timeMetric);
        TimeMetricDefinitionInfo info = new TimeMetricDefinitionInfo();
        for (MetricConditionRef c : conditions) {
            switch (c.getType()) {
                case START: {
                    TimeMetricHitConditionInfo startConditionInfo = this.conditionFactoryService.getHitCondition(c.getPluginKey(), c.getFactoryKey(), c.getConditionId());
                    info.addStartCondition(startConditionInfo);
                    break;
                }
                case PAUSE: {
                    TimeMetricMatchConditionInfo pauseConditionInfo = this.conditionFactoryService.getMatchCondition(c.getPluginKey(), c.getFactoryKey(), c.getConditionId());
                    info.addPauseCondition(pauseConditionInfo);
                    break;
                }
                case STOP: {
                    TimeMetricHitConditionInfo stopConditionInfo = this.conditionFactoryService.getHitCondition(c.getPluginKey(), c.getFactoryKey(), c.getConditionId());
                    info.addStopCondition(stopConditionInfo);
                }
            }
        }
        return info;
    }

    @Override
    public io.atlassian.fugue.Either<ErrorCollection, Unit> validateDefinitionConfiguration(ServiceDesk serviceDesk, TimeMetricDefinitionInfo definition) {
        io.atlassian.fugue.Either<ErrorCollection, TimeMetricConditionInfo> conditionResult;
        if (definition.getStartConditions().size() == 0 || definition.getStopConditions().size() == 0) {
            return StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED, (String)"sd.sla.configuration.metric.condition.at.least.one.start.stop", (Object[])new Object[0]));
        }
        for (TimeMetricConditionInfo start : definition.getStartConditions()) {
            conditionResult = this.validateCondition(start, true);
            if (!conditionResult.isLeft()) continue;
            return io.atlassian.fugue.Either.left((Object)conditionResult.left().get());
        }
        for (TimeMetricConditionInfo pause : definition.getPauseConditions()) {
            conditionResult = this.validateCondition(pause, false);
            if (!conditionResult.isLeft()) continue;
            return io.atlassian.fugue.Either.left((Object)conditionResult.left().get());
        }
        for (TimeMetricConditionInfo stop : definition.getStopConditions()) {
            conditionResult = this.validateCondition(stop, true);
            if (!conditionResult.isLeft()) continue;
            return io.atlassian.fugue.Either.left((Object)conditionResult.left().get());
        }
        return io.atlassian.fugue.Either.right((Object)Unit.Unit());
    }

    @Override
    public io.atlassian.fugue.Either<ErrorCollection, TimeMetricDefinitionInfo> updateDefinitionConfiguration(ServiceDesk serviceDesk, TimeMetric timeMetric, TimeMetricDefinitionInfo definition) {
        boolean hasChanges;
        io.atlassian.fugue.Either<ErrorCollection, Unit> validDefinition = this.validateDefinitionConfiguration(serviceDesk, definition);
        if (validDefinition.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)validDefinition.left().get());
        }
        List<MetricConditionRef> existingRefs = this.metricConditionRefManager.getMetricConditions(timeMetric);
        HashSet reusedRefs = Sets.newHashSet();
        HashSet newRefs = Sets.newHashSet();
        this.processConditions(existingRefs, new HashSet<TimeMetricConditionInfo>(definition.getStartConditions()), ConditionType.START, reusedRefs, newRefs);
        this.processConditions(existingRefs, new HashSet<TimeMetricConditionInfo>(definition.getPauseConditions()), ConditionType.PAUSE, reusedRefs, newRefs);
        this.processConditions(existingRefs, new HashSet<TimeMetricConditionInfo>(definition.getStopConditions()), ConditionType.STOP, reusedRefs, newRefs);
        HashSet obsoleteRefs = Sets.newHashSet(existingRefs);
        obsoleteRefs.removeAll(reusedRefs);
        for (MetricConditionRef ref : obsoleteRefs) {
            this.metricConditionRefManager.deleteMetricConditionByParams(timeMetric, ref, false);
        }
        for (MetricConditionRef ref : newRefs) {
            this.metricConditionRefManager.createMetricCondition(timeMetric, ref, false);
        }
        boolean bl = hasChanges = !obsoleteRefs.isEmpty() || !newRefs.isEmpty();
        if (hasChanges) {
            this.timeMetricManager.updateDefinitionChangeDateAndMsEpoch(timeMetric).left().forEach(errorCollection -> log.warn("Failed to update definition change data and ms from epoch values in Time Metric table for {} : {}", (Object)timeMetric.getId(), errorCollection));
        }
        return io.atlassian.fugue.Either.right((Object)this.loadDefinitionConfiguration(timeMetric));
    }

    private void processConditions(List<MetricConditionRef> existingRefs, Set<TimeMetricConditionInfo> infos, ConditionType type, Set<MetricConditionRef> reusedRefs, Set<MetricConditionRef> newRefs) {
        for (TimeMetricConditionInfo info : infos) {
            MetricConditionRef ref = this.findRef(existingRefs, info, type);
            if (ref != null) {
                reusedRefs.add(ref);
                continue;
            }
            MetricConditionRef newRef = MetricConditionRef.builder().pluginKey(info.getPluginKey()).factoryKey(info.getConditionFactoryKey()).conditionId(info.getConditionId()).type(type).build();
            newRefs.add(newRef);
        }
    }

    private MetricConditionRef findRef(List<MetricConditionRef> refs, TimeMetricConditionInfo info, ConditionType type) {
        for (MetricConditionRef ref : refs) {
            if (!ref.getPluginKey().equals(info.getPluginKey()) || !ref.getFactoryKey().equals(info.getConditionFactoryKey()) || !ref.getConditionId().equals(info.getConditionId()) || !ref.getType().equals((Object)type)) continue;
            return ref;
        }
        return null;
    }

    private io.atlassian.fugue.Either<ErrorCollection, TimeMetricConditionInfo> validateCondition(TimeMetricConditionInfo condition, boolean hitCondition) {
        TimeMetricConditionInfo conditionInfo = hitCondition ? this.conditionFactoryService.getHitCondition(condition.getPluginKey(), condition.getConditionFactoryKey(), condition.getConditionId()) : this.conditionFactoryService.getMatchCondition(condition.getPluginKey(), condition.getConditionFactoryKey(), condition.getConditionId());
        if (!conditionInfo.isComplete()) {
            return StepsConverters.newerEither((Either)ServiceResult.error((ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED, (String)"sd.sla.configuration.metric.condition.invalid.condition", (Object[])new Object[]{condition.getPluginKey(), condition.getConditionFactoryKey(), condition.getConditionId()}));
        }
        return io.atlassian.fugue.Either.right((Object)conditionInfo);
    }
}

