/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.condition.factory;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.changehistory.ChangeHistoryManager;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.servicedesk.api.sla.condition.HitConditionHistory;
import com.atlassian.servicedesk.api.sla.condition.HitConditionHistoryBuilder;
import com.atlassian.servicedesk.api.sla.condition.HitEvent;
import com.atlassian.servicedesk.api.sla.condition.MatchConditionHistory;
import com.atlassian.servicedesk.api.sla.condition.MatchConditionHistoryBuilder;
import com.atlassian.servicedesk.api.sla.condition.MatchEvent;
import com.atlassian.servicedesk.api.sla.event.SLAChangeEvent;
import com.atlassian.servicedesk.internal.api.events.ChangeItemBeanUtils;
import com.atlassian.servicedesk.internal.api.listener.FieldChangeType;
import com.atlassian.servicedesk.internal.sla.condition.factory.ConditionHelper;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StatusConditionHelper
extends ConditionHelper {
    private static final Logger logger = LoggerFactory.getLogger(StatusConditionHelper.class);
    private final ChangeHistoryManager changeHistoryManager;
    private final ChangeItemBeanUtils changeItemBeanUtils;

    @Autowired
    public StatusConditionHelper(ChangeHistoryManager changeHistoryManager, ChangeItemBeanUtils changeItemBeanUtils) {
        super(changeHistoryManager, changeItemBeanUtils);
        this.changeHistoryManager = changeHistoryManager;
        this.changeItemBeanUtils = changeItemBeanUtils;
    }

    public MatchConditionHistory getMatchHistory(Issue issue, Status status) {
        String matchValue = status.getId();
        List changeItems = this.changeHistoryManager.getChangeItemsForField(issue, "status");
        MatchConditionHistoryBuilder builder = MatchConditionHistoryBuilder.newBuilder();
        if (CollectionUtils.isEmpty((Collection)changeItems)) {
            if (matchValue.equals(issue.getStatus().getId())) {
                builder.addEntry(new DateTime(issue.getCreated().getTime()), MatchEvent.MATCH);
            } else {
                builder.addEntry(new DateTime(issue.getCreated().getTime()), MatchEvent.INVERSE_MATCH);
            }
        } else {
            for (ChangeItemBean bean : changeItems) {
                FieldChangeType fieldChangeType = this.changeItemBeanUtils.extractFieldChangeType(bean, issue);
                switch (fieldChangeType) {
                    case SET: {
                        if (!Objects.equals(matchValue, bean.getTo())) break;
                        if (builder.isEmpty()) {
                            builder.addEntry(new DateTime(issue.getCreated().getTime()), MatchEvent.INVERSE_MATCH);
                        }
                        builder.addEntry(new DateTime(bean.getCreated().getTime()), MatchEvent.MATCH);
                        break;
                    }
                    case CLEAR: {
                        if (!Objects.equals(matchValue, bean.getFrom())) break;
                        if (builder.isEmpty()) {
                            builder.addEntry(new DateTime(issue.getCreated().getTime()), MatchEvent.MATCH);
                        }
                        builder.addEntry(new DateTime(bean.getCreated().getTime()), MatchEvent.INVERSE_MATCH);
                        break;
                    }
                    case UPDATE: {
                        if (!Objects.equals(matchValue, bean.getFrom()) && Objects.equals(matchValue, bean.getTo())) {
                            if (builder.isEmpty()) {
                                builder.addEntry(new DateTime(issue.getCreated().getTime()), MatchEvent.INVERSE_MATCH);
                            }
                            builder.addEntry(new DateTime(bean.getCreated().getTime()), MatchEvent.MATCH);
                            break;
                        }
                        if (!Objects.equals(matchValue, bean.getFrom()) || Objects.equals(matchValue, bean.getTo())) break;
                        if (builder.isEmpty()) {
                            builder.addEntry(new DateTime(issue.getCreated().getTime()), MatchEvent.MATCH);
                        }
                        builder.addEntry(new DateTime(bean.getCreated().getTime()), MatchEvent.INVERSE_MATCH);
                        break;
                    }
                }
            }
        }
        return builder.build();
    }

    MatchEvent getStatusMatch(Issue issue, Status status) {
        if (Objects.equals(issue.getStatus(), status)) {
            return MatchEvent.MATCH;
        }
        return MatchEvent.INVERSE_MATCH;
    }

    HitEvent getStatusHit(SLAChangeEvent event, Status status) {
        boolean hasIssueJustBeenCreated = event.isIssueCreatedEvent();
        Issue issue = (Issue)Assertions.notNull((String)"issue", (Object)event.getIssue());
        String issueKey = issue.getKey();
        if (logger.isDebugEnabled()) {
            logger.debug("Issue: {}, check that we're transitioning to {}", (Object)issueKey, (Object)status.getName());
            logger.debug("was the issue just created?: {}", (Object)hasIssueJustBeenCreated);
        }
        if (hasIssueJustBeenCreated) {
            if (issue.getStatus() != null && Objects.equals(status.getId(), issue.getStatus().getId())) {
                logger.debug("{}: the status update matches so lets record a Start event", (Object)issueKey);
                return HitEvent.HIT;
            }
        } else {
            return event.getChangeItemForField("status").map(changeItem -> this.checkIfStatusChangedAndHit(status, issue, (ChangeItemBean)changeItem)).orElseGet(() -> {
                logger.debug("{}: the changeItem was null", (Object)issueKey);
                return HitEvent.NO_HIT;
            });
        }
        return HitEvent.NO_HIT;
    }

    private HitEvent checkIfStatusChangedAndHit(Status status, Issue issue, ChangeItemBean changeItem) {
        logger.debug("{} status change from {} to {}", new Object[]{issue.getKey(), changeItem.getFromString(), changeItem.getToString()});
        if (this.changeItemBeanUtils.isChangeToAnotherValue(changeItem, issue) && Objects.equals(status.getId(), changeItem.getTo())) {
            logger.debug("{}: the status update matches so lets record a Start event", (Object)issue.getKey());
            return HitEvent.HIT;
        }
        return HitEvent.NO_HIT;
    }

    HitConditionHistory getHitHistory(Issue issue, Status status) {
        List changeItems = this.changeHistoryManager.getChangeItemsForField(issue, "status");
        HitConditionHistoryBuilder builder = HitConditionHistoryBuilder.newBuilder();
        if (CollectionUtils.isEmpty((Collection)changeItems)) {
            if (Objects.equals(status.getId(), issue.getStatus().getId())) {
                builder.addHit(new DateTime(issue.getCreated().getTime()));
            }
        } else {
            for (ChangeItemBean bean : changeItems) {
                if (builder.isEmpty() && Objects.equals(status.getId(), bean.getFrom())) {
                    builder.addHit(new DateTime(issue.getCreated().getTime()));
                }
                if (!this.changeItemBeanUtils.isChangeToAnotherValue(bean, issue) || Objects.equals(status.getId(), bean.getFrom()) || !Objects.equals(status.getId(), bean.getTo())) continue;
                builder.addHit(new DateTime(bean.getCreated().getTime()));
            }
        }
        return builder.build();
    }
}

