/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.condition.factory;

import com.atlassian.jira.project.Project;
import com.atlassian.servicedesk.internal.sla.condition.factory.ResolutionClearedHitCondition;
import com.atlassian.servicedesk.internal.sla.condition.factory.ResolutionConditionHelper;
import com.atlassian.servicedesk.internal.sla.condition.factory.ResolutionNotSetMatchCondition;
import com.atlassian.servicedesk.internal.sla.condition.factory.ResolutionSetHitCondition;
import com.atlassian.servicedesk.internal.sla.condition.factory.ResolutionSetMatchCondition;
import com.atlassian.servicedesk.spi.sla.condition.TimeMetricConditionFactory;
import com.atlassian.servicedesk.spi.sla.condition.TimeMetricHitCondition;
import com.atlassian.servicedesk.spi.sla.condition.TimeMetricMatchCondition;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;

public class ResolutionTimeMetricConditionFactory
implements TimeMetricConditionFactory {
    public static final String FACTORY_ID = "resolution-sla-condition-factory";
    private TimeMetricMatchCondition resolutionNotSetMatchCondition;
    private TimeMetricMatchCondition resolutionIsSetMatchCondition;
    private TimeMetricHitCondition resolutionIsSetHitCondition;
    private TimeMetricHitCondition resolutionClearedHitCondition;
    @Autowired
    private ResolutionConditionHelper helper;

    @PostConstruct
    public void onSpringContextStarted() {
        this.resolutionNotSetMatchCondition = new ResolutionNotSetMatchCondition(this.helper);
        this.resolutionIsSetMatchCondition = new ResolutionSetMatchCondition(this.helper);
        this.resolutionIsSetHitCondition = new ResolutionSetHitCondition(this.helper);
        this.resolutionClearedHitCondition = new ResolutionClearedHitCondition(this.helper);
    }

    public TimeMetricMatchCondition getMatchCondition(String id) {
        if (this.resolutionNotSetMatchCondition.getId().equals(id)) {
            return this.resolutionNotSetMatchCondition;
        }
        if (this.resolutionIsSetMatchCondition.getId().equals(id)) {
            return this.resolutionIsSetMatchCondition;
        }
        return null;
    }

    public TimeMetricHitCondition getHitCondition(String id) {
        if (this.resolutionIsSetHitCondition.getId().equals(id)) {
            return this.resolutionIsSetHitCondition;
        }
        if (this.resolutionClearedHitCondition.getId().equals(id)) {
            return this.resolutionClearedHitCondition;
        }
        return null;
    }

    public List<? extends TimeMetricMatchCondition> getAllMatchConditions(Project project) {
        return Lists.newArrayList((Object[])new TimeMetricMatchCondition[]{this.resolutionIsSetMatchCondition, this.resolutionNotSetMatchCondition});
    }

    public List<? extends TimeMetricHitCondition> getAllHitConditions(Project project) {
        return Lists.newArrayList((Object[])new TimeMetricHitCondition[]{this.resolutionIsSetHitCondition, this.resolutionClearedHitCondition});
    }
}

