/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.condition.factory;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.servicedesk.api.sla.condition.MatchConditionHistory;
import com.atlassian.servicedesk.api.sla.condition.MatchEvent;
import com.atlassian.servicedesk.api.sla.event.SLAChangeEvent;
import com.atlassian.servicedesk.internal.sla.condition.factory.InternalTimeMetricCondition;
import com.atlassian.servicedesk.internal.sla.condition.factory.ResolutionConditionHelper;
import com.atlassian.servicedesk.spi.sla.condition.TimeMetricMatchCondition;

class ResolutionSetMatchCondition
implements TimeMetricMatchCondition,
InternalTimeMetricCondition {
    private static final String CONDITION_ID = "resolution-set-match-condition";
    private final ResolutionConditionHelper helper;

    ResolutionSetMatchCondition(ResolutionConditionHelper helper) {
        this.helper = helper;
    }

    public String getId() {
        return CONDITION_ID;
    }

    public String getName(I18nHelper i18n) {
        return i18n.getText(this.getI18nNameKey());
    }

    public String getNameHtml(I18nHelper i18n) {
        return this.getName(i18n);
    }

    public MatchEvent evaluate(Issue issue, SLAChangeEvent event) {
        return this.helper.getResolutionMatch(issue);
    }

    public MatchConditionHistory getHistory(Issue issue) {
        return this.helper.getMatchHistoryForResolved(issue);
    }

    @Override
    public String getI18nNameKey() {
        return "sd.sla.condition.match.resolution.set";
    }
}

