/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.condition.factory;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.changehistory.ChangeHistoryManager;
import com.atlassian.servicedesk.api.sla.condition.HitConditionHistory;
import com.atlassian.servicedesk.api.sla.condition.HitEvent;
import com.atlassian.servicedesk.api.sla.condition.MatchConditionHistory;
import com.atlassian.servicedesk.api.sla.condition.MatchEvent;
import com.atlassian.servicedesk.api.sla.event.SLAChangeEvent;
import com.atlassian.servicedesk.internal.api.events.ChangeItemBeanUtils;
import com.atlassian.servicedesk.internal.api.listener.FieldChangeType;
import com.atlassian.servicedesk.internal.sla.condition.factory.ConditionHelper;
import com.google.common.base.Strings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class ResolutionConditionHelper
extends ConditionHelper {
    private final ChangeItemBeanUtils changeItemBeanUtils;

    @Autowired
    public ResolutionConditionHelper(ChangeHistoryManager changeHistoryManager, ChangeItemBeanUtils changeItemBeanUtils) {
        super(changeHistoryManager, changeItemBeanUtils);
        this.changeItemBeanUtils = changeItemBeanUtils;
    }

    MatchConditionHistory getMatchHistoryForResolved(Issue issue) {
        return this.getMatchHistoryForField(issue, issue.getResolutionId(), "resolution", MatchEvent.MATCH, MatchEvent.INVERSE_MATCH);
    }

    MatchConditionHistory getMatchHistoryForNotResolved(Issue issue) {
        return this.getMatchHistoryForField(issue, issue.getResolutionId(), "resolution", MatchEvent.INVERSE_MATCH, MatchEvent.MATCH);
    }

    MatchEvent getResolutionMatch(Issue issue) {
        if (issue.getResolution() != null) {
            return MatchEvent.MATCH;
        }
        return MatchEvent.INVERSE_MATCH;
    }

    MatchEvent getNoResolutionMatch(Issue issue) {
        if (issue.getResolution() != null) {
            return MatchEvent.INVERSE_MATCH;
        }
        return MatchEvent.MATCH;
    }

    HitEvent getResolutionSetHit(SLAChangeEvent event) {
        if (event.isIssueCreatedEvent()) {
            if (!Strings.isNullOrEmpty((String)event.getIssue().getResolutionId())) {
                return HitEvent.HIT;
            }
        } else {
            return event.getChangeItemForField("resolution").map(changeItemBean -> this.changeItemBeanUtils.extractFieldChangeType(changeItemBean, event.getIssue())).map(changeType -> FieldChangeType.SET.equals(changeType) ? HitEvent.HIT : HitEvent.NO_HIT).orElseGet(() -> HitEvent.NO_HIT);
        }
        return HitEvent.NO_HIT;
    }

    HitEvent getResolutionClearedHit(SLAChangeEvent event) {
        return event.getChangeItemForField("resolution").map(changeItemBean -> this.changeItemBeanUtils.extractFieldChangeType(changeItemBean, event.getIssue())).map(changeType -> FieldChangeType.CLEAR.equals(changeType) ? HitEvent.HIT : HitEvent.NO_HIT).orElseGet(() -> HitEvent.NO_HIT);
    }

    HitConditionHistory getHitHistoryForResolved(Issue issue) {
        return this.getHitHistoryForFieldValueSet(issue, issue.getResolutionId(), "resolution");
    }

    HitConditionHistory getHitHistoryForUnResolved(Issue issue) {
        return this.getHitHistoryForFieldValueCleared(issue, "resolution");
    }
}

