/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.condition.factory;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.servicedesk.api.sla.condition.HitConditionHistory;
import com.atlassian.servicedesk.api.sla.condition.HitEvent;
import com.atlassian.servicedesk.api.sla.event.SLAChangeEvent;
import com.atlassian.servicedesk.internal.sla.condition.factory.InternalTimeMetricCondition;
import com.atlassian.servicedesk.internal.sla.condition.factory.ResolutionConditionHelper;
import com.atlassian.servicedesk.spi.sla.condition.TimeMetricHitCondition;

public class ResolutionClearedHitCondition
implements TimeMetricHitCondition,
InternalTimeMetricCondition {
    public static final String CONDITION_ID = "resolution-cleared-hit-condition";
    private final ResolutionConditionHelper helper;

    ResolutionClearedHitCondition(ResolutionConditionHelper helper) {
        this.helper = helper;
    }

    public String getId() {
        return CONDITION_ID;
    }

    public String getName(I18nHelper i18n) {
        return i18n.getText(this.getI18nNameKey());
    }

    public String getNameHtml(I18nHelper i18n) {
        return this.getName(i18n);
    }

    public HitEvent evaluate(Issue issue, SLAChangeEvent event) {
        return this.helper.getResolutionClearedHit(event);
    }

    public HitConditionHistory getHistory(Issue issue) {
        return this.helper.getHitHistoryForUnResolved(issue);
    }

    @Override
    public String getI18nNameKey() {
        return "sd.sla.condition.hit.resolution.cleared";
    }
}

