/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.sla.condition.factory;

import com.atlassian.jira.issue.Issue;
import com.atlassian.servicedesk.api.sla.condition.HitConditionHistory;
import com.atlassian.servicedesk.api.sla.condition.HitConditionHistoryBuilder;
import com.atlassian.servicedesk.api.sla.condition.HitEvent;
import com.atlassian.servicedesk.api.sla.event.SLAChangeEvent;
import org.joda.time.DateTime;
import org.springframework.stereotype.Component;

@Component
class IssueCreatedConditionHelper {
    IssueCreatedConditionHelper() {
    }

    HitConditionHistory getHistory(Issue issue) {
        HitConditionHistoryBuilder builder = HitConditionHistoryBuilder.newBuilder();
        builder.addHit(new DateTime(issue.getCreated().getTime()));
        return builder.build();
    }

    HitEvent getCreated(SLAChangeEvent event) {
        if (event.isIssueCreatedEvent()) {
            return HitEvent.HIT;
        }
        return HitEvent.NO_HIT;
    }
}

